LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

--------------------------------------------------------------------------------
-- Function
-- 1.To connect input_bus and SRAM, test its functionality
--------------------------------------------------------------------------------


entity tb_bus_single_memory is
end tb_bus_single_memory;

architecture tb_bus_single_memory_arc of tb_bus_single_memory is

component input_bus is
    port(    bus_clk    : IN std_logic;
             bus_reset  : in std_logic;

             bus_enable : in std_logic;   
             dram_data_valid : out std_logic;
             dram_data  : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;

component  SRAM is
    Port ( 

        sram_clk                  : in  STD_LOGIC;
        sram_reset                : in  STD_LOGIC;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        dram_data_valid    		  : in  std_logic;
        sram_read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;

        sram_full            : out  std_logic;
        sram_data            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        row_starting_address : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_read_data_valid : out std_logic
    );

end component;

--------------------------------------------------------------------------------
signal clk,reset,bus_enable : std_logic;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
signal sram_read_address : std_logic_vector (SIZE_sram_address-1 downto 0);
signal sram_write_en,sram_read_en,sram_enable,sram_full  : std_logic;
signal dram_data_connection : std_logic_vector(bus_width-1 downto 0);
signal sram_data_tb_out : std_logic_vector(memory_cell_width-1 downto 0);
signal row_starting_address_tb_out : std_logic_vector (SIZE_sram_address-1 downto 0);
signal dram_data_valid_connection : std_logic;
signal sram_read_data_valid_con : std_logic;
constant tb_clk: time := 10 ns;
begin

DUT_input_bus : input_bus port map
 (
	bus_clk   => clk,      
	bus_reset  => reset,      
	bus_enable  => bus_enable, 
	dram_data_valid  => dram_data_valid_connection,
	dram_data   => dram_data_connection
 );

DUT_SRAM : SRAM port map

(
	
	sram_clk       		 => clk,          
	sram_reset           => reset,  
	dram_data            => dram_data_connection,
	dram_data_valid 	 => dram_data_valid_connection,
	sram_read_address    => sram_read_address,
	sram_write_en        => sram_write_en,
	sram_read_en         => sram_read_en,
	sram_enable          => sram_enable,
	sram_full            => sram_full,
	sram_data            => sram_data_tb_out,
	row_starting_address  => row_starting_address_tb_out,
	sram_read_data_valid  => sram_read_data_valid_con
);


	bus_single_memory_clk_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;


	process
	begin

	wait for 9 ns;
	reset  <= '1', '0' after 20 ns;

	sram_read_en  <= '0', '1' after 20 ns;
	bus_enable  <= '0', '1' after 20 ns;
	sram_write_en  <= '0', '1' after 20 ns;
	sram_read_en  <= '0';
	sram_enable  <= '0', '1' after 20 ns;

	wait;
	end process;

end tb_bus_single_memory_arc;


