LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

entity tb_bus_memory_single_fsm is
end entity tb_bus_memory_single_fsm;


architecture testbench of tb_bus_memory_single_fsm is

component SRAM is
port(

        sram_clk                       : in  STD_LOGIC;
        sram_reset                     : in  STD_LOGIC;
        dram_data_valid           : in std_logic;
        dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
        sram_read_address         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        sram_write_en             : in  STD_LOGIC;
        sram_read_en              : in  STD_LOGIC;
        sram_enable               : in  STD_LOGIC;
        sram_full            : out  std_logic;
        sram_data            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
        row_starting_address : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)

	);

end component SRAM;


component input_bus is
	port (
	             bus_clk : IN std_logic;
             bus_reset : in std_logic;
             bus_enable : in std_logic;
             dram_data_valid : out std_logic;   
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 

	);
end component input_bus;


component FSM is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		memory_address              : in std_logic_vector (SIZE_sram_address-1 downto 0);
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		sm_or_not					: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		tracker_ready 				: in std_logic

	);
end component FSM;

signal clk,reset,fsm_enable,enable,sm_or_not,fsm_sram_control : std_logic;
signal sram_write_en, sram_read_en : std_logic;
signal tracker_address_connection, sram_read_address : std_logic_vector (SIZE_sram_address-1 downto 0);
signal memory_segment_connection : std_logic_vector (memory_cell_width-1 downto 0);
signal sram_full : std_logic;
signal dram_data_valid_connection : std_logic;
signal dram_data_connection : std_logic_vector(bus_width-1 downto 0);
signal fsm_output_address_connection : std_logic_vector (SIZE_sram_address-1 downto 0);
signal row_starting_address_tb_out : std_logic_vector (SIZE_sram_address-1 downto 0);
signal tracker_ready : std_logic;
constant tb_clk : time := 10 ns;
begin

dut_fsm : fsm port map
(
	fsm_clock  => clk,                  
	fsm_reset   => reset,                
	fsm_enable  => fsm_enable,				
	memory_address  => sram_read_address,            
	tracker_address  => tracker_address_connection,            
	memory_segment    => memory_segment_connection,          
	sm_or_not  => sm_or_not,
	fsm_output_address    => fsm_output_address_connection,      
	fsm_sram_control  => fsm_sram_control,      
	tracker_ready  => tracker_ready
	);



DUT_input_bus : input_bus port map
 (
	bus_clk   => clk,      
	bus_reset  => reset,      
	bus_enable  => enable, 
	dram_data_valid  => dram_data_valid_connection,
	dram_data   => dram_data_connection
 );

DUT_SRAM : SRAM port map

(
	
	sram_clk       		 => clk,          
	sram_reset           => reset,  
	sram_enable          => enable,
	dram_data            => dram_data_connection,
	dram_data_valid 	 => dram_data_valid_connection,
	sram_read_address    => fsm_output_address_connection,
	sram_write_en        => sram_write_en,
	sram_read_en         => fsm_sram_control,
	sram_full            => sram_full,
	sram_data            => memory_segment_connection,
	row_starting_address  => row_starting_address_tb_out

);


	bus_single_memory_clk_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

	

	process
	begin

	wait for 10 ns;

	reset  <= '1', '0' after 9 ns;
	enable  <= '0', '1' after 29 ns;
	sram_write_en  <= '0','1' after 9 ns, '0' after 300 ns;
	--fsm_enable  <= '0', '1' after 49 ns;
	fsm_enable  <= '0', '1' after 29 ns;


	tracker_ready  <= '0', '1' after 69 ns;



	tracker_address_connection  <= x"0000";
	wait for 20 ns;
	tracker_address_connection  <= x"0001";
	wait for 20 ns;
	tracker_address_connection  <= x"0002";
	wait for 20 ns;
	tracker_address_connection  <= x"0003";
	wait for 20 ns;
	tracker_address_connection  <= x"0004";
	wait for 20 ns;
	tracker_address_connection  <= x"0005";
	wait for 20 ns;
	tracker_address_connection  <= x"0006";
	wait for 20 ns;
	tracker_address_connection  <= x"0007";
	wait for 20 ns;
	tracker_address_connection  <= x"0008";
	wait for 20 ns;


	wait;
	end process;

		
end architecture testbench;