LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
--use work.func_external.all;


-----------------------------------------------------------

entity tb_all is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_all is

--------------------------------------------------------------------------------
-- PRE
--------------------------------------------------------------------------------

component pre_buffer_fsm is
port (
	pre_buffer_fsm_clock         : in std_logic;
	pre_buffer_fsm_reset         : in std_logic;
	pre_buffer_fsm_enable		: in std_logic;
	max_pooling_enable			: in std_logic;
	relu_enable					: in std_logic;
	ccm_din_shift				: in std_logic;
	ccm_din_data_valid			: in std_logic;		--shift signal sent from mac_ccm
	ccm_din1_1					: in integer;
	ccm_din1_2					: in integer;
	ccm_din2_1					: in integer;
	ccm_din2_2					: in integer;
	ccm_din3_1					: in integer;
	ccm_din3_2					: in integer;
	ccm_din4_1					: in integer;
	ccm_din4_2					: in integer;
	ccm_din5_1					: in integer;
	ccm_din5_2					: in integer;
	ccm_din6_1					: in integer;
	ccm_din6_2					: in integer;
	ccm_din7_1					: in integer;
	ccm_din7_2					: in integer;
	ccm_din8_1					: in integer;
	ccm_din8_2					: in integer;
	ccm_din9_1					: in integer;
	ccm_din9_2					: in integer;
	ccm_din10_1					: in integer;
	ccm_din10_2					: in integer;
	ccm_din11_1					: in integer;
	ccm_din11_2					: in integer;
	ccm_din12_1					: in integer;
	ccm_din12_2					: in integer;
	ccm_din13_1					: in integer;
	ccm_din13_2					: in integer;
	ccm_din14_1					: in integer;
	ccm_din14_2					: in integer;
	ccm_din15_1					: in integer;
	ccm_din15_2					: in integer;
	ccm_din16_1					: in integer;
	ccm_din16_2					: in integer;

	pre_done					: out std_logic
);
end component pre_buffer_fsm;


--------------------------------------------------------------------------------
-- CCM
--------------------------------------------------------------------------------

	component locator_fsmversion is
		port (
			fsm0_data_ori   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
			fsm1_data_ori   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
			fsm2_data_ori   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
			fsm3_data_ori   : in std_logic_vector ( SM_segment_bit-1 downto 0 );
			fsm0_valid_ori  : in integer;
			fsm1_valid_ori  : in integer;
			fsm2_valid_ori  : in integer;
			fsm3_valid_ori  : in integer;
			fsm0_x_ori 		: in integer;
			fsm0_y_ori 		: in integer;
			fsm0_z_ori 		: in integer;
			fsm1_x_ori 		: in integer;
			fsm1_y_ori 		: in integer;
			fsm1_z_ori 		: in integer;
			fsm2_x_ori 		: in integer;
			fsm2_y_ori 		: in integer;
			fsm2_z_ori 		: in integer;
			fsm3_x_ori 		: in integer;
			fsm3_y_ori 		: in integer;
			fsm3_z_ori 		: in integer;
			mac_loc_compute_done : in std_logic;
			locator_clk  : in std_logic;
			locator_en   : in std_logic;
			locator_rst  : in std_logic;
			fsm_is_in_halt : in std_logic;

			locator_data_out : out integer;
			data_valid : out std_logic;
			trigger_mac_control : out std_logic;
			stop_IDP : out std_logic;
			pixel_x : out integer;
			pixel_y : out integer;
			pixel_z : out integer

		);
	end component locator_fsmversion;


	component mac_control is
	port (
		pixel_value			: in integer;
		--pixel_valid 		: in integer;
		mac_control_clk					: in std_logic;
		mac_control_reset				: in std_logic;
		mac_control_enable				: in std_logic;
		trigger_mac_control 			: in std_logic;
		pixel_x 			            :in integer;
		pixel_y 			            :in integer;
		pixel_z 			            :in integer;
		stripe_status                   :in std_logic;
		locator_data_valid              :in std_logic;


		control_x 			            :out integer;
		control_y 			            :out integer;
		control_z 			            :out integer;
		address_done					:out std_logic;
		control_pixel		            :out integer;
		--control_pixel_valid				:out integer;
		control_kernel_number 			:out integer;
		control_kernel_address_ready    :out integer;
		control_kernel_address			:out integer
	);
	end component;


	component mac_ccm is
		  port(  

        mac_kernel_value    : in integer;
        mac_kernel_valid    : in std_logic;
        mac_pixel_value     : in integer;
        mac_pixel_valid     : in std_logic;
        mac_clk         : in std_logic;
        mac_reset       : in std_logic;
        mac_enable        : in std_logic;
        --one_stripe_done : in integer;
        mac_x       :in integer;
        mac_y       :in integer;
        mac_z       :in integer;
        kernel_number    :in integer;
        pre_done	: in std_logic;

        compute_done_out: out std_logic;
        shift_out   	: out std_logic;
        output0     : out integer;
        output1     : out integer
     );
	end component;

	component sram_kernel is
		port(  
			 kernel_clk : IN std_logic;
			 kernel_reset : in std_logic;
			 kernel_enable : in std_logic;
			 kernel_address : in integer;

			 kernel_data_valid : out std_logic;   
			 kernel_data : OUT signed (SM_segment_bit-1 downto 0) 
			);
	end component;




--------------------------------------------------------------------------------
-- IDP
--------------------------------------------------------------------------------


component SRAM is
port(

	sram_clk                       : in  STD_LOGIC;
	sram_reset                     : in  STD_LOGIC;
	dram_data_valid         : in std_logic;
	dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
	sram_read_address0         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address1         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address2         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address3         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_write_en             : in  STD_LOGIC;
	sram_read_en              : in  STD_LOGIC;
	sram_enable               : in  STD_LOGIC;
	
	sram_full            : out  std_logic;
	sram_data0            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data1            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data2            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data3            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_read_data_valid : out std_logic
	);

end component SRAM;


component FSM1 is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;

		sm_or_not					: out integer;
		fsm_is_in_halt				: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		--big_stripe_done				: out integer;
		fsm_tracker_address1			: out integer;
		--fsm_tracker_address_last_two: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer

	);
end component FSM1;


component FSM2 is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;

		sm_or_not					: out integer;
		fsm_is_in_halt				: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		--big_stripe_done				: out integer;
		fsm_tracker_address2			: out integer;
		--fsm_tracker_address_last_two: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer

	);
end component FSM2;

component FSM0 is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;

		sm_or_not					: out integer;
		fsm_is_in_halt				: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		--big_stripe_done				: out integer;
		fsm_tracker_address0			: out integer;
		--fsm_tracker_address_last_two: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer

	);
end component FSM0;


component FSM3 is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;

		sm_or_not					: out integer;
		fsm_is_in_halt				: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		--big_stripe_done				: out integer;
		fsm_tracker_address3			: out integer;
		--fsm_tracker_address_last_two: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer

	);
end component FSM3;


component SRAM_tracker 
	Port ( 

		    tracker_sram_clk                       : in  STD_LOGIC;
		    tracker_sram_reset                     : in  STD_LOGIC;
		    start_add0                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add1                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add2                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add3                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    tracker_sram_write_en             : in  integer;
		    tracker_sram_read_en              : in  STD_LOGIC;
		    tracker_sram_enable               : in  STD_LOGIC;
		    fsm_stripe_done             : in STD_LOGIC;
		    tracker_sram_read_address0   : in integer;
		    tracker_sram_read_address1   : in integer;
		    tracker_sram_read_address2   : in integer;
		    tracker_sram_read_address3   : in integer;
		    --fsm_tracker_address_last_two : in integer;
		    --big_stripe_done				: in integer;

		    
		    start_add_out0            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out1            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out2            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out3            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)

		);
end component;




component input_tracker
	port (
		tracker_clk           : in std_logic;
		tracker_reset         : in std_logic;
		tracker_enable        : in std_logic;
		input_tracker_in     : in std_logic_vector (bus_width-1 downto 0);
		bus_index_signal : in integer;
		file_end        : in std_logic;

		tracker_out_address_0 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_1 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_2 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_3 : out unsigned (SIZE_sram_address-1 downto 0);
		stripe_done : out integer
);
end component;

component input_bus
    port(    bus_clk : IN std_logic;
             bus_reset : in std_logic;  
             bus_enable : in std_logic;   

             file_end  : out std_logic;
             bus_index : out integer;
 			 dram_data_valid : out std_logic;
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;



signal reset          : std_logic;
signal clk            : std_logic;
signal outputaddress0 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress1 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress2 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress3 : unsigned (SIZE_sram_address-1 downto 0);


signal enable      : std_logic;
signal datain         : std_logic_vector (bus_width-1 downto 0);
signal dram_data_valid,fsm_stripe_done0,fsm_stripe_done1,fsm_stripe_done2,fsm_stripe_done3 : std_logic;
signal bus_index_signal : integer;
signal stripe_done : integer;
signal sm_or_not0,sm_or_not1,sm_or_not2,sm_or_not3 : integer;

signal sram_write_en,fsm_sram_control,sram_full, tracker_ready: std_logic;
signal memory_segment_connection0 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection1 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection2 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection3 : std_logic_vector (memory_cell_width-1 downto 0);

signal fsm_output_address0 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address1 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address2 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address3 : std_logic_vector (SIZE_sram_address-1 downto 0); 


signal add_out0,add_out1,add_out2,add_out3 : std_logic_vector (SIZE_sram_address-1 downto 0);
signal sram_read_en,sram_read_data_valid,all_fsm_done : std_logic;

signal tracker_sram_read_address0: integer;
signal tracker_sram_read_address1: integer;
signal tracker_sram_read_address2: integer;
signal tracker_sram_read_address3: integer;

signal coor_x_0,coor_x_1,coor_x_2,coor_x_3 : integer;
signal coor_y_0,coor_y_1,coor_y_2,coor_y_3 : integer;
signal coor_z_0,coor_z_1,coor_z_2,coor_z_3 : integer;

signal fsm_is_in_halt : std_logic;
--signal big_stripe_done: integer;
signal fsm_tracker_address_last_two : integer;
signal file_end 	:std_logic;

--------------------------------------------------------------------------------locator 
signal loc_compute_done : integer;
signal pixel_value_locator : integer;
signal pixel_x,pixel_y,pixel_z : integer;
signal read_enable,write_enable, locator_data_valid : std_logic;
signal  locator_stop_IDP : std_logic;
signal stop_IDP : std_logic;
signal 	trigger_mac_control : std_logic;

--------------------------------------------------------------------------------locator


--------------------------------------------------------------------------------mac_control
signal control_pixel : integer;

signal control_x,control_y,control_z : integer;
signal kernel_address,kernel_address_ready : integer;
signal stripe_status ,address_done: std_logic;
signal control_pixel_valid : integer;
signal mac_control_compute_done : std_logic;
signal mac_control_enable : std_logic;
--------------------------------------------------------------------------------mac_control

--------------------------------------------------------------------------------mac_ccm
signal kernel_valid : std_logic;
signal compute_done_out,compute_done_out2,compute_done_out3 : std_logic;
signal compute_done_out4,compute_done_out5,compute_done_out6 : std_logic;
signal compute_done_out7,compute_done_out8,compute_done_out9 : std_logic;
signal compute_done_out10,compute_done_out11,compute_done_out12 : std_logic;
signal compute_done_out13,compute_done_out14,compute_done_out15,compute_done_out16 : std_logic;
signal kernel_value : integer;
--signal output0,output1 : integer;
signal x,y,z : integer;
signal control_kernel_number : integer;
signal pre_done : std_logic;
signal shift_out,shift_out2,shift_out3,shift_out4,shift_out5 : std_logic;
signal shift_out6,shift_out7,shift_out8,shift_out9,shift_out10 : std_logic;
signal shift_out11,shift_out12,shift_out13,shift_out14,shift_out15,shift_out16 : std_logic;
--------------------------------------------------------------------------------mac_ccm

--------------------------------------------------------------------------------sram_kernel
signal kernel_data : signed (SM_segment_bit-1 downto 0);
signal kernel_data_valid : std_logic;
signal kernel_enable : std_logic;
--------------------------------------------------------------------------------sram_kernel


--------------------------------------------------------------------------------pre
signal max_pooling_enable : std_logic;
signal relu_enable : std_logic;
signal ccm_din_shift : std_logic;
signal output1_1 : integer;
signal output1_2 : integer;
signal output2_1 : integer;
signal output2_2 : integer;
signal output3_1 : integer;
signal output3_2 : integer;
signal output4_1 : integer;
signal output4_2 : integer;
signal output5_1 : integer;
signal output5_2 : integer;
signal output6_1 : integer;
signal output6_2 : integer;
signal output7_1 : integer;
signal output7_2 : integer;
signal output8_1 : integer;
signal output8_2 : integer;
signal output9_1 : integer;
signal output9_2 : integer;
signal output10_1 : integer;
signal output10_2 : integer;
signal output11_1 : integer;
signal output11_2 : integer;
signal output12_1 : integer;
signal output12_2 : integer;
signal output13_1 : integer;
signal output13_2 : integer;
signal output14_1 : integer;
signal output14_2 : integer;
signal output15_1 : integer;
signal output15_2 : integer;
signal output16_1 : integer;
signal output16_2 : integer;
 
--------------------------------------------------------------------------------testbench
constant tb_clk       : time := 10 ns;
signal control_pixel_1 : integer;
signal control_pixel_2 : integer;
signal control_pixel_3 : integer;
signal control_z_1 : integer;
signal control_z_2 : integer;
signal control_z_3 : integer;
signal control_y_1 : integer;
signal control_y_2 : integer;
signal control_y_3 : integer;
signal control_x_1 : integer;
signal control_x_2 : integer;
signal control_x_3 : integer;
signal locator_data_valid_1 : std_logic;
signal locator_data_valid_2 : std_logic;
signal locator_data_valid_3 : std_logic;
signal kernel_enable_buffer : std_logic;
signal kernel_value_1 : integer;
signal kernel_value_2 : integer;
signal compute_done_out_1 : std_logic;
signal compute_done_out_2 : std_logic;
signal compute_done_out_3 : std_logic;
signal compute_done_out_4 : std_logic;
--------------------------------------------------------------------------------testbench


begin


--------------------------------------------------------------------------------
-- PRE unit
--------------------------------------------------------------------------------
dut_pre : pre_buffer_fsm  port map
 (
	pre_buffer_fsm_clock	 =>  clk,    
	pre_buffer_fsm_reset	 =>  reset,
	pre_buffer_fsm_enable	 =>  enable,
	max_pooling_enable	 => 	max_pooling_enable,	
	relu_enable	 => 			relu_enable,	
	ccm_din_shift	 => 		ccm_din_shift,			
	ccm_din_data_valid	 => 	shift_out,	
	ccm_din1_1	 => 			output1_1,	
	ccm_din1_2	 => 			output1_2,	
	ccm_din2_1	 => 			output2_1,	
	ccm_din2_2	 => 			output2_2,	
	ccm_din3_1	 => 			output3_1,	
	ccm_din3_2	 => 			output3_2,	
	ccm_din4_1	 => 			output4_1,	
	ccm_din4_2	 => 			output4_2,	
	ccm_din5_1	 => 			output5_1,	
	ccm_din5_2	 => 			output5_2,	
	ccm_din6_1	 => 			output6_1,	
	ccm_din6_2	 => 			output6_2,	
	ccm_din7_1	 => 			output7_1,	
	ccm_din7_2	 => 			output7_2,	
	ccm_din8_1	 => 			output8_1,	
	ccm_din8_2	 => 			output8_2,	
	ccm_din9_1	 => 			output9_1,	
	ccm_din9_2	 => 			output9_2,	
	ccm_din10_1	 => 			output10_1,	
	ccm_din10_2	 => 			output10_2,	
	ccm_din11_1	 => 			output11_1,	
	ccm_din11_2	 => 			output11_2,	
	ccm_din12_1	 => 			output12_1,	
	ccm_din12_2	 => 			output12_2,	
	ccm_din13_1	 => 			output13_1,	
	ccm_din13_2	 => 			output13_2,	
	ccm_din14_1	 => 			output14_1,	
	ccm_din14_2	 => 			output14_2,	
	ccm_din15_1	 => 			output15_1,	
	ccm_din15_2	 => 			output15_2,	
	ccm_din16_1	 => 			output16_1,	
	ccm_din16_2	 => 			output16_2,

	pre_done 	 =>             pre_done	
);

--------------------------------------------------------------------------------
-- ccm unit
--------------------------------------------------------------------------------


--compute_done_delay:process(clk)
--begin
-- if(reset = '1') then
-- 	compute_done_out_1  <= '0';
-- 	compute_done_out_2  <= '0';
-- 	compute_done_out_3  <= '0';
-- 	compute_done_out_4  <= '0';
-- elsif(rising_edge(clk)) then
-- 	compute_done_out_1  <= compute_done_out;
-- 	compute_done_out_2  <= compute_done_out_1;
-- 	compute_done_out_3  <= compute_done_out_2;
-- 	compute_done_out_4  <= compute_done_out_3;
--end if;
--end process;


	dut_locator_fsmversion : locator_fsmversion port map(

		fsm0_data_ori         => memory_segment_connection0, 
		fsm1_data_ori         => memory_segment_connection1, 
		fsm2_data_ori         => memory_segment_connection2, 
		fsm3_data_ori         => memory_segment_connection3, 
		fsm0_valid_ori        => sm_or_not0,
		fsm1_valid_ori        => sm_or_not1,
		fsm2_valid_ori        => sm_or_not2,
		fsm3_valid_ori        => sm_or_not3, 
		fsm0_x_ori 		      => coor_x_0,
		fsm0_y_ori 		      => coor_y_0,
		fsm0_z_ori 		      => coor_z_0,
		fsm1_x_ori 		      => coor_x_1,
		fsm1_y_ori 		      => coor_y_1,
		fsm1_z_ori 		      => coor_z_1,
		fsm2_x_ori 		      => coor_x_2,
		fsm2_y_ori 		      => coor_y_2,
		fsm2_z_ori 		      => coor_z_2,
		fsm3_x_ori 		      => coor_x_3,
		fsm3_y_ori 		      => coor_y_3,
		fsm3_z_ori 		      => coor_z_3,
		mac_loc_compute_done  => compute_done_out,
		locator_clk       => clk,
		locator_en        => enable,
		locator_rst       => reset,
		fsm_is_in_halt   	=> fsm_is_in_halt, 

		locator_data_out       => pixel_value_locator,
		data_valid        => locator_data_valid,
		trigger_mac_control  => trigger_mac_control,
		stop_IDP          => locator_stop_IDP,
		pixel_x           => pixel_x,
		pixel_y           => pixel_y,
		pixel_z           => pixel_z
		);


	mac_control_dut: mac_control port map (
		pixel_value			             => pixel_value_locator,
		mac_control_clk			         => clk,
		mac_control_reset	             => reset,
		mac_control_enable	             => mac_control_enable,
		--mac_control_compute_done         => compute_done_out,
		pixel_x				             => pixel_x,
		pixel_y				             => pixel_y,
		pixel_z				             => pixel_z,
		--pixel_valid			             => locator_data_valid,
		stripe_status					 => stripe_status,
		address_done					 => address_done,
		locator_data_valid               => locator_data_valid,
		trigger_mac_control 			 => trigger_mac_control,



		control_kernel_address           => kernel_address,
		control_kernel_address_ready 	 => kernel_address_ready,
		control_pixel		             => control_pixel,
		--control_pixel_valid				 => control_pixel_valid,
		control_kernel_number 			 => control_kernel_number,
		control_x			             => control_x,
		control_y			             => control_y,
		control_z			             => control_z

		);

	mac_ccm_DUT_1: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out, 
     shift_out 			 => shift_out,
     output0             => output1_1,
     output1             => output1_2
      );

	mac_ccm_DUT_2: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out2, 
     shift_out 			 => shift_out2,
     output0             => output2_1,
     output1             => output2_2
      );

	mac_ccm_DUT_3: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out3, 
     shift_out 			 => shift_out3,
     output0             => output3_1,
     output1             => output3_2
      );

	mac_ccm_DUT_4: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out4, 
     shift_out 			 => shift_out4,
     output0             => output4_1,
     output1             => output4_2
      );

	mac_ccm_DUT_5: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out5, 
     shift_out 			 => shift_out5,
     output0             => output5_1,
     output1             => output5_2
      );

	mac_ccm_DUT_6: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out6, 
     shift_out 			 => shift_out6,
     output0             => output6_1,
     output1             => output6_2
      );

	mac_ccm_DUT_7: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out7, 
     shift_out 			 => shift_out7,
     output0             => output7_1,
     output1             => output7_2
      );

	mac_ccm_DUT_8: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out8, 
     shift_out 			 => shift_out8,
     output0             => output8_1,
     output1             => output8_2
      );

	mac_ccm_DUT_9: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out9, 
     shift_out 			 => shift_out9,
     output0             => output9_1,
     output1             => output9_2
      );

	mac_ccm_DUT_10: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out10, 
     shift_out 			 => shift_out10,
     output0             => output10_1,
     output1             => output10_2
      );

	mac_ccm_DUT_11: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out11, 
     shift_out 			 => shift_out11,
     output0             => output11_1,
     output1             => output11_2
      );

	mac_ccm_DUT_12: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out12, 
     shift_out 			 => shift_out12,
     output0             => output12_1,
     output1             => output12_2
      );

	mac_ccm_DUT_13: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out13, 
     shift_out 			 => shift_out13,
     output0             => output13_1,
     output1             => output13_2
      );

	mac_ccm_DUT_14: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out14, 
     shift_out 			 => shift_out14,
     output0             => output14_1,
     output1             => output14_2
      );

	mac_ccm_DUT_15: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out15, 
     shift_out 			 => shift_out15,
     output0             => output15_1,
     output1             => output15_2
      );

	mac_ccm_DUT_16: mac_ccm port map (    

     mac_kernel_value    => kernel_value_2,
     mac_kernel_valid    => kernel_data_valid,
     mac_pixel_value     => control_pixel,
     mac_pixel_valid     => locator_data_valid,
     mac_clk             => clk,
     mac_reset           => reset,
     mac_enable          => enable,
     mac_x               => control_x,
     mac_y               => control_y,
     mac_z               => control_z,
     --one_stripe_done     => one_stripe_done,
     kernel_number       => control_kernel_number,
     pre_done			 => pre_done,


     compute_done_out    => compute_done_out16, 
     shift_out 			 => shift_out16,
     output0             => output16_1,
     output1             => output16_2
      );

	kernel_value_delay: process(clk)    --to dealy kernel value for one cycle
	begin
	 if (reset = '1') then 
	 	kernel_value_1  <= 0;
	 	kernel_value_2  <= 0;
	 elsif(rising_edge(clk)) then
	    if( enable = '1') then
	    	kernel_value_1  <= kernel_value;
	    	kernel_value_2  <= kernel_value_1;
		end if;
	end if;
	end process;



	sram_kernel_DUT: sram_kernel port map (    
		kernel_clk => clk, 
		kernel_reset => reset, 
		kernel_enable  => kernel_enable,   
		kernel_address  => kernel_address,

		kernel_data_valid  => kernel_data_valid,
		kernel_data => kernel_data 
      );

	--kernel_enable_delay: process(clk,reset,kernel_enable_buffer)    --to dealy kernel value for one cycle
	--begin
	-- if (reset = '1') then 
	-- 	kernel_enable  <= '0';
	-- elsif(rising_edge(clk)) then
	--    if( enable = '1') then
	--    	kernel_enable  <= kernel_enable_buffer;
	--	end if;
	--end if;
	--end process;



	kernel_value  <= to_integer(signed(kernel_data));


	process(kernel_address_ready, address_done)   --to generate the enable signal of kernel sram
	begin
	 if kernel_address_ready = 1 and address_done = '0' then
	 	 kernel_enable  <= '1';
	 else
	 	 kernel_enable  <= '0';
	 end if;
	end process;



	--kernel_enable  <= to_unsigned(kernel_address_ready,1)(0) and (not(address_done));
	
--------------------------------------------------------------------------------
-- IDP unit
--------------------------------------------------------------------------------

	dut_input_bus : input_bus port map(
	bus_clk        => clk,
	bus_reset      => reset,
	bus_enable => enable,   

	file_end 	 => file_end,
	bus_index  => bus_index_signal,
	dram_data_valid  => dram_data_valid,
	dram_data  => datain
	);


	dut_sram :SRAM port map(
		sram_clk       		 => clk,          
		sram_reset           => reset,  
		sram_enable          => enable,
		dram_data            => datain,
		dram_data_valid 	 => dram_data_valid,
		sram_read_address0    => fsm_output_address0,
		sram_read_address1    => fsm_output_address1,
		sram_read_address2    => fsm_output_address2,
		sram_read_address3    => fsm_output_address3,
		sram_write_en         => enable,
		sram_read_en          => fsm_sram_control,

		sram_full             => sram_full,
		sram_data0            => memory_segment_connection0,
		sram_data1            => memory_segment_connection1,
		sram_data2            => memory_segment_connection2,
		sram_data3            => memory_segment_connection3,
		sram_read_data_valid  => sram_read_data_valid
		);


	dut_input_tracker: input_tracker port map(
	tracker_clk           => clk,
	tracker_reset         => reset,
	tracker_enable        => enable,
	bus_index_signal   		=>  bus_index_signal,
	input_tracker_in      => datain,
	file_end			 => file_end,

	tracker_out_address_0 => outputaddress0,
	tracker_out_address_1 => outputaddress1,
	tracker_out_address_2 => outputaddress2,
	tracker_out_address_3 => outputaddress3,
	stripe_done 	 => stripe_done
	);



	dut_fsm0 : FSM0 port map (
		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out0),            
		memory_segment    => memory_segment_connection0,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => locator_stop_IDP,

		sm_or_not  => sm_or_not0,
		fsm_is_in_halt  => fsm_is_in_halt,
		fsm_output_address    => fsm_output_address0,
		fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done0,
		--big_stripe_done	 => big_stripe_done,
		fsm_tracker_address0  => tracker_sram_read_address0,
		--fsm_tracker_address_last_two  => fsm_tracker_address_last_two,
		pixel_coor_x	 => coor_x_0,
		pixel_coor_y	 => coor_y_0,
		pixel_coor_z	 => coor_z_0
		);


	dut_fsm1 : FSM1 port map (
		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out1),            
		memory_segment    => memory_segment_connection1,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => locator_stop_IDP,

		sm_or_not  => sm_or_not1,
		fsm_output_address    => fsm_output_address1,
		--fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done1,
		fsm_tracker_address1  => tracker_sram_read_address1,
		pixel_coor_x	 => coor_x_1,
		pixel_coor_y	 => coor_y_1,
		pixel_coor_z	 => coor_z_1
		);


	dut_fsm2 : FSM2 port map (

		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out2),            
		memory_segment    => memory_segment_connection2,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => locator_stop_IDP,


		sm_or_not  => sm_or_not2,
		fsm_output_address    => fsm_output_address2,
		--fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done2,
		fsm_tracker_address2  => tracker_sram_read_address2,
		pixel_coor_x	 => coor_x_2,
		pixel_coor_y	 => coor_y_2,
		pixel_coor_z	 => coor_z_2
		);


	dut_fsm3 : FSM3 port map (


		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out3),            
		memory_segment    => memory_segment_connection3,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => locator_stop_IDP,

		sm_or_not  => sm_or_not3,
		fsm_output_address    => fsm_output_address3,
		--fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done3,
		fsm_tracker_address3  => tracker_sram_read_address3,
		pixel_coor_x	 => coor_x_3,
		pixel_coor_y	 => coor_y_3,
		pixel_coor_z	 => coor_z_3
		);

tracker_ready  <= '1' when stripe_done > 0;
all_fsm_done  <= fsm_stripe_done0 and fsm_stripe_done1 and fsm_stripe_done2 and fsm_stripe_done3;


	dut_sram_tracker : SRAM_tracker port map(
	tracker_sram_clk  => clk,           
	tracker_sram_reset  => reset,         
	start_add0  => outputaddress0,          
	start_add1  => outputaddress1,          
	start_add2  => outputaddress2,          
	start_add3  => outputaddress3,
	--big_stripe_done	 => big_stripe_done,          
	tracker_sram_write_en     => stripe_done,   
	tracker_sram_read_en	 => enable,   -- to simplify, the sram_tracker is always read enabled     
	tracker_sram_enable       => enable,  
	fsm_stripe_done   => all_fsm_done, 
	tracker_sram_read_address0  => tracker_sram_read_address0,
	tracker_sram_read_address1  => tracker_sram_read_address1,
	tracker_sram_read_address2  => tracker_sram_read_address2,
	tracker_sram_read_address3  => tracker_sram_read_address3,
	--fsm_tracker_address_last_two  => fsm_tracker_address_last_two,

	start_add_out0	 => add_out0,      
	start_add_out1	 => add_out1,      
	start_add_out2	 => add_out2,      
	start_add_out3	 => add_out3    
    
	);

	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;
--------------------------------------------------------------------------------
-- since the pixel value/coordinates  and kernel don't arrive simultaneously to mac_ccm
-- so I added 3 regs here to synchronize it  
--------------------------------------------------------------------------------

	--synch_pixel_kernel : process(clk)    
	--begin
	--	if(rising_edge(clk)) then
	--		control_pixel_1  <= control_pixel;
	--		control_pixel_2   <= control_pixel_1;
	--		control_pixel_3    <= control_pixel_2;
	--		control_pixel_4    <= control_pixel_3;

	--		locator_data_valid_1  <= locator_data_valid;
	--		locator_data_valid_2   <= locator_data_valid_1;
	--		locator_data_valid_3    <= locator_data_valid_2;

	--		control_x_1  <= control_x;
	--		control_x_2   <= control_x_1;
	--		control_x_3    <= control_x_2;

	--		control_y_1  <= control_y;
	--		control_y_2   <= control_y_1;
	--		control_y_3    <= control_y_2;

	--		control_z_1  <= control_z;
	--		control_z_2   <= control_z_1;
	--		control_z_3    <= control_z_2;

	--	end if;
	--end process;



process
begin
	stop_IDP  <= '0';
	reset <= '1';
	mac_control_enable  <= '0';
	--one_stripe_done  <= 0;
	loc_compute_done  <= 0;
	mac_control_compute_done  <= '0';
	relu_enable  <= '1';
	max_pooling_enable  <= '1';
	wait for 19 ns;
	reset  <= '0';
	wait for 16 ns;
	enable <= '1';
 	wait for 135 ns;
 	write_enable  <= '1';

 	wait for 99 ns;
 	mac_control_enable  <= '1';
 	wait for 1 ns;
 	read_enable  <= '1';
 	wait for 1 ns;




	wait for 400 ns;

	wait for 100 ns;

		wait;


end process;


end architecture testbench;