library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;
use work.func_external.all;


-----------------------------------------------------------

entity tb_IDP_single_fsm is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_IDP_single_fsm is



component SRAM is
port(

	sram_clk                       : in  STD_LOGIC;
	sram_reset                     : in  STD_LOGIC;
	dram_data_valid         : in std_logic;
	dram_data                 : in  STD_LOGIC_VECTOR (bus_width - 1 downto 0);
	sram_read_address0         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address1         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address2         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_read_address3         : in  STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
	sram_write_en             : in  STD_LOGIC;
	sram_read_en              : in  STD_LOGIC;
	sram_enable               : in  STD_LOGIC;
	
	sram_full            : out  std_logic;
	sram_data0            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data1            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data2            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_data3            : out STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
	sram_read_data_valid : out std_logic
	);

end component SRAM;


component FSM is
	port (
		fsm_index					: in integer;
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;

		sm_or_not					: out integer;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		fsm_tracker_address			: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer

	);
end component FSM;

component SRAM_tracker 
	Port ( 

		    tracker_sram_clk                       : in  STD_LOGIC;
		    tracker_sram_reset                     : in  STD_LOGIC;
		    start_add0                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add1                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add2                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    start_add3                 : in  unsigned (SIZE_sram_address - 1 downto 0);
		    tracker_sram_write_en             : in  integer;
		    tracker_sram_read_en              : in  STD_LOGIC;
		    tracker_sram_enable               : in  STD_LOGIC;
		    fsm_stripe_done             : in STD_LOGIC;
		    tracker_sram_read_address   : in integer;

		    
		    start_add_out0            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out1            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out2            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
		    start_add_out3            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)

		);
end component;




component input_tracker
	port (
		tracker_clk           : in std_logic;
		tracker_reset         : in std_logic;
		tracker_enable        : in std_logic;
		input_tracker_in     : in std_logic_vector (bus_width-1 downto 0);
		bus_index_signal : in integer;

		tracker_out_address_0 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_1 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_2 : out unsigned (SIZE_sram_address-1 downto 0);
		tracker_out_address_3 : out unsigned (SIZE_sram_address-1 downto 0);
		stripe_done : out integer
);
end component;

component input_bus
    port(    bus_clk : IN std_logic;
             bus_reset : in std_logic;  
             bus_enable : in std_logic;   
             bus_index : out integer;

 			 dram_data_valid : out std_logic;
             dram_data : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end component;



signal reset          : std_logic;
signal clk            : std_logic;
signal outputaddress0 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress1 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress2 : unsigned (SIZE_sram_address-1 downto 0);
signal outputaddress3 : unsigned (SIZE_sram_address-1 downto 0);


signal enable      : std_logic;
signal datain         : std_logic_vector (bus_width-1 downto 0);
signal dram_data_valid,fsm_stripe_done0,fsm_stripe_done1,fsm_stripe_done2,fsm_stripe_done3 : std_logic;
signal bus_index_signal : integer;
signal stripe_done : integer;
signal sm_or_not0,sm_or_not1,sm_or_not2,sm_or_not3 : integer;

signal sram_write_en,fsm_sram_control,sram_full, tracker_ready: std_logic;
signal memory_segment_connection0 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection1 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection2 : std_logic_vector (memory_cell_width-1 downto 0);
signal memory_segment_connection3 : std_logic_vector (memory_cell_width-1 downto 0);

signal fsm_output_address0 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address1 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address2 : std_logic_vector (SIZE_sram_address-1 downto 0); 
signal fsm_output_address3 : std_logic_vector (SIZE_sram_address-1 downto 0); 


signal add_out0,add_out1,add_out2,add_out3 : std_logic_vector (SIZE_sram_address-1 downto 0);
signal sram_read_en,sram_read_data_valid,all_fsm_done : std_logic;

signal tracker_sram_read_address: integer;

signal coor_x_0,coor_x_1,coor_x_2,coor_x_3 : integer;
signal coor_y_0,coor_y_1,coor_y_2,coor_y_3 : integer;
signal coor_z_0,coor_z_1,coor_z_2,coor_z_3 : integer;

signal fsm_index0 : integer := 0;
signal fsm_index1 : integer := 1;
signal fsm_index2 : integer := 2;
signal fsm_index3 : integer := 3;


signal stop_fsm : std_logic;

constant tb_clk       : time := 10 ns;

begin

	dut_input_bus : input_bus port map(
	bus_clk        => clk,
	bus_reset      => reset,
	bus_enable => enable,   

	bus_index  => bus_index_signal,
	dram_data_valid  => dram_data_valid,
	dram_data  => datain
	);


	dut_sram :SRAM port map(
		sram_clk       		 => clk,          
		sram_reset           => reset,  
		sram_enable          => enable,
		dram_data            => datain,
		dram_data_valid 	 => dram_data_valid,
		sram_read_address0    => fsm_output_address0,
		sram_read_address1    => fsm_output_address1,
		sram_read_address2    => fsm_output_address2,
		sram_read_address3    => fsm_output_address3,
		sram_write_en        => enable,
		sram_read_en         => fsm_sram_control,

		sram_full            => sram_full,
		sram_data0            => memory_segment_connection0,
		sram_data1            => memory_segment_connection1,
		sram_data2            => memory_segment_connection2,
		sram_data3            => memory_segment_connection3,
		sram_read_data_valid  => sram_read_data_valid
		);

	dut_input_tracker: input_tracker port map(
	tracker_clk           => clk,
	tracker_reset         => reset,
	tracker_enable        => enable,
	bus_index_signal   =>  bus_index_signal,
	input_tracker_in      => datain,

	tracker_out_address_0 => outputaddress0,
	tracker_out_address_1 => outputaddress1,
	tracker_out_address_2 => outputaddress2,
	tracker_out_address_3 => outputaddress3,
	stripe_done 	 => stripe_done
	);

	dut_fsm0 : FSM port map (
		fsm_index  => fsm_index0,
		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out0),            
		memory_segment    => memory_segment_connection0,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => stop_fsm,

		sm_or_not  => sm_or_not0,
		fsm_output_address    => fsm_output_address0,
		fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done0,
		fsm_tracker_address  => tracker_sram_read_address,
		pixel_coor_x	 => coor_x_0,
		pixel_coor_y	 => coor_y_0,
		pixel_coor_z	 => coor_z_0
		);

	dut_fsm1 : FSM port map (
		fsm_index  => fsm_index1,
		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out1),            
		memory_segment    => memory_segment_connection1,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => stop_fsm,

		sm_or_not  => sm_or_not1,
		fsm_output_address    => fsm_output_address1,
		fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done1,
		pixel_coor_x	 => coor_x_1,
		pixel_coor_y	 => coor_y_1,
		pixel_coor_z	 => coor_z_1
		);

	dut_fsm2 : FSM port map (

		fsm_index  => fsm_index2,
		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out2),            
		memory_segment    => memory_segment_connection2,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => stop_fsm,


		sm_or_not  => sm_or_not2,
		fsm_output_address    => fsm_output_address2,
		fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done2,
		pixel_coor_x	 => coor_x_2,
		pixel_coor_y	 => coor_y_2,
		pixel_coor_z	 => coor_z_2
		);

	dut_fsm3 : FSM port map (

		fsm_index  => fsm_index3,

		fsm_clock  => clk,                  
		fsm_reset   => reset,                	
		fsm_enable  => tracker_ready,				
		tracker_address  => std_logic_vector(add_out3),            
		memory_segment    => memory_segment_connection3,          
		tracker_ready  => tracker_ready,
		all_fsm_done  => all_fsm_done,
		stop_fsm   => stop_fsm,

		sm_or_not  => sm_or_not3,
		fsm_output_address    => fsm_output_address3,
		fsm_sram_control  => fsm_sram_control,
		fsm_stripe_done  => fsm_stripe_done3,
		pixel_coor_x	 => coor_x_3,
		pixel_coor_y	 => coor_y_3,
		pixel_coor_z	 => coor_z_3
		);


tracker_ready  <= '1' when stripe_done > 0;
all_fsm_done  <= fsm_stripe_done0 and fsm_stripe_done1 and fsm_stripe_done2 and fsm_stripe_done3;


	dut_sram_tracker : SRAM_tracker port map(
	tracker_sram_clk  => clk,           
	tracker_sram_reset  => reset,         
	start_add0  => outputaddress0,          
	start_add1  => outputaddress1,          
	start_add2  => outputaddress2,          
	start_add3  => outputaddress3,          
          
	tracker_sram_write_en     => stripe_done,   
	tracker_sram_read_en	 => enable,   -- to simplify, the sram_tracker is always read enabled     
	tracker_sram_enable       => enable,  
	fsm_stripe_done   => all_fsm_done, 
	tracker_sram_read_address  => tracker_sram_read_address,

	start_add_out0	 => add_out0,      
	start_add_out1	 => add_out1,      
	start_add_out2	 => add_out2,      
	start_add_out3	 => add_out3    
    
	);

	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;


process
begin
	reset <= '1';
	stop_fsm  <= '0'; 
	wait for 19 ns;
	reset  <= '0';
	wait for 16 ns;
	enable <= '1';

	wait for 400 ns;
	stop_fsm  <= '1';

	wait for 100 ns;
	stop_fsm  <= '0';

		wait;


end process;


end architecture testbench;