LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;

-----------------------------------------------------------

entity tb_fsm is
end entity ;

-----------------------------------------------------------

architecture testbench of tb_fsm is

	component FSM is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		memory_address              : in std_logic_vector (SIZE_sram_address-1 downto 0);
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		sm_or_not					: out std_logic;
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		tracker_ready				: in std_logic
	);
	end component FSM;

	constant tb_clk : time := 10 ns ; -- NS
	signal fsm_reset,fsm_enable : std_logic;
	signal memory_address,memory_segment,tracker_address,fsm_output_address : std_logic_vector (SIZE_sram_address-1 downto 0);
	signal clk: std_logic;
	signal sm_or_not : std_logic;
	signal fsm_sram_control : std_logic;
	signal tracker_ready : std_logic;
begin

	dut:FSM port map (
		fsm_clock  => clk,                  
		fsm_reset   => fsm_reset,                
		fsm_enable  => fsm_enable,				
		memory_address  => memory_address,            
		tracker_address  => tracker_address,            
		memory_segment    => memory_segment,          
		sm_or_not  => sm_or_not,
		fsm_output_address    => fsm_output_address,
		fsm_sram_control  => fsm_sram_control,
		tracker_ready  => tracker_ready

		);
-----------------------------------------------------------
-- Clocks and Reset
-----------------------------------------------------------
	CLK_process : process

	begin
	  clk <= '0';
	  wait for tb_clk;
	  clk <= '1';
	  wait for tb_clk;	 
	end process;

--------------------------------------------------------------------------------
-- stimuli
--------------------------------------------------------------------------------

	process
	begin
		
		wait for 9 ns;
		tracker_ready  <= '0';
		fsm_enable  <= '0';
		fsm_reset  <= '1';

		wait for 5 ns;
		fsm_reset  <= '0';
		--fsm_enable  <= '1';

		wait for 16 ns;

		memory_segment  <= B"0000_1111_0000_1111";
		wait for 20 ns;

		fsm_enable  <= '1';
		wait for 40 ns;
		tracker_ready  <= '1';

		wait for 40 ns;
		memory_segment  <= B"1010_1111_1010_1010";



		wait for 40 ns;		
		

		wait;
		
	end process ;



end architecture testbench;