LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
--use work.func_external.all;


entity sram_kernel is
    port(    
             kernel_clk : IN std_logic;
             kernel_reset : in std_logic;
             kernel_enable : in std_logic;
             kernel_address : in integer;
             --kernel_number : in integer;
             --sram_kernel_compute_done : in std_logic;
             kernel_data_valid : out std_logic;   
             kernel_data : OUT signed (SM_segment_bit-1 downto 0) 
     );
end sram_kernel;

architecture behavioral of sram_kernel is
    
    signal file_valid : std_logic;

    type Memory_Array is array (0 to 150 ) of signed (SM_segment_bit - 1 downto 0);  --for test, since the big array slows down the simulation

    signal kernel_memory : Memory_Array;
    --signal kernel_number_buffer, sram_kernel_index : integer;
    begin

    --kernel_number_buffer  <= kernel_number;

    process (kernel_clk)
    begin
        if kernel_reset = '1' then
            kernel_data_valid  <= '0';
            --sram_kernel_index  <= 0;
            --if (sram_kernel_compute_done = '1') then 
                --sram_kernel_index  <= 0;
            --end if;

        elsif rising_edge(kernel_clk) then        
            if kernel_enable = '1' then
                --if (sram_kernel_index < kernel_number_buffer) then
                    -- Read Memory
                    kernel_data <= kernel_memory(((kernel_address)));
                    kernel_data_valid  <= '1';
                    --sram_kernel_index  <= sram_kernel_index + 1;
                --else
                    --kernel_data_valid  <= '0';
                --end if;
            else
                kernel_data_valid  <= '0';
                end if;
            end if;      
    end process;


--------------------------------------------------------------------------------
-- tested version -- This version is used for testing, but may led to convolution result overflow in fixed point representation 
--------------------------------------------------------------------------------

   kernel_memory(0)   <=  b"0000000000001010";
   kernel_memory(1)   <=  b"0000000000001011";
   kernel_memory(2)   <=  b"0000000000001100";
   kernel_memory(3)   <=  b"0000000000000010";
   kernel_memory(4)   <=  b"0000000000000011";
   kernel_memory(5)   <=  b"0000000000000100";
   kernel_memory(6)   <=  b"0000000000000101";
   kernel_memory(7)   <=  b"0000000000000110";
   kernel_memory(8)   <=  b"0000000000000111";
   kernel_memory(9)   <=  b"0000000000001000";
   kernel_memory(10)   <=  b"0000000000001001";
   kernel_memory(11)   <=  b"0000000000001010";
   kernel_memory(12)   <=  b"0000000000001011";
   kernel_memory(13)   <=  b"0000000000001100";
   kernel_memory(14)   <=  b"0000000000001101";
   kernel_memory(15)   <=  b"0000000000001110";
   kernel_memory(16)   <=  b"0000000000001111";
   kernel_memory(17)   <=  b"0000000000010000";
   kernel_memory(18)   <=  b"0000000000010001";
   kernel_memory(19)   <=  b"0000000000010010";
   kernel_memory(20)   <=  b"0000000000010011";
   kernel_memory(21)   <=  b"0000000000010100";
   kernel_memory(22)   <=  b"0000000000010101";
   kernel_memory(23)   <=  b"0000000000010110";
   kernel_memory(24)   <=  b"0000000000010111";
   kernel_memory(25)   <=  b"0000000000011000";
   kernel_memory(26)   <=  b"0000000000011001";
   kernel_memory(27)   <=  b"0000000000011010";
   kernel_memory(28)   <=  b"0000000000011011";
   kernel_memory(29)   <=  b"0000000000011100";
   kernel_memory(30)   <=  b"0000000000011101";
   kernel_memory(31)   <=  b"0000000000011110";
   kernel_memory(32)   <=  b"0000000000011111";
   kernel_memory(33)   <=  b"0000000000100000";
   kernel_memory(34)   <=  b"0000000000100001";
   kernel_memory(35)   <=  b"0000000000100010";
   kernel_memory(36)   <=  b"0000000000100011";
   kernel_memory(37)   <=  b"0000000000100100";
   kernel_memory(38)   <=  b"0000000000100101";
   kernel_memory(39)   <=  b"0000000000100110";
   kernel_memory(40)   <=  b"0000000000100111";
   kernel_memory(41)   <=  b"0000000000101000";
   kernel_memory(42)   <=  b"0000000000101001";
   kernel_memory(43)   <=  b"0000000000101010";
   kernel_memory(44)   <=  b"0000000000101011";
   kernel_memory(45)   <=  b"0000000000101100";
   kernel_memory(46)   <=  b"0000000000101101";
   kernel_memory(47)   <=  b"0000000000101110";
   kernel_memory(48)   <=  b"0000000000101111";
   kernel_memory(49)   <=  b"0000000000110000";
   kernel_memory(50)   <=  b"0000000000110001";
   kernel_memory(51)   <=  b"0000000000110010";
   kernel_memory(52)   <=  b"0000000000110011";
   kernel_memory(53)   <=  b"0000000000110100";
   kernel_memory(54)   <=  b"0000000000110101";
   kernel_memory(55)   <=  b"0000000000110110";
   kernel_memory(56)   <=  b"0000000000110111";
   kernel_memory(57)   <=  b"0000000000111000";
   kernel_memory(58)   <=  b"0000000000111001";
   kernel_memory(59)   <=  b"0000000000111010";
   kernel_memory(60)   <=  b"0000000000111011";
   kernel_memory(61)   <=  b"0000000000111100";
   kernel_memory(62)   <=  b"0000000000111101";
   kernel_memory(63)   <=  b"0000000000111110";
   kernel_memory(64)   <=  b"0000000000111111";
   kernel_memory(65)   <=  b"0000000001000000";
   kernel_memory(66)   <=  b"0000000001000001";
   kernel_memory(67)   <=  b"0000000001000010";
   kernel_memory(68)   <=  b"0000000001000011";
   kernel_memory(69)   <=  b"0000000001000100";
   kernel_memory(70)   <=  b"0000000001000101";
   kernel_memory(71)   <=  b"0000000001000110";
   kernel_memory(72)   <=  b"0000000001000111";
   kernel_memory(73)   <=  b"0000000001001000";
   kernel_memory(74)   <=  b"0000000001001001";
   kernel_memory(75)   <=  b"0000000001001010";
   kernel_memory(76)   <=  b"0000000001001011";
   kernel_memory(77)   <=  b"0000000001001100";
   kernel_memory(78)   <=  b"0000000001001101";
   kernel_memory(79)   <=  b"0000000001001110";
   kernel_memory(80)   <=  b"0000000001001111";
   kernel_memory(81)   <=  b"0000000001010000";
   kernel_memory(82)   <=  b"0000000001010001";
   kernel_memory(83)   <=  b"0000000001010010";
   kernel_memory(84)   <=  b"0000000001010011";
   kernel_memory(85)   <=  b"0000000001010100";
   kernel_memory(86)   <=  b"0000000001010101";
   kernel_memory(87)   <=  b"0000000001010110";
   kernel_memory(88)   <=  b"0000000001010111";
   kernel_memory(89)   <=  b"0000000001011000";
   kernel_memory(90)   <=  b"0000000001011001";
   kernel_memory(91)   <=  b"0000000001011010";
   kernel_memory(92)   <=  b"0000000001011011";
   kernel_memory(93)   <=  b"0000000001011100";
   kernel_memory(94)   <=  b"0000000001011101";
   kernel_memory(95)   <=  b"0000000001011110";
   kernel_memory(96)   <=  b"0000000001011111";
   kernel_memory(97)   <=  b"0000000001100000";
   kernel_memory(98)   <=  b"0000000001100001";
   kernel_memory(99)   <=  b"0000000001100010";
   kernel_memory(100)   <=  b"0000000001100011";
   kernel_memory(101)   <=  b"0000000001100100";
   kernel_memory(102)   <=  b"0000000001100101";
   kernel_memory(103)   <=  b"0000000001100110";
   kernel_memory(104)   <=  b"0000000001100111";
   kernel_memory(105)   <=  b"0000000001101000";
   kernel_memory(106)   <=  b"0000000001101001";
   kernel_memory(107)   <=  b"0000000001101010";
   kernel_memory(108)   <=  b"0000000001101011";
   kernel_memory(109)   <=  b"0000000001101100";
   kernel_memory(110)   <=  b"0000000001101101";
   kernel_memory(111)   <=  b"0000000001101110";
   kernel_memory(112)   <=  b"0000000001101111";
   kernel_memory(113)   <=  b"0000000001110000";
   kernel_memory(114)   <=  b"0000000001110001";
   kernel_memory(115)   <=  b"0000000001110010";
   kernel_memory(116)   <=  b"0000000001110011";
   kernel_memory(117)   <=  b"0000000001110100";
   kernel_memory(118)   <=  b"0000000001110101";
   kernel_memory(119)   <=  b"0000000001110110";
   kernel_memory(120)   <=  b"0000000001110111";
   kernel_memory(121)   <=  b"0000000001111000";
   kernel_memory(122)   <=  b"0000000001111001";
   kernel_memory(123)   <=  b"0000000001111010";
   kernel_memory(124)   <=  b"0000000001111011";
   kernel_memory(125)   <=  b"0000000001111100";
   kernel_memory(126)   <=  b"0000000001111101";
   kernel_memory(127)   <=  b"0000000001111110";
   kernel_memory(128)   <=  b"0000000001111111";
   kernel_memory(129)   <=  b"0000000010000000";
   kernel_memory(130)   <=  b"0000000010000001";
   kernel_memory(131)   <=  b"0000000010000010";
   kernel_memory(132)   <=  b"0000000010000011";
   kernel_memory(133)   <=  b"0000000010000100";
   kernel_memory(134)   <=  b"0000000010000101";
   kernel_memory(135)   <=  b"0000000010000110";
   kernel_memory(136)   <=  b"0000000010000111";
   kernel_memory(137)   <=  b"0000000010001000";
   kernel_memory(138)   <=  b"0000000010001001";
   kernel_memory(139)   <=  b"0000000010001010";
   kernel_memory(140)   <=  b"0000000010001011";
   kernel_memory(141)   <=  b"0000000010001100";
   kernel_memory(142)   <=  b"0000000010001101";
   kernel_memory(143)   <=  b"0000000010001110";
   kernel_memory(144)   <=  b"0000000010001111";
   kernel_memory(145)   <=  b"0000000010010000";
   kernel_memory(146)   <=  b"0000000010010001";
   kernel_memory(147)   <=  b"0000000010010010";
   kernel_memory(148)   <=  b"0000000010010011";
   kernel_memory(149)   <=  b"0000000010010100";
   kernel_memory(150)   <=  b"0000000010010101";


end behavioral;