LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
--use work.func_external.all;
use std.textio.all;
use ieee.std_logic_textio.all;


--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------


entity pre_buffer_fsm is
	port (
		pre_buffer_fsm_clock         : in std_logic;
		pre_buffer_fsm_reset         : in std_logic;
		pre_buffer_fsm_enable		: in std_logic;
		max_pooling_enable			: in std_logic;
		relu_enable					: in std_logic;
		ccm_din_shift				: in std_logic;
		ccm_din_data_valid			: in std_logic;		--shift signal sent from mac_ccm
		ccm_din1_1					: in integer;
		ccm_din1_2					: in integer;
		ccm_din2_1					: in integer;
		ccm_din2_2					: in integer;
		ccm_din3_1					: in integer;
		ccm_din3_2					: in integer;
		ccm_din4_1					: in integer;
		ccm_din4_2					: in integer;
		ccm_din5_1					: in integer;
		ccm_din5_2					: in integer;
		ccm_din6_1					: in integer;
		ccm_din6_2					: in integer;
		ccm_din7_1					: in integer;
		ccm_din7_2					: in integer;
		ccm_din8_1					: in integer;
		ccm_din8_2					: in integer;
		ccm_din9_1					: in integer;
		ccm_din9_2					: in integer;
		ccm_din10_1					: in integer;
		ccm_din10_2					: in integer;
		ccm_din11_1					: in integer;
		ccm_din11_2					: in integer;
		ccm_din12_1					: in integer;
		ccm_din12_2					: in integer;
		ccm_din13_1					: in integer;
		ccm_din13_2					: in integer;
		ccm_din14_1					: in integer;
		ccm_din14_2					: in integer;
		ccm_din15_1					: in integer;
		ccm_din15_2					: in integer;
		ccm_din16_1					: in integer;
		ccm_din16_2					: in integer;

		pre_done 					: out std_logic
	);
end pre_buffer_fsm;

architecture pre_buffer_fsm_arc of pre_buffer_fsm is

type type_state is (reset,new_start,max_pooling_state_1,max_pooling_state_2,relu_state,none_state,done,done_pooling,print);
signal current_state,next_state,tmp_state : type_state;
signal index : integer;

type Memory_Array is array (0 to 31 ) of integer;   

signal pre_buffer : Memory_Array;
signal sm,sm2 : std_logic_vector(15 downto 0);
signal ready : std_logic;
	
begin

pre_done  <= ready;

-----------------------------------------------------------------------------
--  next state
-----------------------------------------------------------------------------	

	next_state_proc: process(pre_buffer_fsm_clock,pre_buffer_fsm_reset)
	begin
			if (pre_buffer_fsm_reset = '1') then
				current_state  <= reset;
				index  <= 0;

			elsif (rising_edge(pre_buffer_fsm_clock)) then
				if (pre_buffer_fsm_enable = '1') then

					current_state  <= next_state;
						
					if( index  <= 18) then 
						index  <= index + 1;
					else 
						index  <= 0;
					end if;
				
				else 
					current_state  <= reset;
				end	 if;
			end if;
	end process next_state_proc;

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------

	future_state_proc: process(current_state,index)

	begin
		
		case current_state is

			when reset => 
				if (pre_buffer_fsm_enable = '1') then
						next_state  <= new_start;
				else
					next_state  <= reset;
				end if;

			when new_start  => 
				--if (pre_buffer_fsm_enable = '1') then
					if(ccm_din_data_valid = '1') then
						if (relu_enable = '1' and max_pooling_enable = '1') then
							next_state  <= relu_state;
						elsif ( relu_enable = '0' and max_pooling_enable = '1') then
							next_state  <= max_pooling_state_1;
						elsif ( relu_enable = '0' and max_pooling_enable = '0') then
							next_state  <= none_state;
						elsif ( relu_enable = '1' and max_pooling_enable = '0') then
							next_state  <= relu_state;
						end if;
					else
						next_state  <= new_start;
					end if;
				--else
					--next_state  <= reset;
				--end if;

			when relu_state => 
				--if (pre_buffer_fsm_enable = '1') then
				if (max_pooling_enable = '0') then
					next_state  <= done;
				else
					next_state  <= max_pooling_state_1;
				end if;
				--else
					--next_state  <= reset;
				--end if;

			when max_pooling_state_1  => 
				--if (pre_buffer_fsm_enable = '1') then
					if (ccm_din_data_valid = '1') then

						next_state  <= max_pooling_state_2;
					end if;
				--else
					--next_state  <= reset;
				--end if;

			when max_pooling_state_2  => 
				--if (pre_buffer_fsm_enable = '1') then
					next_state  <= done_pooling;
				--else
					--next_state  <= reset;
				--end if;

			when done  => 
				--if (pre_buffer_fsm_enable = '1') then
					next_state  <= print;
				--else
					--next_state  <= reset;
				--end if;	

			when done_pooling  => 
				--if (pre_buffer_fsm_enable = '1') then
					next_state  <= print;
				--else
					--next_state  <= reset;
				--end if;	

			when none_state  => 
				--if (pre_buffer_fsm_enable = '1') then
					next_state  <= done;
				--else
					--next_state  <= reset;
				--end if;	

			when print  => 
				next_state  <= new_start;

		end case;
	end process future_state_proc;


--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------


	output_network: process(current_state,index)
	variable oline : line;
	file text_var : text;
	


	begin
		case current_state is

			when reset => 
                pre_buffer <= (others => 0);
                sm  <= (others  => '0');
                sm2  <= (others  => '0');
                ready  <= '0';
--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------

			when new_start  => 
				sm  <= (others  => '0');
				sm2  <= (others  => '0');
				ready  <= '0';

				pre_buffer(0)  <= ccm_din1_1;
				pre_buffer(16)  <= ccm_din1_2;
				pre_buffer(1)  <= ccm_din2_1;
				pre_buffer(17)  <= ccm_din2_2;
				pre_buffer(2)  <= ccm_din3_1;
				pre_buffer(18)  <= ccm_din3_2;
				pre_buffer(3)  <= ccm_din4_1;
				pre_buffer(19)  <= ccm_din4_2;
				pre_buffer(4)  <= ccm_din5_1;
				pre_buffer(20)  <= ccm_din5_2;
				pre_buffer(5)  <= ccm_din6_1;
				pre_buffer(21)  <= ccm_din6_2;
				pre_buffer(6)  <= ccm_din7_1;
				pre_buffer(22)  <= ccm_din7_2;
				pre_buffer(7)  <= ccm_din8_1;
				pre_buffer(23)  <= ccm_din8_2;
				pre_buffer(8)  <= ccm_din9_1;
				pre_buffer(24)  <= ccm_din9_2;
				pre_buffer(9)  <= ccm_din10_1;
				pre_buffer(25)  <= ccm_din10_2;
				pre_buffer(10)  <= ccm_din11_1;
				pre_buffer(26)  <= ccm_din11_2;
				pre_buffer(11)  <= ccm_din12_1;
				pre_buffer(27)  <= ccm_din12_2;
				pre_buffer(12)  <= ccm_din13_1;
				pre_buffer(28)  <= ccm_din13_2;
				pre_buffer(13)  <= ccm_din14_1;
				pre_buffer(29)  <= ccm_din14_2;
				pre_buffer(14)  <= ccm_din15_1;
				pre_buffer(30)  <= ccm_din15_2;
				pre_buffer(15)  <= ccm_din16_1;
				pre_buffer(31)  <= ccm_din16_2;


--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------

			when max_pooling_state_1  => 
				if (pre_buffer(0) <= pre_buffer(16)) then
					pre_buffer(0)  <= pre_buffer(16);
				end if;

				if (pre_buffer(1) <= pre_buffer(17)) then
					pre_buffer(1)  <= pre_buffer(17);
				end if;

				if (pre_buffer(2) <= pre_buffer(18)) then
					pre_buffer(2)  <= pre_buffer(18);
				end if;

				if (pre_buffer(3) <= pre_buffer(19)) then
					pre_buffer(3)  <= pre_buffer(19);
				end if;

				if (pre_buffer(4) <= pre_buffer(20)) then
					pre_buffer(4)  <= pre_buffer(20);
				end if;

				if (pre_buffer(5) <= pre_buffer(21)) then
					pre_buffer(5)  <= pre_buffer(21);
				end if;

				if (pre_buffer(6) <= pre_buffer(22)) then
					pre_buffer(6)  <= pre_buffer(22);
				end if;

				if (pre_buffer(7) <= pre_buffer(23)) then
					pre_buffer(7)  <= pre_buffer(23);
				end if;

				if (pre_buffer(8) <= pre_buffer(24)) then
					pre_buffer(8)  <= pre_buffer(24);
				end if;

				if (pre_buffer(9) <= pre_buffer(25)) then
					pre_buffer(9)  <= pre_buffer(25);
				end if;

				if (pre_buffer(10) <= pre_buffer(26)) then
					pre_buffer(10)  <= pre_buffer(26);
				end if;

				if (pre_buffer(11) <= pre_buffer(27)) then
					pre_buffer(11)  <= pre_buffer(27);
				end if;

				if (pre_buffer(12) <= pre_buffer(28)) then
					pre_buffer(12)  <= pre_buffer(28);
				end if;

				if (pre_buffer(13) <= pre_buffer(29)) then
					pre_buffer(13)  <= pre_buffer(29);
				end if;

				if (pre_buffer(14) <= pre_buffer(30)) then
					pre_buffer(14)  <= pre_buffer(30);
				end if;

				if (pre_buffer(15) <= pre_buffer(31)) then
					pre_buffer(15)  <= pre_buffer(31);
				end if;
				

-------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------

			when max_pooling_state_2  => 

				if ( ccm_din1_1 >= ccm_din1_2) then
					if (ccm_din1_1 >= pre_buffer(0)) then
						pre_buffer(0)  <= ccm_din1_1;
					end if;
				else
					if (ccm_din1_2 >= pre_buffer(0)) then
						pre_buffer(0)  <= ccm_din1_2;
					end if;
				end if;


				if ( ccm_din2_1 >= ccm_din2_2) then
					if (ccm_din2_1 >= pre_buffer(1)) then
						pre_buffer(1)  <= ccm_din2_1;
					end if;
				else
					if (ccm_din2_2 >= pre_buffer(1)) then
						pre_buffer(1)  <= ccm_din2_2;
					end if;
				end if;


				if ( ccm_din3_1 >= ccm_din3_2) then
					if (ccm_din3_1 >= pre_buffer(2)) then
						pre_buffer(2)  <= ccm_din3_1;
					end if;
				else
					if (ccm_din3_2 >= pre_buffer(2)) then
						pre_buffer(2)  <= ccm_din3_2;
					end if;
				end if;


				if ( ccm_din4_1 >= ccm_din4_2) then
					if (ccm_din4_1 >= pre_buffer(3)) then
						pre_buffer(3)  <= ccm_din4_1;
					end if;
				else
					if (ccm_din4_2 >= pre_buffer(3)) then
						pre_buffer(3)  <= ccm_din4_2;
					end if;
				end if;


				if ( ccm_din5_1 >= ccm_din5_2) then
					if (ccm_din5_1 >= pre_buffer(4)) then
						pre_buffer(4)  <= ccm_din5_1;
					end if;
				else
					if (ccm_din5_2 >= pre_buffer(4)) then
						pre_buffer(4)  <= ccm_din5_2;
					end if;
				end if;


				if ( ccm_din6_1 >= ccm_din6_2) then
					if (ccm_din6_1 >= pre_buffer(5)) then
						pre_buffer(5)  <= ccm_din6_1;
					end if;
				else
					if (ccm_din6_2 >= pre_buffer(5)) then
						pre_buffer(5)  <= ccm_din6_2;
					end if;
				end if;


				if ( ccm_din7_1 >= ccm_din7_2) then
					if (ccm_din7_1 >= pre_buffer(6)) then
						pre_buffer(6)  <= ccm_din7_1;
					end if;
				else
					if (ccm_din7_2 >= pre_buffer(6)) then
						pre_buffer(6)  <= ccm_din7_2;
					end if;
				end if;


				if ( ccm_din8_1 >= ccm_din8_2) then
					if (ccm_din8_1 >= pre_buffer(7)) then
						pre_buffer(7)  <= ccm_din8_1;
					end if;
				else
					if (ccm_din8_2 >= pre_buffer(7)) then
						pre_buffer(7)  <= ccm_din8_2;
					end if;
				end if;


				if ( ccm_din9_1 >= ccm_din9_2) then
					if (ccm_din9_1 >= pre_buffer(8)) then
						pre_buffer(8)  <= ccm_din9_1;
					end if;
				else
					if (ccm_din9_2 >= pre_buffer(8)) then
						pre_buffer(8)  <= ccm_din9_2;
					end if;
				end if;


				if ( ccm_din10_1 >= ccm_din10_2) then
					if (ccm_din10_1 >= pre_buffer(9)) then
						pre_buffer(9)  <= ccm_din10_1;
					end if;
				else
					if (ccm_din10_2 >= pre_buffer(9)) then
						pre_buffer(9)  <= ccm_din10_2;
					end if;
				end if;


				if ( ccm_din11_1 >= ccm_din11_2) then
					if (ccm_din11_1 >= pre_buffer(10)) then
						pre_buffer(10)  <= ccm_din11_1;
					end if;
				else
					if (ccm_din11_2 >= pre_buffer(10)) then
						pre_buffer(10)  <= ccm_din11_2;
					end if;
				end if;


				if ( ccm_din12_1 >= ccm_din12_2) then
					if (ccm_din12_1 >= pre_buffer(11)) then
						pre_buffer(11)  <= ccm_din12_1;
					end if;
				else
					if (ccm_din12_2 >= pre_buffer(11)) then
						pre_buffer(11)  <= ccm_din12_2;
					end if;
				end if;


				if ( ccm_din13_1 >= ccm_din13_2) then
					if (ccm_din13_1 >= pre_buffer(12)) then
						pre_buffer(12)  <= ccm_din13_1;
					end if;
				else
					if (ccm_din13_2 >= pre_buffer(12)) then
						pre_buffer(12)  <= ccm_din13_2;
					end if;
				end if;


				if ( ccm_din14_1 >= ccm_din14_2) then
					if (ccm_din14_1 >= pre_buffer(13)) then
						pre_buffer(13)  <= ccm_din14_1;
					end if;
				else
					if (ccm_din14_2 >= pre_buffer(13)) then
						pre_buffer(13)  <= ccm_din14_2;
					end if;
				end if;


				if ( ccm_din15_1 >= ccm_din15_2) then
					if (ccm_din15_1 >= pre_buffer(14)) then
						pre_buffer(14)  <= ccm_din15_1;
					end if;
				else
					if (ccm_din15_2 >= pre_buffer(14)) then
						pre_buffer(14)  <= ccm_din15_2;
					end if;
				end if;


				if ( ccm_din16_1 >= ccm_din16_2) then
					if (ccm_din16_1 >= pre_buffer(15)) then
						pre_buffer(15)  <= ccm_din16_1;
					end if;
				else
					if (ccm_din16_2 >= pre_buffer(15)) then
						pre_buffer(15)  <= ccm_din16_2;
					end if;
				end if;


-----------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------


			when relu_state  => 
				if (pre_buffer(0) < 0) then
					pre_buffer(0)  <= 0;
				end if;

				if (pre_buffer(16) < 0) then
					pre_buffer(16)  <= 0;  
				end if; 


				if (pre_buffer(1) < 0) then
					pre_buffer(1)  <= 0;
				end if;

				if (pre_buffer(17) < 0) then
					pre_buffer(17)  <= 0;  
				end if; 


				if (pre_buffer(2) < 0) then
					pre_buffer(2)  <= 0;
				end if;

				if (pre_buffer(18) < 0) then
					pre_buffer(18)  <= 0;  
				end if; 


				if (pre_buffer(3) < 0) then
					pre_buffer(3)  <= 0;
				end if;

				if (pre_buffer(19) < 0) then
					pre_buffer(19)  <= 0;  
				end if; 


				if (pre_buffer(4) < 0) then
					pre_buffer(4)  <= 0;
				end if;

				if (pre_buffer(20) < 0) then
					pre_buffer(20)  <= 0;  
				end if; 


				if (pre_buffer(5) < 0) then
					pre_buffer(5)  <= 0;
				end if;

				if (pre_buffer(21) < 0) then
					pre_buffer(21)  <= 0;  
				end if; 


				if (pre_buffer(6) < 0) then
					pre_buffer(6)  <= 0;
				end if;

				if (pre_buffer(22) < 0) then
					pre_buffer(22)  <= 0;  
				end if; 


				if (pre_buffer(7) < 0) then
					pre_buffer(7)  <= 0;
				end if;

				if (pre_buffer(23) < 0) then
					pre_buffer(23)  <= 0;  
				end if; 


				if (pre_buffer(8) < 0) then
					pre_buffer(8)  <= 0;
				end if;

				if (pre_buffer(24) < 0) then
					pre_buffer(24)  <= 0;  
				end if; 


				if (pre_buffer(9) < 0) then
					pre_buffer(9)  <= 0;
				end if;

				if (pre_buffer(25) < 0) then
					pre_buffer(25)  <= 0;  
				end if; 


				if (pre_buffer(10) < 0) then
					pre_buffer(10)  <= 0;
				end if;

				if (pre_buffer(26) < 0) then
					pre_buffer(26)  <= 0;  
				end if; 


				if (pre_buffer(11) < 0) then
					pre_buffer(11)  <= 0;
				end if;

				if (pre_buffer(27) < 0) then
					pre_buffer(27)  <= 0;  
				end if; 


				if (pre_buffer(12) < 0) then
					pre_buffer(12)  <= 0;
				end if;

				if (pre_buffer(28) < 0) then
					pre_buffer(28)  <= 0;  
				end if; 


				if (pre_buffer(13) < 0) then
					pre_buffer(13)  <= 0;
				end if;

				if (pre_buffer(29) < 0) then
					pre_buffer(29)  <= 0;  
				end if; 


				if (pre_buffer(14) < 0) then
					pre_buffer(14)  <= 0;
				end if;

				if (pre_buffer(30) < 0) then
					pre_buffer(30)  <= 0;  
				end if; 


				if (pre_buffer(15) < 0) then
					pre_buffer(15)  <= 0;
				end if;

				if (pre_buffer(31) < 0) then
					pre_buffer(31)  <= 0;  
				end if; 

			when none_state  => 
				ready  <= '1';

			when done  => 
				for i in 0 to 15 loop
					if(pre_buffer(i) /= 0) then
						sm(i)  <= '1';
					else
						sm(i)  <= '0';
					end if;
				end loop;

				for i in 16 to 31 loop
					if(pre_buffer(i) /= 0) then
						sm2(i-16)  <= '1';
					else
						sm2(i-16)  <= '0';
					end if;
				end loop;

				ready  <= '1';

			when done_pooling  => 
				for i in 0 to 15 loop 
					if(pre_buffer(i) /= 0) then
						sm(i)  <= '1';
					else
						sm(i)  <= '0';
					end if;
				end loop;

				ready  <= '1';


			when print  => 
			file_open(text_var,"C:/Users/HAO/OneDrive/Desktop/Nullhop/output.txt",write_mode);
				if (ready = '1') then
					if ( max_pooling_enable = '1') then
						
						--write(oline,to_integer(unsigned(sm)), right,16);
						write(oline,sm);
						writeline(text_var,oline);

						for i in 0 to 15 loop
							if (pre_buffer(i) /= 0) then 
								write(oline,std_logic_vector(to_signed(pre_buffer(i),16)));
								writeline(text_var,oline);
							end if;
						end loop;

					elsif ( max_pooling_enable = '0') then
						
						write(oline,sm);
						writeline(text_var,oline);
						
						for i in 0 to 15 loop
							if (pre_buffer(i) /= 0) then 
								write(oline,std_logic_vector(to_signed(pre_buffer(i),16)));
								writeline(text_var,oline);
							end if;
						end loop;

						write(oline,sm2) ;
						writeline(text_var,oline);
						
						for i in 16 to 31 loop
							if (pre_buffer(i) /= 0) then 
								write(oline,std_logic_vector(to_signed(pre_buffer(i),16)));
								writeline(text_var,oline);
							end if;
						end loop;
					end if;
				end if;




		end case;

	end process output_network;



--outputing : process(pre_buffer_fsm_clock,pre_buffer_fsm_reset,index)

--variable oline : line;
--file text_var : text;


--begin
--file_open(text_var,"C:/Users/HAO/OneDrive/Desktop/Nullhop/output.txt",write_mode);
--	if (ready = '1') then
--		if ( max_pooling_enable = '1') then
			
--			write(oline,to_integer(unsigned(sm)), right,16);
--			writeline(text_var,oline);

--			for i in 0 to 15 loop 
--				write(oline,pre_buffer(i));
--				writeline(text_var,oline);
--			end loop;

--		elsif ( max_pooling_enable = '0') then
			
--			write(oline,to_integer(unsigned(sm)),right,16);
--			writeline(text_var,oline);
			
--			for i in 0 to 15 loop 
--				write(oline,pre_buffer(i));
--				writeline(text_var,oline);
--			end loop;

--			write(oline,to_integer(unsigned(sm2)),right,16) ;
--			writeline(text_var,oline);
			
--			for i in 16 to 31 loop
--				write(oline,pre_buffer(i));
--				writeline(text_var,oline);
--			end loop;
--		end if;
--	end if;
--end process;

end pre_buffer_fsm_arc;