LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
--use work.func_external.all;

entity locator_fsmversion is 
	port( 
		fsm0_valid_ori           : in integer;
		fsm0_data_ori            : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm0_x_ori 		         : in integer;
		fsm0_y_ori 		         : in integer;
		fsm0_z_ori 		         : in integer;

		fsm1_valid_ori           : in integer;
		fsm1_data_ori            : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm1_x_ori 		         : in integer;
		fsm1_y_ori 		         : in integer;
		fsm1_z_ori 		         : in integer;

		fsm2_valid_ori           : in integer;
		fsm2_data_ori            : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm2_x_ori 		         : in integer;
		fsm2_y_ori 		         : in integer;
		fsm2_z_ori 		         : in integer;

		fsm3_valid_ori           : in integer;
		fsm3_data_ori            : in std_logic_vector ( SM_segment_bit-1 downto 0 );
		fsm3_x_ori 		         : in integer;
		fsm3_y_ori 		         : in integer;
		fsm3_z_ori 		         : in integer;  	--4 set of inputs coming from IDP, each set composed of pixel value, and pixel coordinates

		mac_loc_compute_done : in std_logic;  	--receive from mac_ccm, every time mac_ccm finished one pixel's all multiplication with kernels, this signal is one 
		locator_clk          : in std_logic;
		locator_en           : in std_logic;
		locator_rst          : in std_logic;
		fsm_is_in_halt       : in std_logic;  	--if this is one, means the FSM is still in halt state

		locator_data_out     : out  integer;
		data_valid           : out std_logic;  	--if the pixel sent to mac_control is valid 
		trigger_mac_control  : out std_logic;  	--used to trigger mac_control unit. If this signal is one, the mac_control begin to calculate the pixel's corrisponding corrdinates
		stop_IDP             : out std_logic;	--used to stop IDP FSM
		pixel_x              : out integer;
		pixel_y              : out integer;
		pixel_z              : out integer
	 );
end locator_fsmversion;

architecture bhv of locator_fsmversion is


	type type_state is (reset,prepare,stripe1_store,stripe2_store,stripe3_store,stripe4_store,locator_stripe_switch,start,
					one_stripe_0,one_stripe_1,one_stripe_2,one_stripe_3,
					two_stripe_01,two_stripe_02,two_stripe_03,two_stripe_12,two_stripe_13,two_stripe_23,
					three_stripe_013,three_stripe_012,three_stripe_023,three_stripe_123,
					four_stripe_0123	);
	signal current_state,next_state,tmp_state : type_state;





signal trigger_index, start_index : integer;
signal stripe_index : integer;
signal index : integer;

signal fsm0_valid_reg : integer; 
signal fsm0_data_reg : std_logic_vector (SM_segment_bit-1 downto 0); 
signal fsm0_x_reg : integer; 
signal fsm0_y_reg : integer;
signal fsm0_z_reg : integer;

signal fsm0_valid_reg_reg : integer;
signal fsm0_data_reg_reg : std_logic_vector (SM_segment_bit-1 downto 0);
signal fsm0_x_reg_reg : integer;
signal fsm0_y_reg_reg: integer;
signal fsm0_z_reg_reg: integer;

signal fsm0_valid_reg_reg_reg  : integer;
signal fsm0_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm0_x_reg_reg_reg  : integer;
signal fsm0_y_reg_reg_reg  : integer;
signal fsm0_z_reg_reg_reg  : integer;

signal fsm0_valid_reg_reg_reg_reg  : integer;
signal fsm0_data_reg_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm0_x_reg_reg_reg_reg  : integer;
signal fsm0_y_reg_reg_reg_reg  : integer;
signal fsm0_z_reg_reg_reg_reg  : integer;

signal fsm1_valid_reg : integer; 
signal fsm1_data_reg : std_logic_vector (SM_segment_bit-1 downto 0); 
signal fsm1_x_reg : integer;
signal fsm1_y_reg  : integer;
signal fsm1_z_reg 	: integer;

signal fsm1_valid_reg_reg : integer;
signal fsm1_data_reg_reg : std_logic_vector (SM_segment_bit-1 downto 0);
signal fsm1_x_reg_reg: integer;
signal fsm1_y_reg_reg : integer;
signal fsm1_z_reg_reg	: integer;

signal fsm1_valid_reg_reg_reg  : integer;
signal fsm1_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm1_x_reg_reg_reg  : integer;
signal fsm1_y_reg_reg_reg  : integer;
signal fsm1_z_reg_reg_reg  : integer;

signal fsm1_valid_reg_reg_reg_reg  : integer;
signal fsm1_data_reg_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm1_x_reg_reg_reg_reg  : integer;
signal fsm1_y_reg_reg_reg_reg  : integer;
signal fsm1_z_reg_reg_reg_reg  : integer;

signal fsm2_valid_reg : integer; 
signal fsm2_data_reg : std_logic_vector (SM_segment_bit-1 downto 0); 
signal fsm2_x_reg 	: integer;
signal fsm2_y_reg 	: integer;
signal fsm2_z_reg 	: integer;

signal fsm2_valid_reg_reg : integer;
signal fsm2_data_reg_reg : std_logic_vector (SM_segment_bit-1 downto 0);
signal fsm2_x_reg_reg	: integer;
signal fsm2_y_reg_reg	: integer;
signal fsm2_z_reg_reg	: integer;

signal fsm2_valid_reg_reg_reg  : integer;
signal fsm2_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm2_x_reg_reg_reg  : integer;
signal fsm2_y_reg_reg_reg  : integer;
signal fsm2_z_reg_reg_reg  : integer;

signal fsm2_valid_reg_reg_reg_reg  : integer;
signal fsm2_data_reg_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm2_x_reg_reg_reg_reg  : integer;
signal fsm2_y_reg_reg_reg_reg  : integer;
signal fsm2_z_reg_reg_reg_reg  : integer;

signal fsm3_valid_reg : integer; 
signal fsm3_data_reg : std_logic_vector (SM_segment_bit-1 downto 0);
signal fsm3_x_reg 	: integer;
signal fsm3_y_reg 	: integer;
signal fsm3_z_reg 	: integer;

signal fsm3_valid_reg_reg : integer;
signal fsm3_data_reg_reg: std_logic_vector (SM_segment_bit-1 downto 0);
signal fsm3_x_reg_reg	: integer;
signal fsm3_y_reg_reg	: integer;
signal fsm3_z_reg_reg	: integer;

signal fsm3_valid_reg_reg_reg  : integer;
signal fsm3_data_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm3_x_reg_reg_reg  : integer;
signal fsm3_y_reg_reg_reg  : integer;
signal fsm3_z_reg_reg_reg  : integer;

signal fsm3_valid_reg_reg_reg_reg  : integer;
signal fsm3_data_reg_reg_reg_reg  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm3_x_reg_reg_reg_reg  : integer;
signal fsm3_y_reg_reg_reg_reg  : integer;
signal fsm3_z_reg_reg_reg_reg  : integer;

signal loc_compute_done, trigger_mac, trigger_mac_buffer: std_logic;

signal fsm0_valid  : integer;
signal fsm0_data  : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm0_x  : integer;
signal fsm0_y  : integer;
signal fsm0_z  : integer;

signal fsm1_valid : integer;
signal fsm1_data : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm1_x : integer;
signal fsm1_y : integer;
signal fsm1_z : integer;

signal fsm2_valid : integer;
signal fsm2_data : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm2_x : integer;
signal fsm2_y : integer;
signal fsm2_z : integer;

signal fsm3_valid : integer;
signal fsm3_data : std_logic_vector ( SM_segment_bit-1 downto 0 );
signal fsm3_x : integer;
signal fsm3_y : integer;
signal fsm3_z : integer;

begin

----------------------------------------------------------------------------
-- this process is to transfer the mac_ccm compute done signal to the falling edge
-- the original compute done signal from mac_ccm is following rising edge of clk
-- with this process it will follow falling edge of clk
----------------------------------------------------------------------------
	

compute_done_to_falling_edge: process (locator_rst,locator_clk)
begin
	if (falling_edge(locator_clk)) then
		loc_compute_done  <= mac_loc_compute_done;
	end if;
end process;


--------------------------------------------------------------------------------
-- this process is used to generate one cycle pulse to trigger the working of mac_control
-- everytime mac_control finished outputing the kernel address of one  pixel
-- mac_control will stuck in one state, unless this trigger signal is high
-- no need to continous high, just one cycle high pulse to drag mac_control from the stucked state
--------------------------------------------------------------------------------


data_valid_pulse_generation: process (locator_rst,locator_clk)
begin

	if (rising_edge(locator_clk)) then
		trigger_mac_buffer  <= trigger_mac;
	end if;
end process;	


trigger_mac_control  <= (trigger_mac xor trigger_mac_buffer);

--------------------------------------------------------------------------------
-- Falling Edge Detector
--------------------------------------------------------------------------------
delay_input_falling_edge : process(locator_clk,locator_rst)
begin
  if(locator_rst = '1') then
  	fsm0_data  	<= (others  => '0');
  	fsm1_data  	<= (others  => '0');
  	fsm2_data  	<= (others  => '0');
  	fsm3_data  	<= (others  => '0');
  	fsm0_valid  <= 0;
  	fsm1_valid  <= 0;
  	fsm2_valid  <= 0;
  	fsm3_valid  <= 0;
  	fsm0_x      <= 0;
  	fsm0_y      <= 0;
  	fsm0_z      <= 0;
  	fsm1_x      <= 0;
  	fsm1_y      <= 0;
  	fsm1_z      <= 0;
  	fsm2_x      <= 0;
  	fsm2_y      <= 0;
  	fsm2_z      <= 0;
  	fsm3_x      <= 0;
  	fsm3_y      <= 0;
  	fsm3_z      <= 0;

  elsif(falling_edge(locator_clk)) then
 		fsm0_data  	<= fsm0_data_ori;
		fsm1_data  	<= fsm1_data_ori;
		fsm2_data  	<= fsm2_data_ori;
		fsm3_data  	<= fsm3_data_ori;
		fsm0_valid  <= fsm0_valid_ori;
		fsm1_valid  <= fsm1_valid_ori;
		fsm2_valid  <= fsm2_valid_ori;
		fsm3_valid  <= fsm3_valid_ori;
		fsm0_x      <= fsm0_x_ori;
		fsm0_y      <= fsm0_y_ori;
		fsm0_z      <= fsm0_z_ori;
		fsm1_x      <= fsm1_x_ori;
		fsm1_y      <= fsm1_y_ori;
		fsm1_z      <= fsm1_z_ori;
		fsm2_x      <= fsm2_x_ori;
		fsm2_y      <= fsm2_y_ori;
		fsm2_z      <= fsm2_z_ori;
		fsm3_x      <= fsm3_x_ori;
		fsm3_y      <= fsm3_y_ori;
		fsm3_z      <= fsm3_z_ori;
  end if;
end process delay_input_falling_edge;



--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------



-----------------------------------------------------------------------------
--  next state
-----------------------------------------------------------------------------	

	next_state_proc: process(locator_clk,locator_rst)
	begin
			if (locator_rst = '1') then
				current_state  <= reset;
				trigger_index  <= 0;	--used to trigger the FSM, nothing particular


			elsif (rising_edge(locator_clk)) then
				if (locator_en  = '1') then

						current_state  <= next_state;
						
							if( trigger_index  <= 16) then 
								trigger_index  <= trigger_index + 1;
							else 
								trigger_index  <= 0;
					end	 if;
				else 
					current_state  <= reset;
				end if;
			end if;
	end process next_state_proc;

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------

	future_state_proc: process(current_state,trigger_index)
	begin
		
		case current_state is

			when reset => 
				if (locator_en = '1') then
					next_state  <= start;
				else
					next_state  <= reset;
				end if;

			when start  => 
				if (locator_en = '1') then
					--if (fsm_is_in_halt = '0') then 
						next_state  <= stripe1_store;
					--else
						--next_state  <= start;
					--end if;
				else
					next_state  <= reset;
				end if;

--------------------------------------------------------------------------------
-- we have three store state : stripe1_store, stripe2_store, stripe3_store
-- this is because everytime the locator found useful pixel, it will raise stop_IDP to stop FSM
-- but from the stop_IDP is 1, to the FSM is really in halt, there are 3 cycles new output from FSM
-- so we used 3 state to store these temporary values
-- Everytime the FSM is stopped, we already have 3 sets output from FSM
-- so the oldeset is in XXX_reg, 2nd olest is in XXX_reg_reg, the value just spit out before FSM stops is XXX_reg_reg_reg
--------------------------------------------------------------------------------


			when stripe1_store  => 
				if (locator_en = '1') then

					if( fsm0_valid /= 2 and  fsm1_valid /= 2 and  fsm2_valid /= 2 and  fsm3_valid /= 2  and fsm0_valid /= 5 and fsm3_valid /= 5) then 	
																	--means in this stripe, this is nothing useful, all pixel values are not valid 
						next_state  <= stripe1_store;
					else 
						next_state  <= stripe2_store;

					end if;

				else
					next_state  <= reset;
				end if;
			
			
			when stripe2_store  => 
				if (locator_en = '1') then
					next_state  <= stripe3_store;

				else
					next_state  <= reset;
				end if;
			
			when stripe3_store  => 
				if (locator_en = '1') then

					next_state  <= stripe4_store;

				else
					next_state  <= reset;
				end if;

			when stripe4_store  => 
				if (locator_en = '1') then

					next_state  <= prepare;

				else
					next_state  <= reset;
				end if;

			when locator_stripe_switch  => 
				if (locator_en = '1') then
					if (stripe_index < 3) then
						next_state  <= prepare;
					else
						next_state  <= start;
					end if;
				else
					next_state  <= reset;
				end if;


			when prepare  => 
-----------------------------------------------------------------------
-- one valid in each stripe
-----------------------------------------------------------------------

				if (locator_en = '1') then

					if( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 and fsm3_valid_reg /= 5 and fsm0_valid_reg /= 5 ) then

					next_state  <= locator_stripe_switch;

				elsif( (fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2) and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5)  ) then 
				 --fsm3 is valid, others are zero pixel

				 	next_state  <= one_stripe_3;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm2 is valid, others are zero pixel value

					next_state  <= one_stripe_2;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm1 is valid,  fsm0/2/3 are zero pixel

					next_state  <= one_stripe_1;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0 is valid,  fsm1/2/3 are zero pixel

					next_state  <= one_stripe_0;

--------------------------------------------------------------------------------
-- two valid in one stripe
--------------------------------------------------------------------------------

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5) ) then
				--fsm2/3 are valid,  fsm0/1 are zero pixels

						next_state  <= two_stripe_23;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5) ) then
				--fsm1/3 are valid, fsm0/4 are zero pixels 

						next_state  <= two_stripe_13;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg /= 2 and  fsm2_valid_reg /= 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5) )then
				--fsm0/3  are valid,  fsm1/2 are zero pixels

						next_state  <= two_stripe_03;

				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm1/2 are valid, fsm0/3 are zero pixels

						next_state  <= two_stripe_12;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/2 are valid,  fsm1/3 are zero pixels

						next_state  <= two_stripe_02;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/1 are valid, fsm2/3 are zero pixels

						next_state  <= two_stripe_01;

--------------------------------------------------------------------------------
-- three valid in one stripe
--------------------------------------------------------------------------------


				elsif( fsm0_valid_reg /= 2 and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5)  ) then
				--fsm1/2/3 are valid,   fsm0 is zero pixel

						next_state  <= three_stripe_123;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg /= 2 and  fsm2_valid_reg = 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5)  ) then
				--fsm0/2/3 are valid,  fsm1 is zero pixel

						next_state  <= three_stripe_023;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  fsm3_valid_reg /= 2 ) then
				--fsm0/1/2 are valid,  fsm3 is zero pixel

						next_state  <= three_stripe_012;

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg = 2 and  fsm2_valid_reg /= 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5) ) then
				--fsm0/1/3 are valid,  fsm3 is zero pixel

						next_state  <= three_stripe_013;


--------------------------------------------------------------------------------
-- four valid in one stripe
--------------------------------------------------------------------------------

				elsif( (fsm0_valid_reg = 2 or fsm0_valid_reg = 5) and  fsm1_valid_reg = 2 and  fsm2_valid_reg = 2 and  (fsm3_valid_reg = 2 or fsm3_valid_reg = 5) ) then
				-- all fsms are valid

						next_state  <= four_stripe_0123;
				end if;
				
			else
				next_state  <= reset;
			end if;


			when one_stripe_0  =>	--when loc_compute_done is 1, means we have used the current pixel to calculate, we go to next pixel
									--but this state means in this stripe there is only one pixel valid, so we go to next stripe
				if (loc_compute_done = '1') then
					next_state  <= locator_stripe_switch;
				end if;

			when one_stripe_1  => 
				if (loc_compute_done = '1') then
					next_state  <= locator_stripe_switch;
				end if;

			when one_stripe_2  => 
				if (loc_compute_done = '1') then
					next_state  <= locator_stripe_switch;
				end if;

			when one_stripe_3  => 
				if (loc_compute_done = '1') then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_01  => 		--two pixels valid in current stripe, so we use index to cycle 2 times
				if index < 2 then
					next_state  <= two_stripe_01;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_02  => 
				if index < 2 then
					next_state  <= two_stripe_02;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_03  => 
				if index < 2 then
					next_state  <= two_stripe_03;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_12  => 
				if index < 2 then
					next_state  <= two_stripe_12;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_13  => 
				if index < 2 then
					next_state  <= two_stripe_13;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when two_stripe_23  => 

				if index < 2 then
					next_state  <= two_stripe_23;
				elsif index = 2 then
					next_state  <= locator_stripe_switch;
				end if;

			when three_stripe_012  => 
				if index < 3 then
					next_state  <= three_stripe_012;
				elsif index = 3 then
					next_state  <= locator_stripe_switch;
				end if;

			when three_stripe_013  => 
				if index < 3 then
					next_state  <= three_stripe_013;
				elsif index = 3 then
					next_state  <= locator_stripe_switch;
				end if;

			when three_stripe_123  => 
				if index < 3 then
					next_state  <= three_stripe_123;
				elsif index = 3 then
					next_state  <= locator_stripe_switch;
				end if;

			when three_stripe_023  => 

				if index < 3 then
					next_state  <= three_stripe_023;
				elsif index = 3 then
					next_state  <= locator_stripe_switch;
				end if;

			when four_stripe_0123  => 
				if index < 4 then
					next_state  <= four_stripe_0123;
				elsif index = 4 then
					next_state  <= locator_stripe_switch;
				end if;	



		end case;
	end process future_state_proc;


--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------


	output_network: process(current_state,trigger_index)
	begin
			case current_state is

				when reset => 
					fsm0_data_reg  <= (others  => '0');
					fsm1_data_reg  <= (others  => '0');
					fsm2_data_reg  <= (others  => '0');
					fsm3_data_reg  <= (others  => '0');
					fsm0_valid_reg  <= 0;
					fsm1_valid_reg  <= 0;
					fsm2_valid_reg  <= 0;
					fsm3_valid_reg  <= 0;
					fsm0_x_reg  <= 0;
					fsm0_y_reg  <= 0;
					fsm0_z_reg  <= 0;
					fsm1_x_reg  <= 0;
					fsm1_y_reg  <= 0;
					fsm1_z_reg  <= 0;
					fsm2_x_reg  <= 0;
					fsm2_y_reg  <= 0;
					fsm2_z_reg  <= 0;
					fsm3_x_reg  <= 0;
					fsm3_y_reg  <= 0;
					fsm3_z_reg  <= 0;

					fsm0_data_reg_reg  <= (others  => '0');
					fsm1_data_reg_reg  <= (others  => '0');
					fsm2_data_reg_reg  <= (others  => '0');
					fsm3_data_reg_reg  <= (others  => '0');
					fsm0_valid_reg_reg  <= 0;
					fsm1_valid_reg_reg  <= 0;
					fsm2_valid_reg_reg  <= 0;
					fsm3_valid_reg_reg  <= 0;
					fsm0_x_reg_reg  <= 0;
					fsm0_y_reg_reg  <= 0;
					fsm0_z_reg_reg  <= 0;
					fsm1_x_reg_reg  <= 0;
					fsm1_y_reg_reg  <= 0;
					fsm1_z_reg_reg  <= 0;
					fsm2_x_reg_reg  <= 0;
					fsm2_y_reg_reg  <= 0;
					fsm2_z_reg_reg  <= 0;
					fsm3_x_reg_reg  <= 0;
					fsm3_y_reg_reg  <= 0;
					fsm3_z_reg_reg  <= 0;

					fsm0_data_reg_reg_reg  <= (others  => '0');
					fsm1_data_reg_reg_reg  <= (others  => '0');
					fsm2_data_reg_reg_reg  <= (others  => '0');
					fsm3_data_reg_reg_reg  <= (others  => '0');
					fsm0_valid_reg_reg_reg  <= 0;
					fsm1_valid_reg_reg_reg  <= 0;
					fsm2_valid_reg_reg_reg  <= 0;
					fsm3_valid_reg_reg_reg  <= 0;
					fsm0_x_reg_reg_reg  <= 0;
					fsm0_y_reg_reg_reg  <= 0;
					fsm0_z_reg_reg_reg  <= 0;
					fsm1_x_reg_reg_reg  <= 0;
					fsm1_y_reg_reg_reg  <= 0;
					fsm1_z_reg_reg_reg  <= 0;
					fsm2_x_reg_reg_reg  <= 0;
					fsm2_y_reg_reg_reg  <= 0;
					fsm2_z_reg_reg_reg  <= 0;
					fsm3_x_reg_reg_reg  <= 0;
					fsm3_y_reg_reg_reg  <= 0;
					fsm3_z_reg_reg_reg  <= 0;

					fsm0_data_reg_reg_reg_reg  <= (others  => '0');
					fsm1_data_reg_reg_reg_reg  <= (others  => '0');
					fsm2_data_reg_reg_reg_reg  <= (others  => '0');
					fsm3_data_reg_reg_reg_reg  <= (others  => '0');
					fsm0_valid_reg_reg_reg_reg  <= 0;
					fsm1_valid_reg_reg_reg_reg  <= 0;
					fsm2_valid_reg_reg_reg_reg  <= 0;
					fsm3_valid_reg_reg_reg_reg  <= 0;
					fsm0_x_reg_reg_reg_reg  <= 0;
					fsm0_y_reg_reg_reg_reg  <= 0;
					fsm0_z_reg_reg_reg_reg  <= 0;
					fsm1_x_reg_reg_reg_reg  <= 0;
					fsm1_y_reg_reg_reg_reg  <= 0;
					fsm1_z_reg_reg_reg_reg  <= 0;
					fsm2_x_reg_reg_reg_reg  <= 0;
					fsm2_y_reg_reg_reg_reg  <= 0;
					fsm2_z_reg_reg_reg_reg  <= 0;
					fsm3_x_reg_reg_reg_reg  <= 0;
					fsm3_y_reg_reg_reg_reg  <= 0;
					fsm3_z_reg_reg_reg_reg  <= 0;


					locator_data_out  <= 0;
					pixel_x  <= 0;
					pixel_y  <= 0;
					pixel_z  <= 0;

					stop_IDP  <= '0';
					stripe_index  <= 0;
					index  <= 0;
					start_index  <= 0;
					data_valid  <= '0';
					trigger_mac  <= '0';

				when start => 

					fsm0_data_reg  <= (others  => '0');
					fsm1_data_reg  <= (others  => '0');
					fsm2_data_reg  <= (others  => '0');
					fsm3_data_reg  <= (others  => '0');
					fsm0_valid_reg  <= 0;
					fsm1_valid_reg  <= 0;
					fsm2_valid_reg  <= 0;
					fsm3_valid_reg  <= 0;
					fsm0_x_reg  <= 0;
					fsm0_y_reg  <= 0;
					fsm0_z_reg  <= 0;
					fsm1_x_reg  <= 0;
					fsm1_y_reg  <= 0;
					fsm1_z_reg  <= 0;
					fsm2_x_reg  <= 0;
					fsm2_y_reg  <= 0;
					fsm2_z_reg  <= 0;
					fsm3_x_reg  <= 0;
					fsm3_y_reg  <= 0;
					fsm3_z_reg  <= 0;

					fsm0_data_reg_reg  <= ((others  => '0'));
					fsm1_data_reg_reg  <= ((others  => '0'));
					fsm2_data_reg_reg  <= ((others  => '0'));
					fsm3_data_reg_reg  <= ((others  => '0'));
					fsm0_valid_reg_reg  <= 0;
					fsm1_valid_reg_reg  <= 0;
					fsm2_valid_reg_reg  <= 0;
					fsm3_valid_reg_reg  <= 0;
					fsm0_x_reg_reg  <= 0;
					fsm0_y_reg_reg  <= 0;
					fsm0_z_reg_reg  <= 0;
					fsm1_x_reg_reg  <= 0;
					fsm1_y_reg_reg  <= 0;
					fsm1_z_reg_reg  <= 0;
					fsm2_x_reg_reg  <= 0;
					fsm2_y_reg_reg  <= 0;
					fsm2_z_reg_reg  <= 0;
					fsm3_x_reg_reg  <= 0;
					fsm3_y_reg_reg  <= 0;
					fsm3_z_reg_reg  <= 0;

					fsm0_data_reg_reg_reg_reg  <= ( (others  => '0'));
					fsm1_data_reg_reg_reg_reg  <= ( (others  => '0'));
					fsm2_data_reg_reg_reg_reg  <= ( (others  => '0'));
					fsm3_data_reg_reg_reg_reg  <= ( (others  => '0'));
					fsm0_valid_reg_reg_reg_reg  <= 0;
					fsm1_valid_reg_reg_reg_reg  <= 0;
					fsm2_valid_reg_reg_reg_reg  <= 0;
					fsm3_valid_reg_reg_reg_reg  <= 0;
					fsm0_x_reg_reg_reg_reg  <= 0;
					fsm0_y_reg_reg_reg_reg  <= 0;
					fsm0_z_reg_reg_reg_reg  <= 0;
					fsm1_x_reg_reg_reg_reg  <= 0;
					fsm1_y_reg_reg_reg_reg  <= 0;
					fsm1_z_reg_reg_reg_reg  <= 0;
					fsm2_x_reg_reg_reg_reg  <= 0;
					fsm2_y_reg_reg_reg_reg  <= 0;
					fsm2_z_reg_reg_reg_reg  <= 0;
					fsm3_x_reg_reg_reg_reg  <= 0;
					fsm3_y_reg_reg_reg_reg  <= 0;
					fsm3_z_reg_reg_reg_reg  <= 0;

					index  <= 0;		--index is used to cycle between each state, since one state may corrispond to 1/2/3/4 pixel
					stop_IDP  <= '0';	--to stop IDP when current stripe has valid pixel
					data_valid  <= '0';	--the data out of locator is valid 
					trigger_mac  <= '0';	--used to trigger mac_control when this signal is 1
					stripe_index  <= 0;		--used to count how many stripes we have done, when it's max, we let IDP to work again

					--if ( start_index < 3) then 
					--	start_index  <= start_index + 1;
					--elsif start_index = 3 then
					--	start_index  <= 0;
					--end if;


				when prepare  => 

					index  <= 0;
					data_valid  <= '0';		--since this state doesn't output any valid pixel for mac_control
					trigger_mac  <= '0';	--so these signas are set 0



				when stripe1_store  => 
					--if(falling_edge(locator_clk)) then
					fsm0_data_reg  	<= fsm0_data;
					fsm1_data_reg  	<= fsm1_data;
					fsm2_data_reg  	<= fsm2_data;
					fsm3_data_reg  	<= fsm3_data;
					fsm0_valid_reg  <= fsm0_valid;
					fsm1_valid_reg  <= fsm1_valid;
					fsm2_valid_reg  <= fsm2_valid;
					fsm3_valid_reg  <= fsm3_valid;
					fsm0_x_reg      <= fsm0_x;
					fsm0_y_reg      <= fsm0_y;
					fsm0_z_reg      <= fsm0_z;
					fsm1_x_reg      <= fsm1_x;
					fsm1_y_reg      <= fsm1_y;
					fsm1_z_reg      <= fsm1_z;
					fsm2_x_reg      <= fsm2_x;
					fsm2_y_reg      <= fsm2_y;
					fsm2_z_reg      <= fsm2_z;
					fsm3_x_reg      <= fsm3_x;
					fsm3_y_reg      <= fsm3_y;
					fsm3_z_reg      <= fsm3_z;
					if ( fsm0_valid = 5) then
						fsm0_data_reg  <= (others  => '0');
					end if;

					if ( fsm3_valid = 5) then
						fsm3_data_reg  <= (others  => '0');
					end if;
					--end if;

					if( fsm0_valid = 2 or  fsm1_valid = 2 or  fsm2_valid = 2 or  fsm3_valid = 2 or fsm3_valid = 5 or fsm0_valid = 5 ) then
						stop_IDP  <= '1';		--find valid pixel in current stripe, so stop the IDP 
					else
						stop_IDP  <= '0';
					end if;

					data_valid  <= '0';		--since still not working, so the output data from locator isn't valid
					trigger_mac  <= '0';	--since the output data is invalid, mac_control doesn't need to work


				when stripe2_store  => 
					stop_IDP  <= '1';

					--if(falling_edge(locator_clk)) then
					fsm0_data_reg_reg  	<= fsm0_data;
					fsm1_data_reg_reg  	<= fsm1_data;
					fsm2_data_reg_reg  	<= fsm2_data;
					fsm3_data_reg_reg  	<= fsm3_data;
					fsm0_valid_reg_reg  <= fsm0_valid;
					fsm1_valid_reg_reg  <= fsm1_valid;
					fsm2_valid_reg_reg  <= fsm2_valid;
					fsm3_valid_reg_reg  <= fsm3_valid;
					fsm0_x_reg_reg      <= fsm0_x;
					fsm0_y_reg_reg      <= fsm0_y;
					fsm0_z_reg_reg      <= fsm0_z;
					fsm1_x_reg_reg      <= fsm1_x;
					fsm1_y_reg_reg      <= fsm1_y;
					fsm1_z_reg_reg      <= fsm1_z;
					fsm2_x_reg_reg      <= fsm2_x;
					fsm2_y_reg_reg      <= fsm2_y;
					fsm2_z_reg_reg      <= fsm2_z;
					fsm3_x_reg_reg      <= fsm3_x;
					fsm3_y_reg_reg      <= fsm3_y;
					fsm3_z_reg_reg      <= fsm3_z;

					if ( fsm0_valid = 5) then
						fsm0_data_reg_reg  <= (others  => '0');
					end if;

					if ( fsm3_valid = 5) then
						fsm3_data_reg_reg  <= (others  => '0');
					end if;
					--end if;

					data_valid  <= '0';
					trigger_mac  <= '0';

				when stripe3_store  => 
					stop_IDP  <= '1';

					--if(falling_edge(locator_clk)) then
					fsm0_data_reg_reg_reg  <= fsm0_data;
					fsm1_data_reg_reg_reg  <= fsm1_data;
					fsm2_data_reg_reg_reg  <= fsm2_data;
					fsm3_data_reg_reg_reg  <= fsm3_data;
					fsm0_valid_reg_reg_reg  <= fsm0_valid;
					fsm1_valid_reg_reg_reg  <= fsm1_valid;
					fsm2_valid_reg_reg_reg  <= fsm2_valid;
					fsm3_valid_reg_reg_reg  <= fsm3_valid;
					fsm0_x_reg_reg_reg  <= fsm0_x;
					fsm0_y_reg_reg_reg  <= fsm0_y;
					fsm0_z_reg_reg_reg  <= fsm0_z;
					fsm1_x_reg_reg_reg  <= fsm1_x;
					fsm1_y_reg_reg_reg  <= fsm1_y;
					fsm1_z_reg_reg_reg  <= fsm1_z;
					fsm2_x_reg_reg_reg  <= fsm2_x;
					fsm2_y_reg_reg_reg  <= fsm2_y;
					fsm2_z_reg_reg_reg  <= fsm2_z;
					fsm3_x_reg_reg_reg  <= fsm3_x;
					fsm3_y_reg_reg_reg  <= fsm3_y;
					fsm3_z_reg_reg_reg  <= fsm3_z;

					if ( fsm0_valid = 5) then
						fsm0_data_reg_reg_reg  <= (others  => '0');
					end if;

					if ( fsm3_valid = 5) then
						fsm3_data_reg_reg_reg  <= (others  => '0');
					end if;
					--end if;

					data_valid  <= '0';
					trigger_mac  <= '0';

				when stripe4_store  => 
					stop_IDP  <= '1';

					--if(falling_edge(locator_clk)) then
					fsm0_data_reg_reg_reg_reg  <= fsm0_data;
					fsm1_data_reg_reg_reg_reg  <= fsm1_data;
					fsm2_data_reg_reg_reg_reg  <= fsm2_data;
					fsm3_data_reg_reg_reg_reg  <= fsm3_data;
					fsm0_valid_reg_reg_reg_reg  <= fsm0_valid;
					fsm1_valid_reg_reg_reg_reg  <= fsm1_valid;
					fsm2_valid_reg_reg_reg_reg  <= fsm2_valid;
					fsm3_valid_reg_reg_reg_reg  <= fsm3_valid;
					fsm0_x_reg_reg_reg_reg  <= fsm0_x;
					fsm0_y_reg_reg_reg_reg  <= fsm0_y;
					fsm0_z_reg_reg_reg_reg  <= fsm0_z;
					fsm1_x_reg_reg_reg_reg  <= fsm1_x;
					fsm1_y_reg_reg_reg_reg  <= fsm1_y;
					fsm1_z_reg_reg_reg_reg  <= fsm1_z;
					fsm2_x_reg_reg_reg_reg  <= fsm2_x;
					fsm2_y_reg_reg_reg_reg  <= fsm2_y;
					fsm2_z_reg_reg_reg_reg  <= fsm2_z;
					fsm3_x_reg_reg_reg_reg  <= fsm3_x;
					fsm3_y_reg_reg_reg_reg  <= fsm3_y;
					fsm3_z_reg_reg_reg_reg  <= fsm3_z;

					if ( fsm0_valid = 5) then
						fsm0_data_reg_reg_reg_reg  <= (others  => '0');
					end if;

					if ( fsm3_valid = 5) then
						fsm3_data_reg_reg_reg_reg  <= (others  => '0');
					end if;
					--end if;

					data_valid  <= '0';
					trigger_mac  <= '0';

				when locator_stripe_switch  => 
					stop_IDP  <= '1';

					trigger_mac  <= '0';
					data_valid  <= '0';
					stripe_index  <= stripe_index + 1;

					if stripe_index = 0 then 
						fsm0_data_reg   <= fsm0_data_reg_reg;
						fsm1_data_reg   <= fsm1_data_reg_reg;
						fsm2_data_reg   <= fsm2_data_reg_reg;
						fsm3_data_reg   <= fsm3_data_reg_reg;
						fsm0_valid_reg   <= fsm0_valid_reg_reg;
						fsm1_valid_reg   <= fsm1_valid_reg_reg;
						fsm2_valid_reg   <= fsm2_valid_reg_reg;
						fsm3_valid_reg   <= fsm3_valid_reg_reg;
						fsm0_x_reg   <= fsm0_x_reg_reg;
						fsm0_y_reg   <= fsm0_y_reg_reg;
						fsm0_z_reg   <= fsm0_z_reg_reg;
						fsm1_x_reg   <= fsm1_x_reg_reg;
						fsm1_y_reg   <= fsm1_y_reg_reg;
						fsm1_z_reg   <= fsm1_z_reg_reg;
						fsm2_x_reg   <= fsm2_x_reg_reg;
						fsm2_y_reg   <= fsm2_y_reg_reg;
						fsm2_z_reg   <= fsm2_z_reg_reg;
						fsm3_x_reg   <= fsm3_x_reg_reg;
						fsm3_y_reg   <= fsm3_y_reg_reg;
						fsm3_z_reg   <= fsm3_z_reg_reg;

					elsif stripe_index = 1 then 

						fsm0_data_reg   <= fsm0_data_reg_reg_reg;
						fsm1_data_reg   <= fsm1_data_reg_reg_reg;
						fsm2_data_reg   <= fsm2_data_reg_reg_reg;
						fsm3_data_reg   <= fsm3_data_reg_reg_reg;
						fsm0_valid_reg   <= fsm0_valid_reg_reg_reg;
						fsm1_valid_reg   <= fsm1_valid_reg_reg_reg;
						fsm2_valid_reg   <= fsm2_valid_reg_reg_reg;
						fsm3_valid_reg   <= fsm3_valid_reg_reg_reg;
						fsm0_x_reg   <= fsm0_x_reg_reg_reg;
						fsm0_y_reg   <= fsm0_y_reg_reg_reg;
						fsm0_z_reg   <= fsm0_z_reg_reg_reg;
						fsm1_x_reg   <= fsm1_x_reg_reg_reg;
						fsm1_y_reg   <= fsm1_y_reg_reg_reg;
						fsm1_z_reg   <= fsm1_z_reg_reg_reg;
						fsm2_x_reg   <= fsm2_x_reg_reg_reg;
						fsm2_y_reg   <= fsm2_y_reg_reg_reg;
						fsm2_z_reg   <= fsm2_z_reg_reg_reg;
						fsm3_x_reg   <= fsm3_x_reg_reg_reg;
						fsm3_y_reg   <= fsm3_y_reg_reg_reg;
						fsm3_z_reg   <= fsm3_z_reg_reg_reg;

					elsif stripe_index = 2 then 

						fsm0_data_reg   <= fsm0_data_reg_reg_reg_reg;
						fsm1_data_reg   <= fsm1_data_reg_reg_reg_reg;
						fsm2_data_reg   <= fsm2_data_reg_reg_reg_reg;
						fsm3_data_reg   <= fsm3_data_reg_reg_reg_reg;
						fsm0_valid_reg   <= fsm0_valid_reg_reg_reg_reg;
						fsm1_valid_reg   <= fsm1_valid_reg_reg_reg_reg;
						fsm2_valid_reg   <= fsm2_valid_reg_reg_reg_reg;
						fsm3_valid_reg   <= fsm3_valid_reg_reg_reg_reg;
						fsm0_x_reg   <= fsm0_x_reg_reg_reg_reg;
						fsm0_y_reg   <= fsm0_y_reg_reg_reg_reg;
						fsm0_z_reg   <= fsm0_z_reg_reg_reg_reg;
						fsm1_x_reg   <= fsm1_x_reg_reg_reg_reg;
						fsm1_y_reg   <= fsm1_y_reg_reg_reg_reg;
						fsm1_z_reg   <= fsm1_z_reg_reg_reg_reg;
						fsm2_x_reg   <= fsm2_x_reg_reg_reg_reg;
						fsm2_y_reg   <= fsm2_y_reg_reg_reg_reg;
						fsm2_z_reg   <= fsm2_z_reg_reg_reg_reg;
						fsm3_x_reg   <= fsm3_x_reg_reg_reg_reg;
						fsm3_y_reg   <= fsm3_y_reg_reg_reg_reg;
						fsm3_z_reg   <= fsm3_z_reg_reg_reg_reg;


					end if;

				when one_stripe_0  => 
					stop_IDP  <= '1';

					locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
					pixel_x           <= fsm0_x_reg;
					pixel_y           <= fsm0_y_reg;
					pixel_z           <= fsm0_z_reg;
					data_valid        <= '1';
					trigger_mac  <= '1';

				when one_stripe_1  => 
					stop_IDP  <= '1';

					locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
					data_valid        <= '1';
					pixel_x           <= fsm1_x_reg;
					pixel_y           <= fsm1_y_reg;
					pixel_z           <= fsm1_z_reg;
					data_valid        <= '1';
					trigger_mac  <= '1';


				when one_stripe_2  => 
				  stop_IDP  <= '1';

					locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
					data_valid        <= '1';
					stop_IDP          <= '1';
					pixel_x           <= fsm2_x_reg;
					pixel_y           <= fsm2_y_reg;
					pixel_z           <= fsm2_z_reg;
					data_valid        <= '1';
					trigger_mac  <= '1';


				when one_stripe_3  => 

					locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
					data_valid        <= '1';
					pixel_x           <= fsm3_x_reg;
					pixel_y           <= fsm3_y_reg;
					pixel_z           <= fsm3_z_reg;
					data_valid        <= '1';
					trigger_mac  <= '1';

				
				when two_stripe_01  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						trigger_mac  <= not trigger_mac;
						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '0';

					end if;

				when two_stripe_02  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						trigger_mac  <= not trigger_mac;
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '0';

					end if;

				when two_stripe_03  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

				
					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '0';

					end if;

				when two_stripe_12  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '0';

					end if;

				when two_stripe_13  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '0';

					end if;

				when two_stripe_23  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '0';

					end if;

				when three_stripe_012  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '0';

					elsif index = 2 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '1';

					end if;


				when three_stripe_013  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '0';

					elsif index = 2 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '1';

					end if;


				when three_stripe_023  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '0';

					elsif index = 2 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '1';

					end if;


				when three_stripe_123  => 
					stop_IDP  <= '1';

					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '0';

					elsif index = 2 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '1';

					end if;


				when four_stripe_0123  => 

					stop_IDP  <= '1';
					data_valid        <= '1';
					if (loc_compute_done = '1') then
						index  <= index + 1;
					end if;

					if index = 0 then
						locator_data_out  <= to_integer(unsigned(fsm0_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm0_x_reg;
						pixel_y           <= fsm0_y_reg;
						pixel_z           <= fsm0_z_reg;
						trigger_mac  <= '1';

					elsif index = 1 then
						locator_data_out  <= to_integer(unsigned(fsm1_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm1_x_reg;
						pixel_y           <= fsm1_y_reg;
						pixel_z           <= fsm1_z_reg;
						trigger_mac  <= '0';

					elsif index = 2 then

						locator_data_out  <= to_integer(unsigned(fsm2_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm2_x_reg;
						pixel_y           <= fsm2_y_reg;
						pixel_z           <= fsm2_z_reg;
						trigger_mac  <= '1';

					elsif index = 3 then

						locator_data_out  <= to_integer(unsigned(fsm3_data_reg));
						data_valid        <= '1';
						pixel_x           <= fsm3_x_reg;
						pixel_y           <= fsm3_y_reg;
						pixel_z           <= fsm3_z_reg;
						trigger_mac  <= '0';

						--if stripe_index = 3 then
						--end if;

					end if;

				end case;
				end process;


end architecture;