library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use std.textio.all;
use ieee.std_logic_textio.all;
use work.constants.all;

--------------------------------------------------------------------------------
--  Function:    
--  1.read data from file "data.txt" at every falling edge of the clock.
--  2.evey clock cycle, this unit reads 32bit from the "data.txt".

--  Assumption:    
--  1. the data source is saved data.txt,  already in format SM + NVZL  value
--  2. the file is organized in 16-bit per line

--  Notes:
--  1. Last tested on 11 Feb 2022. It has an individual testbench.                    
--------------------------------------------------------------------------------



entity input_bus is
    port(    
             bus_clk            : in std_logic;
             bus_reset          : in std_logic;
             bus_enable         : in std_logic;

             file_end           : out std_logic;
             bus_index          : out integer;
             dram_data_valid    : out std_logic;   
             dram_data          : OUT std_logic_vector (bus_width-1 downto 0) 
     );
end input_bus;

architecture behavioral of input_bus is
    
    signal dram_out : std_logic_vector (bus_width-1 downto 0);
    signal bus_index_signal : integer;
    signal bus_enable_buffer : std_logic;
    signal file_valid : std_logic;

    begin
    bus_index  <= bus_index_signal;

   
    bus_enable_buffer  <= bus_enable and file_valid;
   

    reading : process (bus_reset, bus_clk)     

      file file_pointer : text;
      variable line_content_0015 : std_logic_vector (SM_segment_bit-1 downto 0);
      variable line_content_1631 : std_logic_vector (SM_segment_bit-1 downto 0);

      variable data  : line;


    begin

    
        if (bus_reset = '1') then
            file_open(file_pointer,"C:/Users/HAO/OneDrive/Desktop/Nullhop/CNN_accelerator/file2.txt",READ_MODE);
            dram_out <= (others => '0');
            dram_data_valid  <= '0';
            file_valid  <= '1';
            bus_index_signal  <= -1;
            file_end         <= '0';
        elsif ( falling_edge(bus_clk)) then
            if (bus_enable_buffer = '1') then
               file_open(file_pointer,"C:/Users/HAO/OneDrive/Desktop/Nullhop/CNN_accelerator/file2.txt",READ_MODE);

               if(not(endfile(file_pointer))) then
                readline(file_pointer, data); 
                read(data, line_content_0015);
        
                readline(file_pointer, data); 
                read(data, line_content_1631);

                dram_data <= line_content_1631 & line_content_0015;
                dram_data_valid  <= '1';
                bus_index_signal  <= bus_index_signal + 1;
                else 
                    --file_close(file_pointer);
                    file_valid  <= '0';
                    file_end    <= '1';
                end if;
            end if;
        end if;

    end process reading;

end behavioral;