LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

entity hammingweight is
	port (
		 hamming_clk   				: in std_logic;
		 hammingweight_reset 		: in std_logic;
		 hammingweight_enable 		: in std_logic;
		 din   						: in std_logic_vector (bus_width -1 downto 0);
		 hammingweight_result_1 	: out integer range 0 to 16;
		 hammingweight_result_2 	: out integer range 0 to 16 
		 );
end hammingweight;


architecture hammingweight_arc of hammingweight is
	

begin


---------------------------------------------------------------------------
-- hammingweight calculation of 32-bit
-- by using the control signal to decide the sum of higher 16-bit or lower 16-bit
---------------------------------------------------------------------------

	process (hammingweight_reset,hamming_clk) is 
		variable sum_hammingweight_1 : integer range 0 to 16;
		variable sum_hammingweight_2 : integer range 0 to 16 ;
	begin
		if (hammingweight_reset = '1') then
				sum_hammingweight_1 := 0;
				sum_hammingweight_2 := 0;

		elsif ( rising_edge(hamming_clk)) then
			if (hammingweight_enable = '1') then 
				sum_hammingweight_1 := 0;
				sum_hammingweight_2 := 0;
				for i in 0 to 15 loop
					sum_hammingweight_1 := sum_hammingweight_1 +  to_integer(unsigned(din(i downto i)));
				end loop;
				for i in 16 to 31 loop
					sum_hammingweight_2 := sum_hammingweight_2 +  to_integer(unsigned(din(i downto i)));
				end loop;
			else 
				sum_hammingweight_1 := 0;
			 	sum_hammingweight_2 := 0; 
			end if;
		end if;
        hammingweight_result_1 <= sum_hammingweight_1; 
        hammingweight_result_2 <= sum_hammingweight_2;
	end process;

---------------------------------------------------------------------------
-- hammingweight calculation of 16-bit
---------------------------------------------------------------------------
	--	process (hammingweight_reset,hamming_clk) is 
	--	variable sum_hammingweight : integer range 0 to SM_segment_bit+1;
	--	begin

	--		if (hammingweight_reset = '1') then
	--			sum_hammingweight := 0;

	--		elsif (rising_edge(hamming_clk) and hammingweight_enable = '1') then
	--			sum_hammingweight := 0;
	--			for i in 0 to SM_segment_bit loop
	--				sum_hammingweight := sum_hammingweight +  to_integer(unsigned(din(i downto i)));
	--			end loop;


	--		end if;
 --               hammingweight_result <= sum_hammingweight; 
	--end process;
	
end hammingweight_arc;