library IEEE;
use IEEE.std_logic_1164.all;
--use work.func_external.all;

package constants is
	constant size_kernel_memory_address : integer := 12;
	constant tracker_sram_size 			: integer := 8;
	constant SM_segment_bit  	  		: integer := 16; 
   	constant SIZE_sram_address    		: integer := 16;   --each memory cell is 16bit, 16bit address, each sram is 128KB  
	constant memory_cell_width		  	: integer := 16;   -- one address in memory corrisponding to 16-bit data
	--constant pixel_memory_bank_number 	: integer := 1;    -- bank number = 4, each bank is 128kb, each bank memory address is 16-bit


	constant data_width					: integer := 16;  --pixel value is represented in fixed-point of 16bit
	constant bus_width					: integer := 32;


	constant SIZE_input_image_horizontal : integer := 8; 
	constant SIZE_input_image_vertical   : integer := 8; 
   	constant SIZE_input_image_channel    : integer := 16; 
   	--constant SIZE_input_image_channel_division    : integer := 1; 



   	--constant SIZE_input_image_horizontal_coordinate    : integer := log2(SIZE_input_image_horizontal); 
   	--constant SIZE_input_image_vertical_coordinate    : integer := log2(SIZE_input_image_vertical); 


   	--constant SIZE_output_image_channel   : integer := 3;  --output image channel == kernel number
   	

   	constant SIZE_kernel_number   	   	 	: integer := 3; 
   	constant kernel_size  		 			: integer := 3;
   	constant kernel_matrix_size			 	: integer := 9;     --SIZE_kernel_vertical * SIZE_kernel_horizontal;

   	--constant tracker_constant : integer := 250;    	-- --for 64*64
  
   	
   	--constant tracker_constant : integer := 26;   	-- --for 8*8
 

   	--constant tracker_constant : integer := 18;    	-- --for 6*6

   	constant tracker_constant : integer := 4 * SIZE_input_image_horizontal - 6 ;


end package;
