LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;

 -------------------------------------------------------------------------------
 -- Function:
 -- 1. SRAM, storing all the data come from input_bus
 -- 2. one read port, one write port
 -- 3. The data is written and read both at the rising edge of the clock

 -- Notes:
 -- 1. The size is set at a large number, but still needs to be corrected
 -- 2. This file has an individual testbench
 -- 3. Last test on 11 Feb 2022.
 -------------------------------------------------------------------------------
 
entity SRAM_tracker is
                          
    Port ( 

        tracker_sram_clk                       : in  STD_LOGIC;
        tracker_sram_reset                     : in  STD_LOGIC;
        start_add0                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add1                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add2                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        start_add3                 : in  unsigned (SIZE_sram_address - 1 downto 0);
        tracker_sram_write_en             : in  integer;
        tracker_sram_read_en              : in  STD_LOGIC;
        tracker_sram_enable               : in  STD_LOGIC;
        fsm_stripe_done             : in STD_LOGIC;
        tracker_sram_read_address0   : in integer;
        tracker_sram_read_address1   : in integer;
        tracker_sram_read_address2   : in integer;
        tracker_sram_read_address3   : in integer;
        --fsm_tracker_address_last_two : in integer;
        --big_stripe_done             : in integer;

        start_add_out0            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out1            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out2            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0);
        start_add_out3            : out STD_LOGIC_VECTOR (SIZE_sram_address - 1 downto 0)
 
    );
end SRAM_tracker;
 
architecture Behavioral of SRAM_tracker is

    --type Memory_Array is array (0 to (2 ** SIZE_sram_address) - 1) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);
    type Memory_Array is array (0 to 9999 ) of STD_LOGIC_VECTOR (memory_cell_width - 1 downto 0);  --for test, since the big array slows down the simulation
    signal big_stripe_done_std : std_logic_vector ( 31 downto 0);
    signal Memory : Memory_Array;
begin


--big_stripe_done_std  <=  std_logic_vector(to_unsigned(big_stripe_done,32));

 
    -- Read process
    process (tracker_sram_clk,tracker_sram_reset)
    begin
        if (tracker_sram_reset = '0') then 
            if rising_edge(tracker_sram_clk) then        
                if tracker_sram_enable = '1' then
                    if ( (tracker_sram_read_en = '1')) then -- Read Memory
                        if (fsm_stripe_done  <= '1') then
                            if ( tracker_sram_read_address0 >= 0  and  tracker_sram_read_address3  <= 250) then


                            ----------------------------------------------------
                            -- for input with 6*6
                            ----------------------------------------------------
                            
                                --if ( big_stripe_done = 0) then

                                    start_add_out0 <= Memory((tracker_sram_read_address0));              
                                    start_add_out1 <= Memory((tracker_sram_read_address1));
                                    start_add_out2 <= Memory((tracker_sram_read_address2));
                                    start_add_out3 <= Memory((tracker_sram_read_address3));

                                --elsif (  big_stripe_done = 1) then  

                                    --start_add_out0 <= Memory((tracker_sram_read_address) - 22);              
                                    --start_add_out1 <= Memory((tracker_sram_read_address) - 21);
                                    --start_add_out2 <= Memory((fsm_tracker_address_last_two));
                                    --start_add_out3 <= Memory((fsm_tracker_address_last_two)+1);



                            ------------------------------------------------
                            -- for input with 64*64
                            ------------------------------------------------
                                

                             --if ( big_stripe_done = 0) then

                             --       start_add_out0 <= Memory((tracker_sram_read_address));              
                             --       start_add_out1 <= Memory((tracker_sram_read_address)+1);
                             --       start_add_out2 <= Memory((tracker_sram_read_address)+2);
                             --       start_add_out3 <= Memory((tracker_sram_read_address)+3);

                             --elsif (  big_stripe_done = 30) then  

                             --       start_add_out0 <= Memory((tracker_sram_read_address/2) );              
                             --       start_add_out1 <= Memory((tracker_sram_read_address/2) + 1);
                             --       start_add_out2 <= Memory((fsm_tracker_address_last_two));
                             --       start_add_out3 <= Memory((fsm_tracker_address_last_two)+1);

                             --elsif ( big_stripe_done_std(0)  <= '0' and big_stripe_done /= 30) then

                             --       start_add_out0 <= Memory((tracker_sram_read_address/2));              
                             --       start_add_out1 <= Memory((tracker_sram_read_address/2)+1);
                             --       start_add_out2 <= Memory((tracker_sram_read_address/2)+2);
                             --       start_add_out3 <= Memory((tracker_sram_read_address/2)+3);

                             --elsif ( big_stripe_done_std(0)  <= '1' and big_stripe_done /= 30) then 

                             --       start_add_out0 <= Memory((tracker_sram_read_address-256)/2 + 2);              
                             --       start_add_out1 <= Memory((tracker_sram_read_address-256)/2 + 3);
                             --       start_add_out2 <= Memory((tracker_sram_read_address-256)/2 + 254);
                             --       start_add_out3 <= Memory((tracker_sram_read_address-256)/2 + 255);

                                --end if;
                            end if;
                        end if;
                    end if;
                end if;      
            end if;
        end if;
    end process;
 
    -- Write process
    process (tracker_sram_clk)
    variable sram_write_address : integer range 0 to 9999;   
                                                              
  
    begin
            if tracker_sram_reset = '1' then
                -- Clear Memory on sram_reset
                Memory <= (others => (others => '0'));
                sram_write_address := 0;   --value needs to be changed if change the number of sram banks
                                               -- if bank number = 4; we use 0 to 65535
                                               -- if bank number = 8; we use 0 to 65535*2
            elsif ((tracker_sram_enable = '1') ) then
                if ((tracker_sram_write_en = 1) ) then
                    if falling_edge(tracker_sram_clk) then
                        if ( (sram_write_address + SIZE_kernel_number + 1) < 270) then  --check if memory will be full
                  
                    -- Store start_add to Current Memory Address
                    Memory(sram_write_address) <= std_logic_vector(start_add0);
                    Memory(sram_write_address+1) <= std_logic_vector(start_add1);
                    Memory(sram_write_address+2) <= std_logic_vector(start_add2);
                    Memory(sram_write_address+3) <= std_logic_vector(start_add3);


                    sram_write_address := sram_write_address + SIZE_kernel_number + 1;

                    else 
                        sram_write_address := 9998;    --in case memory full, circular to the beginning
                    end if;
                end if;
            end if;
        end if; 
        
    end process;
end Behavioral;