LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
--use work.func_external.all;


--------------------------------------------------------------------------------
-- 
--------------------------------------------------------------------------------


entity FSM1 is
	port (
		fsm_clock                   : in std_logic;
		fsm_reset                   : in std_logic;
		fsm_enable					: in std_logic;
		tracker_address             : in std_logic_vector (SIZE_sram_address-1 downto 0);
		memory_segment              : in std_logic_vector (SM_segment_bit-1 downto 0);
		tracker_ready 				: in std_logic;
		all_fsm_done				: in std_logic;
		stop_fsm					: in std_logic;
		--sm_value					: in std_logic_vector (SM_segment_bit-1 downto 0);

		
		sm_or_not					: out integer;   --used as state index    0 means invalid, 1 means sm, 2 means pixel 
		fsm_is_in_halt				: out std_logic;
		--sm_out 						: out std_logic_vector(SM_segment_bit-1 downto 0);
		fsm_output_address          : out std_logic_vector (SIZE_sram_address -1 downto 0);
		fsm_sram_control		    : out std_logic;
		fsm_stripe_done				: out std_logic;
		--big_stripe_done				: out integer;
		fsm_tracker_address1			: out integer;
		--fsm_tracker_address_last_two: out integer;
		pixel_coor_x				: out integer;
		pixel_coor_y 				: out integer;
		pixel_coor_z				: out integer
	);
end FSM1;

architecture FSM1_arc of FSM1 is

	type type_state is (reset,value_true,value_false,new_start,update,prepare_sm,halt,stop);
	signal current_state,next_state,tmp_state : type_state;
	signal current_segment_value : std_logic;
	signal index : integer;
	--signal segment_full : std_logic;
	----------------------------------------------------------------------------
	-- sm_value is used as a register to store the sparsity map
	-- So the register isn't built independently, it's merged in the file "FSM.vhd"
	----------------------------------------------------------------------------
	
	signal sm_value : std_logic_vector (SM_segment_bit-1 downto 0);
	signal fsm_reg_address : std_logic_vector (SIZE_sram_address-1 downto 0);
	signal fsm_tracker_address_buffer : integer;
	signal coor_x,coor_y,coor_z : integer;
	signal update_time_control : integer;
	signal sm_value_index : integer;
	signal sm_or_not_buffer : integer;
	signal pixel_coor_x_rep : integer;
	signal pixel_coor_y_rep : integer;
	signal pixel_coor_z_rep : integer;
	--signal big_stripe_done_index : integer;
	--signal fsm_tracker_address_last_two_buffer, last_two_index : integer;
	signal tracker_address_control : std_logic;
	signal state_update_permission : std_logic;
begin

synchronous_pixel : process(fsm_clock)
begin
	if (fsm_reset = '1') then
		pixel_coor_x_rep  <= 1; 
		pixel_coor_y_rep  <= 0; 
		pixel_coor_z_rep  <= 0; 
		sm_or_not  <= 0;
	elsif (rising_edge (fsm_clock)) then
		pixel_coor_x_rep  <= coor_x;
		pixel_coor_y_rep  <= coor_y;
		pixel_coor_z_rep  <= coor_z;
		sm_or_not  <= sm_or_not_buffer;
	end if;
end process;

	fsm_sram_control  <= fsm_enable;
	fsm_tracker_address1  <= fsm_tracker_address_buffer;


	pixel_coor_x <= pixel_coor_x_rep;
	pixel_coor_y <= pixel_coor_y_rep;
	pixel_coor_z <= pixel_coor_z_rep;

	--big_stripe_done  <= big_stripe_done_index;
	--fsm_tracker_address_last_two  <= fsm_tracker_address_last_two_buffer;

-----------------------------------------------------------------------------
--  next state
-----------------------------------------------------------------------------	

	next_state_proc: process(fsm_clock,fsm_reset)
	begin
			if (fsm_reset = '1') then
				current_state  <= reset;
				index  <= -2;


			elsif (rising_edge(fsm_clock)) then
				if (fsm_enable = '1') then

					if (tracker_ready = '1') then
						current_state  <= next_state;
						
							if( index  <= 16) then 
								index  <= index + 1;
							else 
								index  <= -1;
						end if;
					end	 if;
				else 
					current_state  <= reset;
				end if;
			end if;
	end process next_state_proc;

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------

	future_state_proc: process(current_state,index,memory_segment)
	begin
		
		case current_state is

			when reset => 
				if (fsm_enable = '1') then
					next_state  <= new_start;
				else
					next_state  <= reset;
				end if;

			when new_start  => 
				if (fsm_enable = '1') then
					if( stop_fsm = '0') then 
					next_state  <= prepare_sm;
					else
					next_state  <= halt;
					tmp_state   <= prepare_sm;
					end if;
				else
					next_state  <= reset;
				end if;
			
			when prepare_sm => 
				if (fsm_enable = '1' ) then
					if  coor_x <= 2*SIZE_input_image_horizontal - 7 then 
						if( stop_fsm = '0') then 
					
							if (memory_segment(0) = '1') then
								next_state  <= value_true;
							elsif (memory_segment(0) = '0') then
								next_state  <= value_false;
							end if;
						else
							next_state  <= halt;
							tmp_state	 <= prepare_sm;
						end if;
					else
						next_state <=  stop;
					end if;
				else
					next_state  <= reset;
				end if;

			when stop  => 


			when value_true => 
				if(fsm_enable = '1') then
					if( stop_fsm = '0') then
						if ( sm_value_index < 15 ) then
							if (sm_value( sm_value_index + 1 ) = '1') then
								next_state  <= value_true;
							elsif (sm_value( sm_value_index + 1 ) = '0') then
								next_state  <= value_false;
							end if;
						else
							next_state  <= update;
						end if;
					else
						next_state  <= halt;
						--tmp_state 	 <= value_true;
					end if;
 				else 
 					next_state  <= reset;
 				end if;

 			when value_false =>

				if(fsm_enable = '1') then
					if( stop_fsm = '0') then
						if ( sm_value_index < 15 ) then
							if (sm_value( sm_value_index + 1 ) = '1') then
								next_state  <= value_true;
							elsif (sm_value( sm_value_index + 1 ) = '0') then
								next_state  <= value_false;
							end if;
						else 
							next_state  <=  update;
						end if;
					else
						next_state  <= halt;
						--tmp_state	 <= value_false;
					end if;
				else 
					next_state  <= reset;
				end if;

			when update  => 
				if (fsm_enable = '1') then
					if stop_fsm = '0' then 
						if ( all_fsm_done = '1') then
							next_state  <= new_start;
						else 
							next_state   <= update;
						end if;
					else
						next_state  <= halt;
						tmp_state	 <= update;
					end if;
				else
					next_state  <= reset;
				end if;



			when halt  => 
				if(fsm_enable = '1') then
					if( stop_fsm = '0') then
						if ( sm_value_index < 15 and sm_value_index > 0 ) then
							if (sm_value( sm_value_index  ) = '1') then
								next_state  <= value_true;
							elsif (sm_value( sm_value_index  ) = '0') then
								next_state  <= value_false;
							end if;
						elsif ( sm_value_index = 0 or sm_value_index = 15) then 
							next_state  <=  tmp_state;
						end if;
					else
						next_state  <= halt;
						--tmp_state	 <= value_false;
					end if;
				else 
					next_state  <= reset;
				end if;
				--if (fsm_enable = '1') then
				--	if stop_fsm = '0' then 
				--		next_state  <= tmp_state;
				--	else
				--		next_state  <= halt;
				--	end if;
				--end if;









		end case;
	end process future_state_proc;


--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------

fsm_output_address  <= fsm_reg_address;

	output_network: process(current_state,index)
	begin
			case current_state is

				when reset => 
					fsm_tracker_address_buffer  <= 1;
					--fsm_tracker_address_last_two_buffer  <= 0;
					--last_two_index  <= 0;
					fsm_stripe_done  <= '1';
					sm_or_not_buffer  <= 0;
					fsm_reg_address  <= (others  => '0');
					coor_x  <= 1;
					coor_y  <= -1;
					coor_z  <= 0;
					update_time_control  <= 1;
					sm_value_index  <= 0;
					fsm_is_in_halt  <= '0';
					--big_stripe_done_index  <= 0;
					tracker_address_control  <= '1';
					state_update_permission  <= '1';

				when new_start => 
					state_update_permission  <= '1';
					fsm_reg_address  <=  std_logic_vector(unsigned(tracker_address));						
					fsm_stripe_done  <= '0';
					sm_or_not_buffer  <= 0;	-- 0 means it's invalid value
					update_time_control  <= 1;  --this one is used to control the reading address of tracker increment
												--in case we stay in update for multiple cycles, we do the increment for 1 time.
					sm_value_index  <= 0;
					fsm_is_in_halt  <= '0';

					if (coor_y  < SIZE_input_image_horizontal - 1) then
						coor_y  <= coor_y + 1;
					else
						coor_y  <= 0;
						coor_x  <= coor_x + SIZE_kernel_number + 1; 
					end if;

					if (coor_z  >= SIZE_input_image_channel-1) then 
						coor_z  <= 0;
					end if;

				when prepare_sm  => 
					sm_value  <= memory_segment;
					sm_or_not_buffer  <= 1;  -- 1 means it's sm
					sm_value_index  <= 0;
					fsm_is_in_halt  <= '0';
					state_update_permission  <= '1';



				when value_true => 

						fsm_is_in_halt  <= '0';
						current_segment_value  <= sm_value(sm_value_index);
						sm_or_not_buffer  <= 2;  -- 2 means it's pixel value
						fsm_reg_address  <=  std_logic_vector(unsigned(fsm_reg_address) + 1);
						coor_z  <= sm_value_index ; 
						if ( sm_value_index  <= 14) then
						sm_value_index  <= sm_value_index + 1;
						end if;


				when value_false => 
						current_segment_value  <= sm_value(sm_value_index);
						fsm_is_in_halt  <= '0';
						coor_z  <= sm_value_index ;
						
						--if (sm_value_index = 0) then
							--sm_or_not_buffer  <= 2;    -- 3 means it's a zero pixel 
						--else
						sm_or_not_buffer  <= 3;
						--end if;

						if ( sm_value_index  <= 14) then
							sm_value_index  <= sm_value_index + 1;
						end if;



				when update  => 
					if (state_update_permission = '1') then
						state_update_permission  <= '0';
						if ( pixel_coor_y_rep = SIZE_input_image_horizontal - 1 ) then	
							-- pixel patch switch

							if tracker_address_control = '1' then	-- overlapped condition 
																							
								fsm_tracker_address_buffer  <= fsm_tracker_address_buffer - tracker_constant;
								tracker_address_control  <= '0';

							else 				--normal condition
								fsm_tracker_address_buffer  <= fsm_tracker_address_buffer + 2;
								tracker_address_control  <= '1';

							end if;

						else
							-- pixel stripe switch

							fsm_tracker_address_buffer  <= fsm_tracker_address_buffer + SIZE_kernel_number + 1;


						end if;
					end if;

						fsm_stripe_done  <= '1';
						sm_or_not_buffer  <= 0;
						sm_value_index  <= 0;
						fsm_is_in_halt  <= '0';

				when halt  => 

					fsm_is_in_halt  <= '1';
					sm_or_not_buffer  <= 4;

				when stop  => 
					sm_or_not_buffer  <= 0;


				end case;

	end process output_network;



end FSM1_arc;