#include "Parser.h"
#include <chrono>
using namespace std;


int main(int argc, char* argv[]) {

	Parser* parser = NULL;
	string instructionFile;
	string csvFile;
	string registersFile;
	string traceFile;
	string registersFileFiltered;
	string graphFile;

	while (1) {

		int menuNumber;
		string type;
		string newName;

		cout << endl;
		cout << "***TRACE ANALYSIS TOOL***" << endl << endl;
		cout << "<--MENU-->" << endl;
		cout << "0 --> Create a new instance of trace analysis tool" << endl;
		cout << "1 --> Build instruction map and register map" << endl;
		cout << "2 --> Filter csv file and create trace file" << endl;
		cout << "3 --> Translate trace file and create graph file" << endl;
		cout << "4 --> Make statistics on trace" << endl;
		cout << "5 --> Modify files (remember then to do the right action based on which file/s you have changed)" << endl; 
		cout << "6 --> Exit" << endl;
		cout << "TO SELECT FROM MENU, TYPE THE CORRESPONDING NUMBER" << endl;
		cout << "--> ";

		cin >> 	menuNumber;

		switch (menuNumber) {

			case 0:
				cout << "Insert the name and extension of instruction file --> ";
				cin >> instructionFile;
				cout << "Insert the name and extension of csv file --> ";
				cin >> csvFile;
				cout << "Insert the name and extension of registers file --> ";
				cin >> registersFile;
				cout << "Insert the name and extension of trace file --> ";
				cin >> traceFile;
				cout << "Insert the name and extension of registers file filtered --> ";
				cin >> registersFileFiltered;
				cout << "Insert the name and extension of graph file --> ";
				cin >> graphFile;

				if (parser != NULL)
					delete parser;
				parser = new Parser(instructionFile, csvFile, registersFile, traceFile, registersFileFiltered, graphFile);
				//parser = new Parser("instructionInfo.txt", "traces/trace.csv", "traces/regfile.log", "build/trace.txt", "build/reg.txt");
				break;

			case 1:
				parser -> buildInstructionMap();
				parser -> buildRegisterPosMap();
				break;

			case 2:
				parser -> createTraceFile();
				break;

			case 3:
				parser -> createGraphFile();
				break;

			case 4:
				parser -> makeStats();
				break;

			case 5:
				cout << "Type one of the following name to modify the corresponding file (instr/csv/reg/trace/regFilt/graph) --> ";
				cin >> type;

				cout << "Insert the name of the new file and its extension --> ";
				cin >> newName;

				if (!type.compare("instr"))
					parser -> setInstructionFile(newName);
				else if (!type.compare("csv"))
					parser -> setCsvFile(newName);
				else if (!type.compare("reg"))
					parser -> setRegistersFile(newName);
				else if (!type.compare("trace"))
					parser -> setTraceFile(newName);
				else if (!type.compare("regFilt") || !type.compare("regfilt"))
					parser -> setRegistersFileFiltered(newName);
				else if (!type.compare("graph"))
					parser -> setGraphFile(newName);
				else
					cout << "Not a valid type" << endl;
				break;

			case 6:
				return 0;

			default:
				cout << "Not a valid number" << endl;
		}
	}

	/*

	auto start = chrono::high_resolution_clock::now();

	
	auto end = chrono::high_resolution_clock::now();

	double duration = chrono::duration_cast<chrono::nanoseconds>(end - start).count();

	cout << "Execution time --> " << duration*1e-9 << "s" << endl;
		
	*/

return 0;
}
