#include "Graph.h"
#include "Parser.h"
using namespace std;


int main(int argc, char* argv[]) {

	Parser* parser = NULL;
	Graph* graph = NULL;
	string instructionFile;
	string csvFile;
	string registersFile;
	string traceFile;
	string registersFileFiltered;
	string graphFile;

	while (1) {

		int menuNumber;
		string type;
		string newName;
		auto start = chrono::high_resolution_clock::now();
		auto end = chrono::high_resolution_clock::now();

		cout << endl;
		cout << "***TRACE ANALYSIS TOOL***" << endl << endl;
		cout << "<--MENU-->" << endl;
		cout << "0 --> Create a new instance of trace analysis tool" << endl;
		cout << "1 --> Build instruction map and register map" << endl;
		cout << "2 --> Filter csv file and create trace file" << endl;
		cout << "3 --> Translate trace file and create graph file" << endl;
		cout << "4 --> Build graph" << endl;
		cout << "5 --> Perform analysis on graph" << endl;
		cout << "6 --> Modify files (remember then to do the right action based on which file/s you have changed)" << endl; 
		cout << "7 --> Print graph" << endl;
		cout << "8 --> Make statistics on trace" << endl;
		cout << "9 --> Compute connectivity" << endl;
		cout << "10 --> Generate a trace" << endl;
		cout << "11 --> Exit" << endl;
		cout << "TO SELECT FROM MENU, TYPE THE CORRESPONDING NUMBER" << endl;
		cout << "--> ";

		cin >> 	menuNumber;

		switch (menuNumber) {

			case 0:
				cout << "Insert the name and extension of instruction file --> ";
				cin >> instructionFile;
				cout << "Insert the name and extension of csv file --> ";
				cin >> csvFile;
				cout << "Insert the name and extension of registers file --> ";
				cin >> registersFile;
				cout << "Insert the name and extension of trace file --> ";
				cin >> traceFile;
				cout << "Insert the name and extension of registers file filtered --> ";
				cin >> registersFileFiltered;
				cout << "Insert the name and extension of graph file --> ";
				cin >> graphFile;

				if (parser)
					delete parser;
				if (graph)
					delete graph;

				parser = new Parser(instructionFile, csvFile, registersFile, traceFile, registersFileFiltered, graphFile);
				graph = new Graph(graphFile);
				break;

			case 1:
				if (parser) {
					start = chrono::high_resolution_clock::now();
					parser -> buildInstructionMap();
					parser -> buildRegisterPosMap();
					end = chrono::high_resolution_clock::now();
				}
				break;

			case 2:
				if (parser) {
					start = chrono::high_resolution_clock::now();
					parser -> createTraceFile();
					end = chrono::high_resolution_clock::now();
				}
				break;

			case 3:
				if (parser) {
					start = chrono::high_resolution_clock::now();
					parser -> createGraphFile();
					end = chrono::high_resolution_clock::now();
				}
				break;

			case 4:
				if (graph == NULL) {
					cout << "Insert the name and extension of graph file --> ";
					cin >> graphFile;
					graph = new Graph(graphFile);
				}

				if (graph -> get_graph_file().size() == 0) {
					cout << "Insert the name and extension of graph file --> ";
					cin >> graphFile;
					graph -> set_graph_file(graphFile);
				}

				start = chrono::high_resolution_clock::now();
				graph -> read_graph();
				graph -> build_graph();
				end = chrono::high_resolution_clock::now();

				break;

			case 5:
				if (graph) {
					start = chrono::high_resolution_clock::now();
					graph -> visits(end);
					auto end2 = chrono::high_resolution_clock::now();
					cout << "Execution time of RAW visit --> " << (chrono::duration_cast<chrono::nanoseconds>(end - start).count())*1e-9 << "s" << endl;
					cout << "Execution time branch visit --> " << (chrono::duration_cast<chrono::nanoseconds>(end2 - end).count())*1e-9 << "s" << endl;
				}
				break;

			case 6:
				cout << "Type one of the following name to modify the corresponding file (instr/csv/reg/trace/regFilt/graph) --> ";
				cin >> type;

				cout << "Insert the name of the new file and its extension --> ";
				cin >> newName;

				if (!type.compare("instr") && parser)
					parser -> setInstructionFile(newName);
				else if (!type.compare("csv") && parser)
					parser -> setCsvFile(newName);
				else if (!type.compare("reg") && parser)
					parser -> setRegistersFile(newName);
				else if (!type.compare("trace") && parser)
					parser -> setTraceFile(newName);
				else if ((!type.compare("regFilt") || !type.compare("regfilt")) && parser)
					parser -> setRegistersFileFiltered(newName);
				else if (!type.compare("graph")) {
					if (parser)
						parser -> setGraphFile(newName);
					if (graph)
						graph -> set_graph_file(newName);
				}
				else
					cout << "Not a valid type or parser/graph not built" << endl;
				break;

			case 7:
				if (graph)
					cout << (*graph);
				break;

			case 8:
				if(parser) {
					start = chrono::high_resolution_clock::now();
					parser -> makeStats();
					end = chrono::high_resolution_clock::now();
				}
				break;

			case 9:
				if(graph) {
					start = chrono::high_resolution_clock::now();
					graph -> compute_connectivity();
					end = chrono::high_resolution_clock::now();
				}
				break;

			case 10:
				if (!graph)
					graph = new Graph();
				start = chrono::high_resolution_clock::now();
				graph -> generate_graph();
				end = chrono::high_resolution_clock::now();
				break;

			case 11:
				return 0;

			default:
				cout << "Not a valid number" << endl;
				break;
		}

		if (menuNumber != 0 && menuNumber != 5 && menuNumber != 6 && menuNumber != 7) {
			double duration = chrono::duration_cast<chrono::nanoseconds>(end - start).count();
			cout << "Execution time --> " << duration*1e-9 << "s" << endl;
		}

	}
	return 0;
}

