#ifndef PARSER_H
#define PARSER_H

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <regex>
#include <map>
#include <unordered_set>
#include <algorithm>
#include <sstream>
#include "utils.h"
using namespace std;

struct InstructionInfo {
	vector<string> dst;
	vector<string> src;
	string type;
};

class Parser {

	map<string,InstructionInfo> instructionMap;
	map<string,int> registerFilePosition;
	string instructionFile;
	string csvFile;
	string registersFile;
	string traceFile;
	string registersFileFiltered;
	string graphFile;
	vector<string> addresses;
	unsigned int totalInstructions;

	friend class Graph;

public:
	Parser(string, string, string, string, string, string);
	void buildInstructionMap(void);
	void buildRegisterPosMap(void);
	void buildTypeMap(map<string, vector<string>>&);
	void createAddressesVector(string);
	void createTraceFile(void);
	void createGraphFile(void);
	void makeStats(void);

	//setters
	void setInstructionFile(string);
	void setCsvFile(string);
	void setRegistersFile(string);
	void setTraceFile(string);
	void setRegistersFileFiltered(string);
	void setGraphFile(string);

	//getter
	string getGraphFile(void);
	
	//utils
	string resolveAddress(string, string, vector<string>, bool);

	void printInstructionMap(void);
};

#endif