#ifndef NODE_H
#define NODE_H

#include <string>
#include <vector>
#include <map>
#include "utils.h"
using namespace std;

enum colors {white, green, black, red, orange};

struct Dst {
	colors color;
	vector <unsigned int> RAW;
};

struct Instruction {
	map<string, Dst> destinations;
	vector<string> sources;
};

class Node {

	int node_id;
	Instruction instruction;
	colors nodeColor;
	int branchAlternativeOffset;

	//to let class Graph manipulate private elements of class Node
	friend class Graph;

public:
	//constructors
	Node(void);
	Node(unsigned int, Instruction&);

	//copy constructor
	Node(const Node&);

	//getters
	int get_id(void) const;
	Instruction get_instruction(void) const;
	string get_color(colors) const;
	string get_nodeColor(void) const;
	int get_branchAlt(void) const;
};

#endif