#include <iostream>
#include "Node.h"
using namespace std;

Node::Node() {
	this -> node_id = -1;
	this -> nodeColor = white;
	this -> branchAlternativeOffset = -1;
}

Node::Node(unsigned int node_id, Instruction& instr) {
	this -> node_id = node_id;
	this -> instruction = instr;
	this -> nodeColor = white;
	this -> branchAlternativeOffset = -1;
}

Node::Node(const Node& N) {
	this -> node_id = N.node_id;
	this -> instruction.destinations = N.instruction.destinations;
	this -> instruction.sources = N.instruction.sources;
	this -> nodeColor = N.nodeColor;
	this -> branchAlternativeOffset = N.branchAlternativeOffset;
}

int Node::get_id(void) const {
	return this -> node_id;
}

Instruction Node::get_instruction(void) const {
	return this -> instruction;
}

string Node::get_color(colors color) const {
	string Scolor;
	switch (color) {
		case white:
			Scolor = "white";
			break;
		case green:
			Scolor = "green";
			break;
		case black:
			Scolor = "black";
			break;
		case red:
			Scolor = "red";
			break;
		case orange:
			Scolor = "orange";
			break;
		default:
			break;
	}
	return Scolor;
}

string Node::get_nodeColor(void) const {
	string Scolor;
	switch (this -> nodeColor) {
		case white:
			Scolor = "white";
			break;
		case green:
			Scolor = "green";
			break;
		case black:
			Scolor = "black";
			break;
		case red:
			Scolor = "red";
			break;
		case orange:
			Scolor = "orange";
			break;
		default:
			break;
	}
	return Scolor;
}

int Node::get_branchAlt(void) const {
	return this -> branchAlternativeOffset;
}