#ifndef GRAPH_H
#define GRAPH_H

#include <iostream>
#include <fstream>
#include <regex>
#include <unordered_set>
#include <chrono>
#include "Node.h"
#include "Parser.h"
#include "utils.h"
using namespace std;

class Graph {

	string graphFile;
	unsigned int n_nodes;
	vector<Node> nodes;

	//hidden copy constructor
	Graph(const Graph&);

	//visit
	colors RAW_visit(unsigned int);
	void branch_visit(unsigned int);

public:
	//constructors
	Graph(void);
	Graph(string);

	void read_graph(void);
	void search_target_nodes(string, unsigned int);
	void build_graph(void);

	//visit call interface
	void visits(chrono::high_resolution_clock::time_point&);

	//graph generator
	void generate_graph(void);

	//getters
	string get_graph_file(void);

	//setters
	void set_graph_file(string);

	//connectivity
	void compute_connectivity(void);

	//overloading operator <<
	friend ostream& operator<<(ostream&, const Graph&);

};

#endif