#include "Graph.h"
using namespace std;

Graph::Graph(void) {
	this -> graphFile = "";
	this -> n_nodes = 0;
}

Graph::Graph(string graphFile) {
	this -> graphFile = graphFile;
	this -> n_nodes = 0;
}

void Graph::read_graph(void) { 

	fstream graphFile(this -> graphFile);

	string lineGraph;

	//number of instructions
	getline(graphFile, lineGraph);
		this -> n_nodes = stoi(lineGraph);

	//prepare data structure
	this -> nodes.resize(this -> n_nodes);

	//considering one line at time
	for (int i = 0; i < this -> n_nodes; ++i) {
		if (getline(graphFile, lineGraph)) {
			Node current_node;
			current_node.node_id = i;
			unordered_set<string> srcDuplicates;
			string app;
			int pos;

			pos = lineGraph.find_first_of(" ");

			if (regex_match(lineGraph.substr(0, pos), regex("\\d+"))) {
				current_node.nodeColor = orange;
				current_node.branchAlternativeOffset = stoi(lineGraph.substr(0, pos));
				lineGraph.erase(0, (pos+1));
			}

			else if (!lineGraph.substr(0, pos).compare("DANGER")) {
				current_node.nodeColor = black;
				current_node.branchAlternativeOffset = -1;
				lineGraph.erase(0, (pos+1));
			}

			else
				current_node.branchAlternativeOffset = 0;

			//set destinations and sources
			if (lineGraph[0] != 'D')
				cerr << "Error in graph file. D not found. " << i+1 << endl;

			lineGraph.erase(0,2);

			//destinations
			while ((pos = lineGraph.find_first_of(" ")) < lineGraph.find_first_of(",")) {
				app = lineGraph.substr(0, pos);
				if (regex_match(app, regex("-?[0-9]+")) || regex_match(app, regex("0x.+"))) {
					lineGraph.erase(0, (pos+1));
					continue;
				}

				if (regex_match(app, regex("mem\\(\\d+\\)\\d*"))) {
					app.erase(0, 4);
					long long int begin = stoll(app.substr(0, app.find_first_of(")")));
					app.erase(0, (app.find_first_of(")")+1));
					int qty;
					if (!app.compare(""))
						qty = 1;
					else
						qty = stoi(app.substr(0, pos));
					for (int i = 0; i < qty; ++i) {
						Dst dst;
						dst.color = white;
						current_node.instruction.destinations.emplace(to_string(begin+i), dst);
					}
					lineGraph.erase(0, (pos+1));
					continue;
				}

				Dst dst;
				dst.color = white;
				current_node.instruction.destinations.emplace(uppercase(app), dst);
				lineGraph.erase(0, (pos+1));
			}

			if (lineGraph[2] != 'S')
				cerr << "Error in graph file. S not found." << endl;

			lineGraph.erase(0,4);

			//sources
			while ((pos = lineGraph.find_first_of(" ")) != string::npos) {
				app = lineGraph.substr(0, pos);
				if (regex_match(app, regex("-?[0-9]+")) || regex_match(app, regex("0x.+")) || (srcDuplicates.find(app) != srcDuplicates.end())) {
					lineGraph.erase(0, (pos+1));
					continue;
				}

				if (regex_match(app, regex("mem\\(\\d+\\)\\d*"))) {
					app.erase(0, 4);
					long long int begin = stoll(app.substr(0, app.find_first_of(")")));
					app.erase(0, (app.find_first_of(")")+1));
					int qty;
					if (!app.compare(""))
						qty = 1;
					else
						qty = stoi(app.substr(0, pos));
					for (int i = 0; i < qty; ++i) 
						current_node.instruction.sources.emplace_back(to_string(begin+i));
					lineGraph.erase(0, (pos+1));
					continue;
				}

				srcDuplicates.emplace(app);
				current_node.instruction.sources.emplace_back(uppercase(app));
				lineGraph.erase(0, (pos+1));
			}

			this -> nodes[i] = current_node;
			srcDuplicates.clear();
		}
	}

	graphFile.close();
}


void Graph::search_target_nodes(string target, unsigned int index) {

	if ((index+1) == this -> n_nodes)
		this -> nodes[index].instruction.destinations[target].color = green;

	for (unsigned int i = (index+1); i < this -> n_nodes; ++i) {

		//set RAW
		for (unsigned int j = 0; j < this -> nodes[i].instruction.sources.size(); ++j) {
			if (!(this -> nodes[i].instruction.sources[j].compare(target))) {
				this -> nodes[index].instruction.destinations[target].RAW.emplace_back(i);
				break;
			}
		}

		//target destination is written
		if (this -> nodes[i].instruction.destinations.find(target) != this -> nodes[i].instruction.destinations.end()) {
			//target destination never read
			if (this -> nodes[index].instruction.destinations[target].RAW.size() == 0)
				this -> nodes[index].instruction.destinations[target].color = black;
			//target destination read
			else
				this -> nodes[index].instruction.destinations[target].color = red;

			return;
		}

		if (i == ((this -> n_nodes)-1) && this -> nodes[index].instruction.destinations[target].color == white)
			this -> nodes[index].instruction.destinations[target].color = green;
	}
}

void Graph::build_graph(void) {
	for (unsigned int i = 0; i < this -> n_nodes; ++i) {
		for (map<string, Dst>::iterator it = this -> nodes[i].instruction.destinations.begin(); it != this -> nodes[i].instruction.destinations.end(); ++it) {
			string target = it -> first;
			this -> search_target_nodes(target, i);
		}
	}
}


colors Graph::RAW_visit(unsigned int current_node_index) {

	colors return_color = black;
	for (map<string, Dst>::iterator it = this -> nodes[current_node_index].instruction.destinations.begin(); it != this -> nodes[current_node_index].instruction.destinations.end(); ++it) {

		//green
		if (it -> second.color == green) {
			return_color = green;
			this -> nodes[current_node_index].nodeColor = (this -> nodes[current_node_index].nodeColor == orange) ? orange : green;
		}

		//black 
		else if (it -> second.color == black) {
			return_color = (return_color == black)?black : green;
			if (this -> nodes[current_node_index].nodeColor != orange)
				this -> nodes[current_node_index].nodeColor = (this -> nodes[current_node_index].nodeColor != green)? black : green;
		}

		//orange
		else if (it -> second.color == orange)
			cerr << "Error: destination has orange color" << endl;

		//red
		else if (it -> second.color == red) {
			for (unsigned int i = 0; i < it -> second.RAW.size(); ++i) {
				switch (this -> RAW_visit(it -> second.RAW[i])) {
					case green:
						it -> second.color = green;
						this -> nodes[current_node_index].nodeColor = green;
						return_color = green;
						break;

					case black:
						it -> second.color = (it -> second.color != green)?black : green;
						this -> nodes[current_node_index].nodeColor = (this -> nodes[current_node_index].nodeColor != green)? black : green;
						return_color = (return_color == black)?black : green;
						break;

					case white:
						cerr << "Error: white color returned. Nodes should only return black or green color" << endl;
						break;

					default:
						break;
				}
			}
		}

		else
			cerr << "Error: invalid color RAW_visit" << endl;
	}

	if (this -> nodes[current_node_index].nodeColor == white)
		this -> nodes[current_node_index].nodeColor = green;

	return return_color;
}

void Graph::branch_visit(unsigned int current_node_index) {
	for (int i = (current_node_index+1); i < (current_node_index + this -> nodes[current_node_index].branchAlternativeOffset+1); ++i) {

		if (this -> nodes[i].nodeColor == green) {
			this -> nodes[current_node_index].nodeColor = green;
			return;
		}

		else if (this -> nodes[i].nodeColor == black)
			this -> nodes[current_node_index].nodeColor = (this -> nodes[current_node_index].nodeColor != green)? black : green;

		else if (this -> nodes[i].nodeColor == white || this -> nodes[i].nodeColor == orange) {
			cerr << "Error: " << this -> nodes[i].get_nodeColor() << " color returned during branch visit" << endl;
			return;
		}
	}
}

void Graph::visits(chrono::high_resolution_clock::time_point& end) {
	for (unsigned int i = 0; i < this -> n_nodes; ++i) 
		this -> RAW_visit(i);

	end = chrono::high_resolution_clock::now();

	for (int i = (this -> n_nodes-1); i >= 0; --i) {
		if (this -> nodes[i].nodeColor == orange && this -> nodes[i].branchAlternativeOffset > 0)
			this -> branch_visit(i);
	}
}

string Graph::get_graph_file(void) {
	return this -> graphFile;
}

void Graph::set_graph_file(string graphFile) {
	this -> graphFile = graphFile;
}

void Graph::generate_graph(void) {

	string regLineBegin = "R0=00000000 R1=00000000 R2=00000000 R3=00000000 R4=00000000 R5=00000000 R6=00000000 R7=00000000 R8=00000000 R9=00000000 R10=00000000 R11=00000000 R12=00000000 R13=00000000 R14=00000000 R15=00000000 R16=00000000 R17=00000000 R18=00000000 R19=00000000 R20=00000000 R21=00000000 R22=00000000 R23=00000000 R24=00000000 R25=00000000 R26=00000000 R27=00000000 R28=00000000 R29=00000000 R30=00000000 R31=00000000 PP=00000000 IP=00000000 XER=00000000 CR=00000000 CTR=00000000 LR=00000000 SPRG0=00000000 SPRG1=00000000 SPRG2=00000000 SPRG3=00000000 USPRG0=00000000 SRR0=00000000 SRR1=00000000 CSRR0=00000000 CSRR1=00000000 MCSRR0=00000000 MCSRR1=00000000 MCSR=00000000 MCAR=00000000 IVPR=00000000 ESR=00000000 DEAR=00000000 ECR=00000000 MSR=00000000 PVR=00000000 PID=00000000 PIR=00000000";
	char yn;
	vector<string> typeName = {"Aritmetic", "Branch", "Branch Conditional", "Load", "Store", "Special"};
	vector<string> typeSymbol = {"A", "B", "BC", "L", "S", "SP"}; 
	int numInstruction;
	int percentageType[6];
	vector<int> numOfType (6,0);
	int numRegister;
	Parser* parser;
	string instructionFile;
	string traceFileName;
	string regFileName;
	string graphFile;
	long long int IP = 0;
	int memorySize = 256;

	cout << "Insert the name and extension of instruction file --> ";
	cin >> instructionFile;
	cout << "Insert the name and extension of the trace file to be generated --> ";
	cin >> traceFileName;
	cout << "Insert the name and extension of the reg file to be generated --> ";
	cin >> regFileName;
	cout << "Insert the name and extension of the graph file to be generated --> ";
	cin >> graphFile;

	parser = new Parser(instructionFile, "", regFileName, traceFileName, regFileName, graphFile);
	parser -> buildInstructionMap();

	cout << "Do you want to generate the graph automatically?(y/n) -->  ";
	cin >> yn;

	if (yn != 'n' && yn != 'y') {
		cerr << "Error: option not valid" << endl;
		return;
	}

	cout << "Insert the number of instruction --> ";
	cin >> numInstruction;
	parser -> totalInstructions = numInstruction;

	map<string, vector<string>> mapType;

	fstream traceFile(traceFileName, ios::out);
	fstream regFile(regFileName, ios::out);
	regFile << regLineBegin << endl;
	parser -> buildRegisterPosMap();
	regFile.close();
	regFile.open(regFileName, ios::out);


	switch (yn) {

		case 'y':

			parser -> buildTypeMap(mapType);

			cout << "Insert the number of general purpose registers --> ";
			cin >> numRegister;

			cout << "Insert the percentage for every type of instruction in the set {Arithmetic,Branch,Branch Conditional,Load,Store,Special}" << endl;
			
			for (int i = 0; i < 6; ++i) {
				cout << "Insert the percentage of " << typeName[i] << " instructions --> ";
				cin >> percentageType[i];
				numOfType[i] = (percentageType[i]*numInstruction)/100;
			}

			for (int i = 0; i < numInstruction; ++i) {
				int random = rand() % typeSymbol.size();
				string type = typeSymbol[random];

				if (numOfType[random] == 0) {
					numOfType.erase(numOfType.begin()+random);
					typeSymbol.erase(typeSymbol.begin()+random);
					i--;
					continue;
				}

				else if (numOfType[random] > 0) {
					numOfType[random]--;

					int randomInstr = rand() % mapType[type].size();
					string instructionName = mapType[type][randomInstr];

				

					string regLine = "R0=00000000 R1=00000000 R2=00000000 R3=00000000 R4=00000000 R5=00000000 R6=00000000 R7=00000000 R8=00000000 R9=00000000 R10=00000000 R11=00000000 R12=00000000 R13=00000000 R14=00000000 R15=00000000 R16=00000000 R17=00000000 R18=00000000 R19=00000000 R20=00000000 R21=00000000 R22=00000000 R23=00000000 R24=00000000 R25=00000000 R26=00000000 R27=00000000 R28=00000000 R29=00000000 R30=00000000 R31=00000000 PP=00000000 IP=00000000 XER=00000000 CR=00000000 CTR=00000000 LR=00000000 SPRG0=00000000 SPRG1=00000000 SPRG2=00000000 SPRG3=00000000 USPRG0=00000000 SRR0=00000000 SRR1=00000000 CSRR0=00000000 CSRR1=00000000 MCSRR0=00000000 MCSRR1=00000000 MCSR=00000000 MCAR=00000000 IVPR=00000000 ESR=00000000 DEAR=00000000 ECR=00000000 MSR=00000000 PVR=00000000 PID=00000000 PIR=00000000";

					string IPstring;
					stringstream ss;
					ss << hex << IP;
					for (int j = ss.str().size(); j < 8; ++j)
						IPstring += "0";
					IPstring += ss.str();
					IPstring = uppercase(IPstring);
					parser -> addresses.emplace_back(IPstring);

					InstructionInfo instructionInfo;
					instructionInfo = parser -> instructionMap[instructionName];

					traceFile << instructionName;

					if (!instructionInfo.type.compare("L") || !instructionInfo.type.compare("S")) {
						stringstream ss2;
						stringstream ss3;
						int operand = rand() % numRegister;
						string operandStr = "r";
						operandStr += to_string(operand);
						int regValue = rand() % memorySize;
						string regValueStr;
						ss2 << hex << regValue;
						for (int j = ss2.str().size(); j < 8; ++j)
							regValueStr += "0";
						regValueStr += uppercase(ss2.str());
						regLine.replace(parser -> registerFilePosition[uppercase(operandStr)], 8, regValueStr);							
						traceFile << " " << operandStr << ",";
						operandStr.clear();
						regValueStr.clear();


						int result = (rand() % 500) * (((rand() % 1) == 0)?-1:1);
						traceFile << result << "(";
						operand = rand() %numRegister;
						operandStr = "r";
						operandStr += to_string(operand);
						regValue = rand() % memorySize;
						ss3 << hex << regValue;
						for (int j = ss3.str().size(); j < 8; ++j)
							regValueStr += "0";
						regValueStr += uppercase(ss3.str());
						regLine.replace(parser -> registerFilePosition[uppercase(operandStr)], 8, regValueStr);	
						traceFile << operandStr << ")" << endl;
					}

					else {

						int numOperands = 0;
						for (int j = 1; j <= stoi(instructionInfo.dst[0]); ++j) {
							if (regex_match(instructionInfo.dst[j], regex("[0-9]+"))) {
								if (stoi(instructionInfo.dst[j]) > numOperands)
									numOperands = stoi(instructionInfo.dst[j]);
							}
						}

						for (int j = 1; j <= stoi(instructionInfo.src[0]); ++j) {
							if (regex_match(instructionInfo.src[j], regex("[0-9]+"))) {
								if (stoi(instructionInfo.src[j]) > numOperands)
									numOperands = stoi(instructionInfo.src[j]);
							}
						}

						if (!instructionInfo.type.compare("BC")) {
							for (int j = 0; j < numOperands; ++j) {
								if (!j)
									traceFile << " ";

								stringstream ss2;
								long long int operand = rand() % (numInstruction + i + 1);
								ss2 << hex << operand;
								string address;
								for (int z = ss2.str().size(); z < 6; ++z)
									address += "0";
								address += uppercase(ss2.str());
								traceFile << "0x" << address;
								if (j != (numOperands-1))
									traceFile << ",";
							}
							traceFile << endl;
						}

						else {	
							for (int j = 0; j < numOperands; ++j) {
								int operand = rand() % numRegister;
								if (!j)
									traceFile << " ";

								traceFile << "r" << operand;

								if (j != (numOperands-1))
									traceFile << ",";
							}
							traceFile << endl;
						}
					}

					regLine.replace(parser -> registerFilePosition["PP"], 8, IPstring);
					regLine.replace(parser -> registerFilePosition["IP"], 8, IPstring);

					if (instructionName[0] == 's')
						IP += 2;
					else
						IP += 4;

					regFile << regLine << endl;
				}
			}
			break;

		case 'n':
			cout << "Sorry, this functionality has not been already implemented" << endl;
			break;

		default:
			break;
	}


	parser -> createGraphFile();
}


void Graph::compute_connectivity(void) {
	vector<double> percentageNodeGreen;
	double totalBC = 0;
	double partialBC = 0;
	map<string, RegisterCount> counterGreenRegister;

	fstream connectivityFile ("connectivity.txt", ios::out);
	for (int i = 0; i < this -> n_nodes; ++i) {
		int partial = 0;

		if (this -> nodes[i].branchAlternativeOffset == -1 || this -> nodes[i].branchAlternativeOffset > 0) {
			connectivityFile << "Instruction number " << (i+1) << " is a conditional branch --> " << this -> nodes[i].get_nodeColor() << endl;
			if (this -> nodes[i].nodeColor == green) {
				percentageNodeGreen.emplace_back(100);
				partialBC++;
			}
			totalBC++;
			continue;
		}

		if (this -> nodes[i].instruction.destinations.size() == 0 && this -> nodes[i].branchAlternativeOffset == 0) {
			connectivityFile << "Instruction number " << (i+1) << " does not have destinations. nodeColor --> " << this -> nodes[i].get_nodeColor() << endl;
			if (this -> nodes[i].nodeColor == green)
				percentageNodeGreen.emplace_back(100);
			continue;
		}

		for (map<string, Dst>::iterator it = this -> nodes[i].instruction.destinations.begin(); it != this -> nodes[i].instruction.destinations.end(); ++it) {
			if (it -> second.color == green)
				partial += 1;
			if (counterGreenRegister.find(it -> first) != counterGreenRegister.end()) {
				counterGreenRegister[it -> first].greenCount = (it -> second.color == green) ? counterGreenRegister[it -> first].greenCount+1 : counterGreenRegister[it -> first].greenCount;
				counterGreenRegister[it -> first].count++;
			}
			else {
				RegisterCount regCount;
				if (it -> second.color == green)
					regCount = {1,1};
				else if (it -> second.color == black)
					regCount = {0,1};
				counterGreenRegister.emplace(it -> first, regCount);
			}
		}

		percentageNodeGreen.emplace_back((partial/this -> nodes[i].instruction.destinations.size())*100);
		connectivityFile << "Instruction number " << (i+1) << " has " << (partial/this -> nodes[i].instruction.destinations.size())*100 << "% " << "of green nodes" << endl;
	}

	double partial = 0;
	for (int i = 0; i < percentageNodeGreen.size(); ++i) {
		partial += percentageNodeGreen[i];
	}

	double averageNodeGreen = partial/percentageNodeGreen.size();
	connectivityFile << "Average percentage of green destinations for each node --> " << averageNodeGreen << "%" << endl;
	cout << "Average percentage of green destinations for each node --> " << averageNodeGreen << "%" << endl;

	if (totalBC != 0) {
		double percentageBC = (partialBC/totalBC)*100;
		connectivityFile << "percentage of green conditional branches --> " << percentageBC << "%" << endl;
		cout << "percentage of green conditional branches --> " << percentageBC << "%" << endl;
	}

	for (map<string, RegisterCount>::iterator it = counterGreenRegister.begin(); it != counterGreenRegister.end(); ++it)
		connectivityFile << "Register " << it -> first << " has " << ((it -> second.greenCount)/(it -> second.count))*100 << "%" << " of green destination inside the trace" << endl;
}


ostream& operator<<(ostream& os, const Graph& G) {
	for (unsigned int i = 0; i < G.n_nodes; ++i) {
		Instruction ins = G.nodes[i].get_instruction();
		os << endl;
		os << "Instruction number (" << G.nodes[i].get_id() << "):" << endl; 

		os << "Node Color --> " << G.nodes[i].get_nodeColor() << endl;

		os << "Branch Alternative Offset --> " << G.nodes[i].get_branchAlt() << endl;

		os << "Destination/s -->" << endl;
		for (map<string, Dst>::iterator it = ins.destinations.begin(); it != ins.destinations.end(); ++it) {
			os << "Name --> " << it -> first << " Color --> " << G.nodes[i].get_color(it -> second.color) << " RAW --> ";
			for (unsigned int j = 0; j < it -> second.RAW.size(); ++j)
				os << it -> second.RAW[j] << " ";
			os << endl;
		}


		os << "Sources -->" << endl;
		for (unsigned int j = 0; j < ins.sources.size(); ++j) 
			os << "Name --> " << ins.sources[j] << endl;

		os << endl << "**********************************" << endl;
	}
	return os;
}