function [ M, G, CDq ] = ur5_matrices( q, dq )
%Returns the dynamics of the UR5 manipulator

q1 = q(1);
q2 = q(2);
q3 = q(3);
q4 = q(4);
q5 = q(5);
q6 = q(6);

theta_1 = q1;
theta_2 = q2;
theta_3 = q3;
theta_4 = q4;
theta_5 = q5;
theta_6 = q6;

dq1 = dq(1);
dq2 = dq(2);
dq3 = dq(3);
dq4 = dq(4);
dq5 = dq(5);
dq6 = dq(6);

m11 = 0.007460552829*sin(q3 + q4 + q5) - 0.0002254000336*cos(2.0*q2 + 2.0*q3 + 2.0*q4 + 2.0*q5) + 0.007460552829*sin(2.0*q2 + q3 + q4 + q5) + 0.7014282607*cos(2.0*q2 + q3) - 0.007460552829*sin(q3 + q4 - 1.0*q5) - 0.007460552829*sin(2.0*q2 + q3 + q4 - 1.0*q5) - 0.05830173968*sin(2.0*q2 + 2.0*q3 + q4) + 0.001614617887*cos(2.0*q2 + 2.0*q3 + 2.0*q4 + q5) + 0.8028639871*cos(2.0*q2) + 0.0004508000672*cos(2.0*q5) - 0.001614617887*cos(2.0*q2 + 2.0*q3 + 2.0*q4 - 1.0*q5) - 0.0002254000336*cos(2.0*q2 + 2.0*q3 + 2.0*q4 - 2.0*q5) - 0.063140533*sin(q3 + q4) + 0.006888811168*sin(q4 + q5) - 0.063140533*sin(2.0*q2 + q3 + q4) - 0.006888811168*sin(q4 - 1.0*q5) + 0.7014282607*cos(q3) + 0.00765364949*cos(q5) + 0.006888811168*sin(2.0*q2 + 2.0*q3 + q4 + q5) + 0.3129702942*cos(2.0*q2 + 2.0*q3) - 0.05830173968*sin(q4) - 0.005743907935*cos(2.0*q2 + 2.0*q3 + 2.0*q4) - 0.006888811168*sin(2.0*q2 + 2.0*q3 + q4 - 1.0*q5) + 1.28924888;
m12 = 0.01615783641*cos(q2 + q3 + q4) + 0.006888811168*sin(q2 + q3 + q5) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.006888811168*sin(q2 + q3 - 1.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5) + 0.1313181732*sin(q2 + q3) + 0.007460552829*sin(q2 + q5) + 0.007460552829*sin(q2 - 1.0*q5) + 0.348513447*sin(q2);
m13 = 0.01615783641*cos(q2 + q3 + q4) + 0.006888811168*sin(q2 + q3 + q5) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.006888811168*sin(q2 + q3 - 1.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5) + 0.1313181732*sin(q2 + q3);
m14 = 0.01615783641*cos(q2 + q3 + q4) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5);
m15 = 0.006888811168*sin(q2 + q3 - 1.0*q5) - 0.006888811168*sin(q2 + q3 + q5) - 0.002840479501*cos(q2 + q3 + q4) - 0.0002987944852*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.00352803026*cos(q2 + q3 + q4 + q5) - 0.007460552829*sin(q2 + q5) + 0.007460552829*sin(q2 - 1.0*q5);
m16 = -0.000138534912*sin(q2 + q3 + q4)*sin(q5);
m21 = 0.01615783641*cos(q2 + q3 + q4) + 0.006888811168*sin(q2 + q3 + q5) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.006888811168*sin(q2 + q3 - 1.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5) + 0.1313181732*sin(q2 + q3) + 0.007460552829*sin(q2 + q5) + 0.007460552829*sin(q2 - 1.0*q5) + 0.348513447*sin(q2);
m22 = 1.402856521*cos(q3) - 0.1166034794*sin(q4) - 0.126281066*cos(q3)*sin(q4) - 0.126281066*cos(q4)*sin(q3) + 0.02755524467*cos(q4)*sin(q5) - 0.001803200269*cos(q5)^2 - 0.02984221131*sin(q3)*sin(q4)*sin(q5) + 0.02984221131*cos(q3)*cos(q4)*sin(q5) + 2.263576776;
m23 = 0.7014282607*cos(q3) - 0.1166034794*sin(q4) - 0.063140533*cos(q3)*sin(q4) - 0.063140533*cos(q4)*sin(q3) + 0.02755524467*cos(q4)*sin(q5) - 0.001803200269*cos(q5)^2 - 0.01492110566*sin(q3)*sin(q4)*sin(q5) + 0.01492110566*cos(q3)*cos(q4)*sin(q5) + 0.644094696;
m24 = 0.01377762234*cos(q4)*sin(q5) - 0.063140533*cos(q3)*sin(q4) - 0.063140533*cos(q4)*sin(q3) - 0.05830173968*sin(q4) - 0.001803200269*cos(q5)^2 - 0.01492110566*sin(q3)*sin(q4)*sin(q5) + 0.01492110566*cos(q3)*cos(q4)*sin(q5) + 0.01612863983;
m25 = cos(q5)*(0.01492110566*sin(q3 + q4) + 0.01377762234*sin(q4) - 0.003229235775);
m26 = 0.000138534912*cos(q5);
m31 = 0.01615783641*cos(q2 + q3 + q4) + 0.006888811168*sin(q2 + q3 + q5) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.006888811168*sin(q2 + q3 - 1.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5) + 0.1313181732*sin(q2 + q3);
m32 = 0.7014282607*cos(q3) - 0.1166034794*sin(q4) - 0.063140533*cos(q3)*sin(q4) - 0.063140533*cos(q4)*sin(q3) + 0.02755524467*cos(q4)*sin(q5) - 0.001803200269*cos(q5)^2 - 0.01492110566*sin(q3)*sin(q4)*sin(q5) + 0.01492110566*cos(q3)*cos(q4)*sin(q5) + 0.644094696;
m33 = 0.02755524467*cos(q4)*sin(q5) - 0.1166034794*sin(q4) - 0.001803200269*cos(q5)^2 + 0.644094696;
m34 = 0.01377762234*cos(q4)*sin(q5) - 0.05830173968*sin(q4) - 0.001803200269*cos(q5)^2 + 0.01612863983;
m35 = cos(q5)*(0.01377762234*sin(q4) - 0.003229235775);
m36 = 0.000138534912*cos(q5);
m41 = 0.01615783641*cos(q2 + q3 + q4) - 0.0004508000672*cos(q2 + q3 + q4 + 2.0*q5) + 0.00352803026*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) + 0.0004508000672*cos(2.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.0002987944852*cos(q2 + q3 + q4 + q5);
m42 = 0.01377762234*cos(q4)*sin(q5) - 0.063140533*cos(q3)*sin(q4) - 0.063140533*cos(q4)*sin(q3) - 0.05830173968*sin(q4) - 0.001803200269*cos(q5)^2 - 0.01492110566*sin(q3)*sin(q4)*sin(q5) + 0.01492110566*cos(q3)*cos(q4)*sin(q5) + 0.01612863983;
m43 = 0.01377762234*cos(q4)*sin(q5) - 0.05830173968*sin(q4) - 0.001803200269*cos(q5)^2 + 0.01612863983;
m44 = 0.001803200269*sin(q5)^2 + 0.01432543956;
m45 = -0.003229235775*cos(q5);
m46 = 0.000138534912*cos(q5);
m51 = 0.006888811168*sin(q2 + q3 - 1.0*q5) - 0.006888811168*sin(q2 + q3 + q5) - 0.002840479501*cos(q2 + q3 + q4) - 0.0002987944852*cos(1.0*q5 - 1.0*q3 - 1.0*q4 - 1.0*q2) - 0.00352803026*cos(q2 + q3 + q4 + q5) - 0.007460552829*sin(q2 + q5) + 0.007460552829*sin(q2 - 1.0*q5);
m52 = cos(q5)*(0.01492110566*sin(q3 + q4) + 0.01377762234*sin(q4) - 0.003229235775);
m53 = cos(q5)*(0.01377762234*sin(q4) - 0.003229235775);
m54 = -0.003229235775*cos(q5);
m55 = 0.002840479501;
m56 = 0;
m61 = -0.000138534912*sin(q2 + q3 + q4)*sin(q5);
m62 = 0.000138534912*cos(q5);
m63 = 0.000138534912*cos(q5);
m64 = 0.000138534912*cos(q5);
m65 = 0;
m66 = 0.000138534912;
 
c11 = 0.003730276414374999842393787474748*dq5*cos(theta_3 + theta_4 - 1.0*theta_5) - 0.003730276414374999842393787474748*dq4*cos(theta_3 + theta_4 - 1.0*theta_5) - 0.003730276414374999842393787474748*dq3*cos(theta_3 + theta_4 - 1.0*theta_5) - 0.007460552828749999684787574949496*dq2*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.003730276414374999842393787474748*dq3*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.003730276414374999842393787474748*dq4*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.003730276414374999842393787474748*dq5*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.70142826072499997458464804367395*dq2*sin(2.0*theta_2 + theta_3) - 0.35071413036249998729232402183698*dq3*sin(2.0*theta_2 + theta_3) - 0.058301739682800002295692820553086*dq2*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.058301739682800002295692820553086*dq3*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.029150869841400001147846410276543*dq4*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.0016146178873499999507912239238294*dq2*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.0016146178873499999507912239238294*dq3*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.0016146178873499999507912239238294*dq4*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.00080730894367499997539561196191471*dq5*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.80286398712999995641581563177169*dq2*sin(2.0*theta_2) - 0.00045080006724164167807369918428151*dq5*sin(2.0*theta_5) + 0.0016146178873499999507912239238294*dq2*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq2*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.0016146178873499999507912239238294*dq3*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq3*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.0016146178873499999507912239238294*dq4*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq4*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) - 0.00080730894367499997539561196191471*dq5*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) - 0.00022540003362082083903684959214075*dq5*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) - 0.031570266499999999343373247029376*dq3*cos(theta_3 + theta_4) - 0.031570266499999999343373247029376*dq4*cos(theta_3 + theta_4) + 0.0034444055842192500098419838394648*dq4*cos(theta_4 + theta_5) + 0.0034444055842192500098419838394648*dq5*cos(theta_4 + theta_5) - 0.063140532999999998686746494058752*dq2*cos(2.0*theta_2 + theta_3 + theta_4) - 0.031570266499999999343373247029376*dq3*cos(2.0*theta_2 + theta_3 + theta_4) - 0.031570266499999999343373247029376*dq4*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0034444055842192500098419838394648*dq4*cos(theta_4 - 1.0*theta_5) + 0.0034444055842192500098419838394648*dq5*cos(theta_4 - 1.0*theta_5) + 0.0068888111684385000196839676789296*dq2*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq3*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.0034444055842192500098419838394648*dq4*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.0034444055842192500098419838394648*dq5*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) - 0.029150869841400001147846410276543*dq4*cos(theta_4) - 0.35071413036249998729232402183698*dq3*sin(theta_3) - 0.0038268247450999998658660583572555*dq5*sin(theta_5) - 0.0068888111684385000196839676789296*dq2*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.0068888111684385000196839676789296*dq3*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.0034444055842192500098419838394648*dq4*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.0034444055842192500098419838394648*dq5*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.31297029415553834219565487728687*dq2*sin(2.0*theta_2 + 2.0*theta_3) - 0.31297029415553834219565487728687*dq3*sin(2.0*theta_2 + 2.0*theta_3) + 0.0057439079350250247732456720939354*dq2*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.0057439079350250247732456720939354*dq3*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.0057439079350250247732456720939354*dq4*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.003730276414374999842393787474748*dq3*cos(theta_3 + theta_4 + theta_5) + 0.003730276414374999842393787474748*dq4*cos(theta_3 + theta_4 + theta_5) + 0.003730276414374999842393787474748*dq5*cos(theta_3 + theta_4 + theta_5) + 0.00022540003362082083903684959214075*dq2*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.00022540003362082083903684959214075*dq3*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.00022540003362082083903684959214075*dq4*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.00022540003362082083903684959214075*dq5*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.007460552828749999684787574949496*dq2*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) + 0.003730276414374999842393787474748*dq3*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) + 0.003730276414374999842393787474748*dq4*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) + 0.003730276414374999842393787474748*dq5*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5);
c12 = 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 - 1.0*theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.007460552828749999684787574949496*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.70142826072499997458464804367395*dq1*sin(2.0*theta_2 + theta_3) - 0.058301739682800002295692820553086*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.80286398712999995641581563177169*dq1*sin(2.0*theta_2) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.00029879448519999998214180525479833*dq2*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq3*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq4*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.13131817324289998816233548950549*dq2*cos(theta_2 + theta_3) + 0.13131817324289998816233548950549*dq3*cos(theta_2 + theta_3) + 0.007460552828749999684787574949496*dq2*cos(theta_2 + theta_5) - 0.063140532999999998686746494058752*dq1*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0035280302599000001005646875995581*dq2*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq3*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq4*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.007460552828749999684787574949496*dq2*cos(theta_2 - 1.0*theta_5) + 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.34851344699999997622796854557237*dq2*cos(theta_2) - 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.31297029415553834219565487728687*dq1*sin(2.0*theta_2 + 2.0*theta_3) + 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 + theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 + theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.016157836411999998427191371774825*dq2*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq3*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq4*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) + 0.007460552828749999684787574949496*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) - 0.000069267455999999993313670509920144*dq6*cos(theta_2 + theta_3 + theta_4)*sin(theta_5);
c13 = 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 - 1.0*theta_5) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - 1.0*theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.35071413036249998729232402183698*dq1*sin(2.0*theta_2 + theta_3) - 0.058301739682800002295692820553086*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.00029879448519999998214180525479833*dq2*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq3*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq4*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.13131817324289998816233548950549*dq2*cos(theta_2 + theta_3) - 0.031570266499999999343373247029376*dq1*cos(theta_3 + theta_4) + 0.13131817324289998816233548950549*dq3*cos(theta_2 + theta_3) - 0.031570266499999999343373247029376*dq1*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0035280302599000001005646875995581*dq2*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq3*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq4*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) - 0.35071413036249998729232402183698*dq1*sin(theta_3) - 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.31297029415553834219565487728687*dq1*sin(2.0*theta_2 + 2.0*theta_3) + 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 + theta_5) + 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 + theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.016157836411999998427191371774825*dq2*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq3*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq4*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) - 0.000069267455999999993313670509920144*dq6*cos(theta_2 + theta_3 + theta_4)*sin(theta_5);
c14 = 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.029150869841400001147846410276543*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.00029879448519999998214180525479833*dq2*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq3*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.00029879448519999998214180525479833*dq4*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) - 0.031570266499999999343373247029376*dq1*cos(theta_3 + theta_4) + 0.0034444055842192500098419838394648*dq1*cos(theta_4 + theta_5) - 0.031570266499999999343373247029376*dq1*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0035280302599000001005646875995581*dq2*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq3*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0035280302599000001005646875995581*dq4*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq5*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.0034444055842192500098419838394648*dq1*cos(theta_4 - 1.0*theta_5) + 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) - 0.029150869841400001147846410276543*dq1*cos(theta_4) - 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.016157836411999998427191371774825*dq2*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq3*sin(theta_2 + theta_3 + theta_4) - 0.016157836411999998427191371774825*dq4*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) - 0.000069267455999999993313670509920144*dq6*cos(theta_2 + theta_3 + theta_4)*sin(theta_5);
c15 = 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - 1.0*theta_5) - 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00080730894367499997539561196191471*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5) - 0.00080730894367499997539561196191471*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq2*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0019134123725500000413532464271782*dq3*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0019134123725500000413532464271782*dq4*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0035280302599000001005646875995581*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0034444055842192500098419838394648*dq1*cos(theta_4 + theta_5) - 0.007460552828749999684787574949496*dq5*cos(theta_2 + theta_5) + 0.0019134123725500000413532464271782*dq2*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq3*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) + 0.0019134123725500000413532464271782*dq4*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.00029879448519999998214180525479833*dq5*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.0034444055842192500098419838394648*dq1*cos(theta_4 - 1.0*theta_5) - 0.007460552828749999684787574949496*dq5*cos(theta_2 - 1.0*theta_5) + 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) - 0.0038268247450999998658660583572555*dq1*sin(theta_5) + 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) - 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 + theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.0014202397504832835976179561399135*dq2*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq3*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq4*sin(theta_2 + theta_3 + theta_4) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) - 0.000069267455999999993313670509920144*dq6*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
c16 = - 0.000069267455999999993313670509920144*dq2*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq3*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq4*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq5*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
c21 = 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 - 1.0*theta_5) + 0.007460552828749999684787574949496*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.70142826072499997458464804367395*dq1*sin(2.0*theta_2 + theta_3) + 0.058301739682800002295692820553086*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) + 0.80286398712999995641581563177169*dq1*sin(2.0*theta_2) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) - 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.007460552828749999684787574949496*dq5*cos(theta_2 + theta_5) + 0.063140532999999998686746494058752*dq1*cos(2.0*theta_2 + theta_3 + theta_4) + 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 - 2.0*theta_5) - 0.007460552828749999684787574949496*dq5*cos(theta_2 - 1.0*theta_5) - 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.31297029415553834219565487728687*dq1*sin(2.0*theta_2 + 2.0*theta_3) - 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) + 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 + theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) - 0.007460552828749999684787574949496*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5) + 0.000069267455999999993313670509920144*dq6*cos(theta_2 + theta_3 + theta_4)*sin(theta_5);
c22 = 0.5*dq5*cos(theta_5)*(0.029842211314999998739150299797984*cos(theta_3 + theta_4) + 0.027555244673754000078735870715718*cos(theta_4) + 0.0036064005379331338582704624684538*sin(theta_5)) - 1.0*dq4*(0.058301739682800002295692820553086*cos(theta_4) + 0.063140532999999998686746494058752*cos(theta_3)*cos(theta_4) - 0.063140532999999998686746494058752*sin(theta_3)*sin(theta_4) + 0.013777622336877000039367935357859*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*cos(theta_3)*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*cos(theta_4)*sin(theta_3)*sin(theta_5)) - 1.0*dq3*(0.70142826072499997458464804367395*sin(theta_3) + 0.063140532999999998686746494058752*cos(theta_3)*cos(theta_4) - 0.063140532999999998686746494058752*sin(theta_3)*sin(theta_4) + 0.014921105657499999369575149898992*cos(theta_3)*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*cos(theta_4)*sin(theta_3)*sin(theta_5));
c23 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) - 0.007460552828749999684787574949496*dq2*cos(theta_3 + theta_4 - theta_5) - 0.007460552828749999684787574949496*dq3*cos(theta_3 + theta_4 - theta_5) - 0.007460552828749999684787574949496*dq4*cos(theta_3 + theta_4 - theta_5) + 0.007460552828749999684787574949496*dq5*cos(theta_3 + theta_4 - theta_5) - 0.063140532999999998686746494058752*dq2*cos(theta_3 + theta_4) - 0.063140532999999998686746494058752*dq3*cos(theta_3 + theta_4) - 0.063140532999999998686746494058752*dq4*cos(theta_3 + theta_4) + 0.0068888111684385000196839676789296*dq4*cos(theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq5*cos(theta_4 + theta_5) - 0.058301739682800002295692820553086*dq4*cos(theta_4) - 0.70142826072499997458464804367395*dq2*sin(theta_3) - 0.70142826072499997458464804367395*dq3*sin(theta_3) - 0.0068888111684385000196839676789296*dq4*cos(theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq5*cos(theta_4 - theta_5) + 0.007460552828749999684787574949496*dq2*cos(theta_3 + theta_4 + theta_5) + 0.007460552828749999684787574949496*dq3*cos(theta_3 + theta_4 + theta_5) + 0.007460552828749999684787574949496*dq4*cos(theta_3 + theta_4 + theta_5) + 0.007460552828749999684787574949496*dq5*cos(theta_3 + theta_4 + theta_5);
c24 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) - 0.058301739682800002295692820553086*dq2*cos(theta_4) - 0.058301739682800002295692820553086*dq3*cos(theta_4) - 0.058301739682800002295692820553086*dq4*cos(theta_4) - 0.063140532999999998686746494058752*dq2*cos(theta_3)*cos(theta_4) - 0.063140532999999998686746494058752*dq3*cos(theta_3)*cos(theta_4) - 0.063140532999999998686746494058752*dq4*cos(theta_3)*cos(theta_4) + 0.013777622336877000039367935357859*dq5*cos(theta_4)*cos(theta_5) + 0.063140532999999998686746494058752*dq2*sin(theta_3)*sin(theta_4) + 0.063140532999999998686746494058752*dq3*sin(theta_3)*sin(theta_4) - 0.013777622336877000039367935357859*dq2*sin(theta_4)*sin(theta_5) + 0.063140532999999998686746494058752*dq4*sin(theta_3)*sin(theta_4) - 0.013777622336877000039367935357859*dq3*sin(theta_4)*sin(theta_5) - 0.013777622336877000039367935357859*dq4*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*dq5*cos(theta_3)*cos(theta_4)*cos(theta_5) - 0.014921105657499999369575149898992*dq2*cos(theta_3)*sin(theta_4)*sin(theta_5) - 0.014921105657499999369575149898992*dq2*cos(theta_4)*sin(theta_3)*sin(theta_5) - 0.014921105657499999369575149898992*dq3*cos(theta_3)*sin(theta_4)*sin(theta_5) - 0.014921105657499999369575149898992*dq3*cos(theta_4)*sin(theta_3)*sin(theta_5) - 0.014921105657499999369575149898992*dq4*cos(theta_3)*sin(theta_4)*sin(theta_5) - 0.014921105657499999369575149898992*dq4*cos(theta_4)*sin(theta_3)*sin(theta_5) - 0.014921105657499999369575149898992*dq5*cos(theta_5)*sin(theta_3)*sin(theta_4);
c25 = 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) + 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) + 0.00090160013448328346456761561711346*dq4*sin(2*theta_5) - 0.0068888111684385000196839676789296*dq1*cos(1.0*theta_5 - theta_3 - theta_2) - 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - 1.0*theta_3 - 1.0*theta_4 - 1.0*theta_2) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.007460552828749999684787574949496*dq1*cos(theta_2 + theta_5) - 0.007460552828749999684787574949496*dq1*cos(theta_2 - 1.0*theta_5) + 0.0032292357746999999015824478476588*dq5*sin(theta_5) - 0.000069267455999999993313670509920144*dq6*sin(theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_5 - 1.0*theta_3 - 1.0*theta_4 - 1.0*theta_2) + 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 + theta_5) - 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4) + 0.014921105657499999369575149898992*dq2*cos(theta_3 + theta_4)*cos(theta_5) + 0.014921105657499999369575149898992*dq3*cos(theta_3 + theta_4)*cos(theta_5) + 0.014921105657499999369575149898992*dq4*cos(theta_3 + theta_4)*cos(theta_5) - 0.014921105657499999369575149898992*dq5*sin(theta_3 + theta_4)*sin(theta_5) + 0.013777622336877000039367935357859*dq2*cos(theta_4)*cos(theta_5) + 0.013777622336877000039367935357859*dq3*cos(theta_4)*cos(theta_5) + 0.013777622336877000039367935357859*dq4*cos(theta_4)*cos(theta_5) - 0.013777622336877000039367935357859*dq5*sin(theta_4)*sin(theta_5);
c26 = -sin(theta_5)*(0.000069267455999999993313670509920144*dq5 - 0.000069267455999999993313670509920144*dq1*cos(theta_2 + theta_3 + theta_4));
c31 = 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.35071413036249998729232402183698*dq1*sin(2.0*theta_2 + theta_3) + 0.058301739682800002295692820553086*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.00045080006724164167807369918428151*dq5*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) + 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 - theta_5) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) - 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.031570266499999999343373247029376*dq1*cos(theta_3 + theta_4) + 0.031570266499999999343373247029376*dq1*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.35071413036249998729232402183698*dq1*sin(theta_3) + 0.0068888111684385000196839676789296*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.31297029415553834219565487728687*dq1*sin(2.0*theta_2 + 2.0*theta_3) + 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq5*cos(theta_2 + theta_3 + theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5);
c32 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) - 0.058301739682800002295692820553086*dq4*cos(theta_4) + 0.70142826072499997458464804367395*dq2*sin(theta_3) + 0.063140532999999998686746494058752*dq2*cos(theta_3)*cos(theta_4) + 0.013777622336877000039367935357859*dq5*cos(theta_4)*cos(theta_5) - 0.063140532999999998686746494058752*dq2*sin(theta_3)*sin(theta_4) - 0.013777622336877000039367935357859*dq4*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*dq2*cos(theta_3)*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*dq2*cos(theta_4)*sin(theta_3)*sin(theta_5) - 1.0e-35*dq4*cos(theta_3)*sin(theta_4)*sin(theta_5) - 1.0e-35*dq4*cos(theta_4)*sin(theta_3)*sin(theta_5);
c33 = 0.5*dq5*cos(theta_5)*(0.027555244673754000078735870715718*cos(theta_4) + 0.0036064005379331338582704624684538*sin(theta_5)) - 1.0*dq4*(0.058301739682800002295692820553086*cos(theta_4) + 0.013777622336877000039367935357859*sin(theta_4)*sin(theta_5));
c34 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) - 0.058301739682800002295692820553086*dq2*cos(theta_4) - 0.058301739682800002295692820553086*dq3*cos(theta_4) - 0.058301739682800002295692820553086*dq4*cos(theta_4) + 0.013777622336877000039367935357859*dq5*cos(theta_4)*cos(theta_5) - 0.013777622336877000039367935357859*dq2*sin(theta_4)*sin(theta_5) - 0.013777622336877000039367935357859*dq3*sin(theta_4)*sin(theta_5) - 0.013777622336877000039367935357859*dq4*sin(theta_4)*sin(theta_5) - 1.0e-35*dq2*cos(theta_3)*sin(theta_4)*sin(theta_5) - 1.0e-35*dq2*cos(theta_4)*sin(theta_3)*sin(theta_5);
c35 = 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) + 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) + 0.00090160013448328346456761561711346*dq4*sin(2*theta_5) - 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) - 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 - theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq2*cos(theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq4*cos(theta_4 + theta_5) + 0.0068888111684385000196839676789296*dq5*cos(theta_4 + theta_5) + 0.0032292357746999999015824478476588*dq5*sin(theta_5) - 0.000069267455999999993313670509920144*dq6*sin(theta_5) + 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq2*cos(theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq4*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq5*cos(theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 + theta_5) - 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4);
c36 = -sin(theta_5)*(0.000069267455999999993313670509920144*dq5 - 0.000069267455999999993313670509920144*dq1*cos(theta_2 + theta_3 + theta_4));
c41 = 0.00045080006724164167807369918428151*dq5*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) + 0.029150869841400001147846410276543*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4) - 0.00045080006724164167807369918428151*dq5*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) + 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - theta_5) + 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) - 0.0016146178873499999507912239238294*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) - 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.031570266499999999343373247029376*dq1*cos(theta_3 + theta_4) - 0.0034444055842192500098419838394648*dq1*cos(theta_4 + theta_5) + 0.031570266499999999343373247029376*dq1*cos(2.0*theta_2 + theta_3 + theta_4) - 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.029150869841400001147846410276543*dq1*cos(theta_4) + 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) + 0.0016146178873500000592114411723799*dq5*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.0034444055842192500098419838394648*dq1*cos(theta_4 - theta_5) - 0.0057439079350250247732456720939354*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) - 0.0014202397504832835976179561399135*dq5*sin(theta_2 + theta_3 + theta_4) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5);
c42 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) + 0.058301739682800002295692820553086*dq2*cos(theta_4) + 0.058301739682800002295692820553086*dq3*cos(theta_4) + 0.063140532999999998686746494058752*dq2*cos(theta_3)*cos(theta_4) - 0.063140532999999998686746494058752*dq2*sin(theta_3)*sin(theta_4) + 0.013777622336877000039367935357859*dq2*sin(theta_4)*sin(theta_5) + 0.013777622336877000039367935357859*dq3*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*dq2*cos(theta_3)*sin(theta_4)*sin(theta_5) + 0.014921105657499999369575149898992*dq2*cos(theta_4)*sin(theta_3)*sin(theta_5) + 1.0e-35*dq3*cos(theta_3)*sin(theta_4)*sin(theta_5) + 1.0e-35*dq3*cos(theta_4)*sin(theta_3)*sin(theta_5);
c43 = 0.00090160013448328346456761561711346*dq5*sin(2*theta_5) + 0.058301739682800002295692820553086*dq2*cos(theta_4) + 0.058301739682800002295692820553086*dq3*cos(theta_4) + 0.013777622336877000039367935357859*dq2*sin(theta_4)*sin(theta_5) + 0.013777622336877000039367935357859*dq3*sin(theta_4)*sin(theta_5) + 1.0e-35*dq2*cos(theta_3)*sin(theta_4)*sin(theta_5) + 1.0e-35*dq2*cos(theta_4)*sin(theta_3)*sin(theta_5);
c44 = 0.00090160013448328346456761561711346*dq5*sin(2.0*theta_5);
c45 = 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) + 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) - 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) + 0.00090160013448328346456761561711346*dq4*sin(2.0*theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0032292357746999999015824478476588*dq5*sin(theta_5) - 0.000069267455999999993313670509920144*dq6*sin(theta_5) + 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4);
c46 = -sin(theta_5)*(0.000069267455999999993313670509920144*dq5 - 0.000069267455999999993313670509920144*dq1*cos(theta_2 + theta_3 + theta_4));
c51 = 0.00045080006724164167807369918428151*dq2*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) - 0.00045080006724164167807369918428151*dq3*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.00045080006724164167807369918428151*dq4*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 - 1.0*theta_5) - 0.00045080006724164167807369918428151*dq2*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.00045080006724164167807369918428151*dq3*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) + 0.00045080006724164167807369918428151*dq4*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) + 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 - theta_5) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 - theta_5) + 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 - theta_5) + 0.00080730894367499997539561196191471*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + theta_5) + 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5) + 0.00080730894367499997539561196191471*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 1.0*theta_5) + 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 - 2.0*theta_5) + 0.0016146178873500000592114411723799*dq2*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0016146178873500000592114411723799*dq3*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.0016146178873500000592114411723799*dq4*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 + theta_5) - 0.007460552828749999684787574949496*dq2*cos(theta_2 + theta_5) - 0.0034444055842192500098419838394648*dq1*cos(theta_4 + theta_5) - 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 + theta_5) + 0.0038268247450999998658660583572555*dq1*sin(theta_5) - 0.0034444055842192500098419838394648*dq1*cos(2.0*theta_2 + 2.0*theta_3 + theta_4 - 1.0*theta_5) - 0.0016146178873500000592114411723799*dq2*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.0016146178873500000592114411723799*dq3*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.0016146178873500000592114411723799*dq4*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.000034633727999999996656835254960072*dq6*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.007460552828749999684787574949496*dq2*cos(theta_2 - theta_5) - 0.0034444055842192500098419838394648*dq1*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq2*cos(theta_2 + theta_3 + theta_5) - 0.003730276414374999842393787474748*dq1*cos(theta_3 + theta_4 + theta_5) - 0.0068888111684385000196839676789296*dq3*cos(theta_2 + theta_3 + theta_5) - 0.00022540003362082083903684959214075*dq1*sin(2.0*theta_2 + 2.0*theta_3 + 2.0*theta_4 + 2.0*theta_5) + 0.0014202397504832835976179561399135*dq2*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq3*sin(theta_2 + theta_3 + theta_4) + 0.0014202397504832835976179561399135*dq4*sin(theta_2 + theta_3 + theta_4) - 0.003730276414374999842393787474748*dq1*cos(2.0*theta_2 + theta_3 + theta_4 + theta_5);
c52 = 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) - 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) - 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) - 0.00090160013448328346456761561711346*dq4*sin(2*theta_5) - 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 - theta_5) - 0.007460552828749999684787574949496*dq2*cos(theta_3 + theta_4 - theta_5) + 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) - 0.007460552828749999684787574949496*dq1*cos(theta_2 + theta_5) - 0.0068888111684385000196839676789296*dq2*cos(theta_4 + theta_5) - 0.0068888111684385000196839676789296*dq3*cos(theta_4 + theta_5) + 0.000069267455999999993313670509920144*dq6*sin(theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.007460552828749999684787574949496*dq1*cos(theta_2 - theta_5) - 0.0068888111684385000196839676789296*dq2*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq3*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 + theta_5) - 0.007460552828749999684787574949496*dq2*cos(theta_3 + theta_4 + theta_5) + 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4);
c53 = 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) - 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) - 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) - 0.00090160013448328346456761561711346*dq4*sin(2*theta_5) - 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) + 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 - theta_5) + 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) - 0.0068888111684385000196839676789296*dq2*cos(theta_4 + theta_5) - 0.0068888111684385000196839676789296*dq3*cos(theta_4 + theta_5) + 0.000069267455999999993313670509920144*dq6*sin(theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq2*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq3*cos(theta_4 - theta_5) - 0.0068888111684385000196839676789296*dq1*cos(theta_2 + theta_3 + theta_5) + 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4);
c54 = 0.00045080006724164167807369918428151*dq1*sin(2.0*theta_5 - theta_3 - theta_4 - theta_2) - 0.00090160013448328346456761561711346*dq2*sin(2*theta_5) - 0.00090160013448328346456761561711346*dq3*sin(2*theta_5) - 0.00045080006724164167807369918428151*dq1*sin(theta_2 + theta_3 + theta_4 + 2.0*theta_5) - 0.00090160013448328346456761561711346*dq4*sin(2.0*theta_5) + 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 + theta_5) + 0.000069267455999999993313670509920144*dq6*sin(theta_5) - 0.0016146178873500000592114411723799*dq1*sin(theta_2 + theta_3 + theta_4 - theta_5) + 0.0014202397504832835976179561399135*dq1*sin(theta_2 + theta_3 + theta_4);
c55 = 0.0;
c56 = 0.000069267455999999993313670509920144*dq2*sin(theta_5) + 0.000069267455999999993313670509920144*dq3*sin(theta_5) + 0.000069267455999999993313670509920144*dq4*sin(theta_5) + 0.000069267455999999993313670509920144*dq1*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
c61 = - 0.000069267455999999993313670509920144*dq2*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq3*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq4*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 0.000069267455999999993313670509920144*dq5*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
c62 = -0.000069267455999999993313670509920144*sin(theta_5)*(dq5 + dq1*cos(theta_2 + theta_3 + theta_4));
c63 = -0.000069267455999999993313670509920144*sin(theta_5)*(dq5 + dq1*cos(theta_2 + theta_3 + theta_4));
c64 = -0.000069267455999999993313670509920144*sin(theta_5)*(dq5 + dq1*cos(theta_2 + theta_3 + theta_4));
c65 = - 0.000069267455999999993313670509920144*dq2*sin(theta_5) - 0.000069267455999999993313670509920144*dq3*sin(theta_5) - 0.000069267455999999993313670509920144*dq4*sin(theta_5) - 0.000069267455999999993313670509920144*dq1*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
c66 = 0.0;


g1 = 0;
g2 = 16.190614676970001173383906234449*cos(theta_2 + theta_3) + 37.929334950000004100800765627355*cos(theta_2) - 1.0*sin(theta_5)*(0.34441422705900004257173474542242*sin(theta_2 + theta_3)*sin(theta_4) - 0.34441422705900004257173474542242*cos(theta_2 + theta_3)*cos(theta_4)) - 1.4574320676000001723027210687178*cos(theta_2 + theta_3)*sin(theta_4) - 1.4574320676000001723027210687178*sin(theta_2 + theta_3)*cos(theta_4);
g3 = 16.190614676970001173383906234449*cos(theta_2 + theta_3) - 1.4574320676000001723027210687178*sin(theta_2 + theta_3 + theta_4) + 0.34441422705900004257173474542242*cos(theta_2 + theta_3 + theta_4)*sin(theta_5);
g4 = 0.34441422705900004257173474542242*cos(theta_2 + theta_3 + theta_4)*sin(theta_5) - 1.4574320676000001723027210687178*sin(theta_2 + theta_3 + theta_4);
g5 = 0.34441422705900004257173474542242*sin(theta_2 + theta_3 + theta_4)*cos(theta_5);
g6 = 0;


%Setting up the matrices
M = [m11 m12 m13 m14 m15 m16;m21 m22 m23 m24 m25 m26;m31 m32 m33 m34 m35 m36;m41 m42 m43 m44 m45 m46;m51 m52 m53 m54 m55 m56;m61 m62 m63 m64 m65 m66];
C = [c11 c12 c13 c14 c15 c16;c21 c22 c23 c24 c25 c26;c31 c32 c33 c34 c35 c36;c41 c42 c43 c44 c45 c46;c51 c52 c53 c54 c55 c56;c61 c62 c63 c64 c65 c66];
G = [g1;g2;g3;g4;g5;g6]*(-1);

CDq = C*dq;


