% Questa funzione calcola le derivate aerodinamiche in assi body 
% INPUT:
%
% DATI(struct) dalla function INPUT_DATI
% ALA_3D(struct) dalla function ala_3D
% DOWNWASH(struct) dalla function downwash
% EQUILIBRIO(struct) dalla function struct
% SIDEWASH(struct) dalla function sidewash 
% FIN_3D(struct) dalla function fin_3D
%
% OUTPUT : DERIV_DINA (struct) che contiene tutte le derivate di stabilità
% e di controllo (forse) della dinamica del velivolo

%--------------------------------------------------------------------------
function [DERIV_DINA_ALETTONI] = deriv_dina_ridotto_alettoni(DATI,ALA_3D,DOWNWASH,FIN_3D,SIDEWASH,EQUILIBRIO)

%%% indico i momenti rispettivamente con LL, MM, NN.

% INPUT:
% Carico le condizioni di equilibrio;
C_D_eq = EQUILIBRIO.C_D_eq;
C_L_eq = EQUILIBRIO.C_L_eq;
C_MM_eq = EQUILIBRIO.C_M_G_eq;

C_D_alpha_eq = EQUILIBRIO.C_D_alpha_eq;
C_L_alpha_eq = EQUILIBRIO.C_L_alpha_eq;
C_MM_alpha_eq = EQUILIBRIO.C_M_G_alpha_eq;

C_D_delta_e_eq = EQUILIBRIO.C_D_delta_e_eq;
C_L_delta_e_eq = EQUILIBRIO.C_L_delta_e_eq;
C_MM_delta_e_eq = EQUILIBRIO.C_M_G_delta_e_eq;

alpha_eq = EQUILIBRIO.alpha_eq; % [rad] incidenza del elivolo completo all'equilibrio
delta_e_eq = EQUILIBRIO.delta_e_eq;% [rad] deflessione dell'equilibratore all'equilibrio
V_eq = EQUILIBRIO.V_eq; % [m./s] Velocità all'equilibrio (per comodità)
rho = EQUILIBRIO.rho; % [kg./m.^3] densità all'equilibrio (per comodità)

% Carico i dati 
S_w1 = DATI.velivolo.S_w1; % [m2] Superficie della w_1
S_w2 = DATI.velivolo.S_w2  % [m2] Superficie della w2
l_w1 = ALA_3D.l_w1 	 % [m] apertura alare ala w1
l_w2 = ALA_3D.l_w2 	 % [m] apertura alare ala w2
AR_w1 = DATI.velivolo.AR_w1 	 % [-] Aspect ratio della w1
AR_w2 = DATI.velivolo.AR_w2 	 % [-] Aspect ratio della w2
x_G = DATI.velivolo.x_G 	 % [m] Coordinata longitud del baricentro nel sist di riferimento di prua
z_G = DATI.velivolo.z_G 	 % [m] Coordinata vert del baricentro nel sist di riferimento di prua
x_AC_w1 = DATI.velivolo.x_AC_w1 	 % [m] Coordinata longit. del centro aerodinamico della w1 nel sist di rif di prua
x_AC_w2 = DATI.velivolo.x_AC_w2 	 % [m] Coordinata longit. del centro aerodinamico della w2 nel sist di rif di prua
z_AC_w1 = DATI.velivolo.z_AC_w1 	 % [m] Coordinata vert. del centro aerodinamico della w1 nel sist di rif di prua
z_AC_w2 = DATI.velivolo.z_AC_w2 	 % [m] Coordinata vert. del centro aerodinamico della w2 nel sist di rif di prua
c_w1 = ALA_3D.c_w1 	 % [m] corda media aero di w1
c_w2 = ALA_3D.c_w2 	 % [m] corda media aero di w2
cy_w1 = ALA_3D.cy_w1; % [m](function handle) distribuzione delle corde in funzione di y
cy_w2 = ALA_3D.cy_w2; % [m](function handle) distribuzione delle corde in funzione di y

Lambda_w1 = DATI.velivolo.Lambda_w1; % [rad] Angolo di freccia dei quarti di corda (c./4) di w1
Lambda_w2 = DATI.velivolo.Lambda_w2; % [rad] Angolo di freccia dei quarti di corda (c./4) di w2
Gamma_w1 = DATI.velivolo.Gamma_w1; % [rad] Angolo diedro di w1
Gamma_w2 = DATI.velivolo.Gamma_w2; % [rad] Angolo diedro di w2

a_w1 = ALA_3D.a_w1 	 % [1./rad] pendenza CL_alpha dell'ala w1
a_w2 = ALA_3D.a_w2 	 % [1./rad] pendenza CL_alpha dell'ala w2
e_w1 = ALA_3D.e_w1 	 % [-] Fattore di Oswald dell'ala w1
e_w2 = ALA_3D.e_w2 	 % [-] Fattore di Oswald dell'ala w2
C_D_0_w1 = DATI.profili.ali.C_D_0 	% [-] Coefficiente di resistenza parassita del profilo dell'ala 
C_D_0_w2 = DATI.profili.ali.C_D_0 	% [-] Coefficiente di resistenza parassita del profilo dell'ala 
C_M_AC_0_w1 = DATI.profili.ali.C_M_AC_0 % [-] Coeff. di momento di trasporto del profilo rispetto al suo AC
C_M_AC_0_w2 = DATI.profili.ali.C_M_AC_0 % [-] Coeff. di momento di trasporto del profilo rispetto al suo AC
C_M_AC_delta_e_w2 = DATI.profili.ali.C_M_AC_delta_e     % [-] Derivata aerodinamica del momento focale rispetto a delta_e
 

l_f = FIN_3D.l_f;
c_f = FIN_3D.c_f;
S_f = FIN_3D.S_f;
Lambda_f = FIN_3D.Lambda_f;
a_f = FIN_3D.a_f;

eps_D_0 = DOWNWASH.eps_D_0 	 %[rad] angolo di downwash per alpha = 0
eps_D_alpha = DOWNWASH.eps_D_alpha 	 %[1./rad] pendenza eps./alpha downwash
eps_U_0 = DOWNWASH.eps_U_0 	 %[rad] angolo di upwash per alpha = 0
eps_U_alpha = DOWNWASH.eps_U_alpha 	 %[1./rad] pendenza eps./alpha upwash

sigma_beta = SIDEWASH.sigma_beta;

tau_a = ALA_3D.tau_a; % [-] fattore tau dell'alettone
la_lw1 = DATI.alettone.la_lw1; % [-] lunghezza dell'alettone (% della lungezza di l_w1)
tau_r_3D = FIN_3D.tau_r_3D;

%Dati ricavabili
eta = S_w2./S_w1;
X_AC_w1 = x_G - x_AC_w1 ; 
X_AC_w2 = x_G - x_AC_w2 ;  
Z_AC_w1 = z_G - z_AC_w1 ;
Z_AC_w2 = z_G - z_AC_w2 ;

l_a = la_lw1.*l_w1;


%.*.*DERIVATE RISPETTO A p:

% Derivata LL_p

% - Contributo delle ali
C_LL_p_w = -2./(V_eq.*S_w1.*l_w1).*(a_w1.*Integrate(@(y) cy_w1(y).*y.^2 ,0,l_w1./2) + a_w2.*Integrate(@(y) cy_w2(y).*y.^2 ,0,l_w2./2));

%- Contributo degli impennaggi
C_LL_p_f = -2.*(a_f.*c_f)./(S_w1.*l_w1.*V_eq).*(Integrate(@(z)(z-Z_AC_w1).^2, 0, l_f));

% C_LL_p complessivo
C_LL_p = C_LL_p_f + C_LL_p_w;

LL_p = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_p;


% DERIVATE RISPETTO A delta_a

% Derivata LL_delta_a:
C_LL_delta_a = -(2.*a_w1.*tau_a)./(S_w1.*l_w1).*Integrate(@(y) cy_w1(y).*y,(l_w1-l_a)./2,l_w1./2);
LL_delta_a = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_delta_a;



%%-------------------------------------------------------------------------
%%-------------------------------------------------------------------------

% OUTPUT: 
DERIV_DINA_ALETTONI = struct()

DERIV_DINA_ALETTONI.LL_p = LL_p;
DERIV_DINA_ALETTONI.LL_delta_a = LL_delta_a;

end