% Questa funzione calcola le derivate aerodinamiche in assi body 
% INPUT:
%
% DATI(struct) dalla function INPUT_DATI
% ALA_3D(struct) dalla function ala_3D
% DOWNWASH(struct) dalla function downwash
% EQUILIBRIO(struct) dalla function struct
% SIDEWASH(struct) dalla function sidewash 
% FIN_3D(struct) dalla function fin_3D
%
% OUTPUT : DERIV_DINA (struct) che contiene tutte le derivate di stabilità
% e di controllo (forse) della dinamica del velivolo

%--------------------------------------------------------------------------
function [DERIV_DINA] = deriv_dina(DATI,ALA_3D,DOWNWASH,FIN_3D,SIDEWASH,EQUILIBRIO)

%%% indico i momenti rispettivamente con LL, MM, NN.

% INPUT:
% Carico le condizioni di equilibrio;
C_D_eq = EQUILIBRIO.C_D_eq;
C_L_eq = EQUILIBRIO.C_L_eq;
C_MM_eq = EQUILIBRIO.C_M_G_eq;

C_D_alpha_eq = EQUILIBRIO.C_D_alpha_eq;
C_L_alpha_eq = EQUILIBRIO.C_L_alpha_eq;
C_MM_alpha_eq = EQUILIBRIO.C_M_G_alpha_eq;

C_D_delta_e_eq = EQUILIBRIO.C_D_delta_e_eq;
C_L_delta_e_eq = EQUILIBRIO.C_L_delta_e_eq;
C_MM_delta_e_eq = EQUILIBRIO.C_M_G_delta_e_eq;

alpha_eq = EQUILIBRIO.alpha_eq; % [rad] incidenza del elivolo completo all'equilibrio
delta_e_eq = EQUILIBRIO.delta_e_eq;% [rad] deflessione dell'equilibratore all'equilibrio
V_eq = EQUILIBRIO.V_eq; % [m./s] Velocità all'equilibrio (per comodità)
rho = EQUILIBRIO.rho; % [kg./m.^3] densità all'equilibrio (per comodità)

% Carico i dati 
S_w1 = DATI.velivolo.S_w1; % [m2] Superficie della w_1
S_w2 = DATI.velivolo.S_w2  % [m2] Superficie della w2
l_w1 = ALA_3D.l_w1 	 % [m] apertura alare ala w1
l_w2 = ALA_3D.l_w2 	 % [m] apertura alare ala w2
AR_w1 = DATI.velivolo.AR_w1 	 % [-] Aspect ratio della w1
AR_w2 = DATI.velivolo.AR_w2 	 % [-] Aspect ratio della w2
x_G = DATI.velivolo.x_G 	 % [m] Coordinata longitud del baricentro nel sist di riferimento di prua
z_G = DATI.velivolo.z_G 	 % [m] Coordinata vert del baricentro nel sist di riferimento di prua
x_AC_w1 = DATI.velivolo.x_AC_w1 	 % [m] Coordinata longit. del centro aerodinamico della w1 nel sist di rif di prua
x_AC_w2 = DATI.velivolo.x_AC_w2 	 % [m] Coordinata longit. del centro aerodinamico della w2 nel sist di rif di prua
z_AC_w1 = DATI.velivolo.z_AC_w1 	 % [m] Coordinata vert. del centro aerodinamico della w1 nel sist di rif di prua
z_AC_w2 = DATI.velivolo.z_AC_w2 	 % [m] Coordinata vert. del centro aerodinamico della w2 nel sist di rif di prua
c_w1 = ALA_3D.c_w1 	 % [m] corda media aero di w1
c_w2 = ALA_3D.c_w2 	 % [m] corda media aero di w2
cy_w1 = ALA_3D.cy_w1; % [m](function handle) distribuzione delle corde in funzione di y
cy_w2 = ALA_3D.cy_w2; % [m](function handle) distribuzione delle corde in funzione di y

Lambda_w1 = DATI.velivolo.Lambda_w1; % [rad] Angolo di freccia dei quarti di corda (c./4) di w1
Lambda_w2 = DATI.velivolo.Lambda_w2; % [rad] Angolo di freccia dei quarti di corda (c./4) di w2
Gamma_w1 = DATI.velivolo.Gamma_w1; % [rad] Angolo diedro di w1
Gamma_w2 = DATI.velivolo.Gamma_w2; % [rad] Angolo diedro di w2

a_w1 = ALA_3D.a_w1 	 % [1./rad] pendenza CL_alpha dell'ala w1
a_w2 = ALA_3D.a_w2 	 % [1./rad] pendenza CL_alpha dell'ala w2
e_w1 = ALA_3D.e_w1 	 % [-] Fattore di Oswald dell'ala w1
e_w2 = ALA_3D.e_w2 	 % [-] Fattore di Oswald dell'ala w2
C_D_0_w1 = DATI.profili.ali.C_D_0 	% [-] Coefficiente di resistenza parassita del profilo dell'ala 
C_D_0_w2 = DATI.profili.ali.C_D_0 	% [-] Coefficiente di resistenza parassita del profilo dell'ala 
C_M_AC_0_w1 = DATI.profili.ali.C_M_AC_0 % [-] Coeff. di momento di trasporto del profilo rispetto al suo AC
C_M_AC_0_w2 = DATI.profili.ali.C_M_AC_0 % [-] Coeff. di momento di trasporto del profilo rispetto al suo AC
C_M_AC_delta_e_w2 = DATI.profili.ali.C_M_AC_delta_e     % [-] Derivata aerodinamica del momento focale rispetto a delta_e
 

l_f = FIN_3D.l_f;
c_f = FIN_3D.c_f;
S_f = FIN_3D.S_f;
Lambda_f = FIN_3D.Lambda_f;
a_f = FIN_3D.a_f;

eps_D_0 = DOWNWASH.eps_D_0 	 %[rad] angolo di downwash per alpha = 0
eps_D_alpha = DOWNWASH.eps_D_alpha 	 %[1./rad] pendenza eps./alpha downwash
eps_U_0 = DOWNWASH.eps_U_0 	 %[rad] angolo di upwash per alpha = 0
eps_U_alpha = DOWNWASH.eps_U_alpha 	 %[1./rad] pendenza eps./alpha upwash

sigma_beta = SIDEWASH.sigma_beta;

tau_a = ALA_3D.tau_a; % [-] fattore tau dell'alettone
la_lw1 = DATI.alettone.la_lw1; % [-] lunghezza dell'alettone (% della lungezza di l_w1)
tau_r_3D = FIN_3D.tau_r_3D;

%Dati ricavabili
eta = S_w2./S_w1;
X_AC_w1 = x_G - x_AC_w1 ; 
X_AC_w2 = x_G - x_AC_w2 ;  
Z_AC_w1 = z_G - z_AC_w1 ;
Z_AC_w2 = z_G - z_AC_w2 ;

l_a = la_lw1.*l_w1;
%-----------------DERIVATE DELLA DINAMICA LONGITUDINALE-------------------%

%.*.*DERIVATE RISPETTO A u:

C_L_V = 0;
C_D_V = 0;
C_MM_V = 0;
C_T_V = -(C_D_0_w1+ eta.*C_D_0_w2); % è un'approssimazione dal NELSON;

C_T_eq = C_D_eq;

%(derivate vere e proprie)%
F_x_u = - 1./2.*rho.*S_w1.*(V_eq.^2 .*C_D_V + 2.*V_eq.*C_D_eq);
T_u =  1./2.*rho.*S_w1.*(V_eq.^2 .*C_T_V + 2.*V_eq.*C_T_eq);
F_z_u = - 1./2.*rho.*S_w1.*(V_eq.^2 .*C_L_V + 2.*V_eq.*C_L_eq);
MM_u = 1./2.*rho.*S_w1.*(V_eq.^2 .*C_MM_V + 2.*V_eq.*C_MM_eq);


%.*.* DERIVATE RISPETTO A w:

% Derivata F_z_w
F_z_w = -1./V_eq.*(1./2.*rho.*V_eq.^2.*S_w1.*C_L_alpha_eq); 

% Derivata F_x_w 
F_x_w = -1./V_eq.*(1./2.*rho.*V_eq.^2.*S_w1.*C_D_alpha_eq);

% Derivata MM_w
MM_w = 1./V_eq.*(1./2.*rho.*V_eq.^2.*S_w1.*c_w1.*C_MM_alpha_eq);


%.*.*DERIVATE RISPETTO A q
C_MM_q = - 1./(S_w1.*c_w1.*V_eq).*(X_AC_w1.^2.*a_w1 + X_AC_w2.^2.*a_w2);

MM_q = 1./2.*rho.*V_eq.^2.*S_w1.*c_w1.*C_MM_q;


%.*.*DERIVARE RISPETTO A wdot
d_AC = abs(X_AC_w1 - X_AC_w2);

C_MM_alphadot = S_w2./S_w1.* X_AC_w2./c_w1.*a_w2.*eps_D_alpha.*d_AC./V_eq;

MM_wdot = 1./2*rho.*V_eq.*S_w1.*c_w1.*C_MM_alphadot


%-------------DERIVATE DELLA DINAMICA LATERO-DIREZIONALE-----------------%

%.*.* DERIVATE RISPETTO A v

% Derivata F_y_v
C_Q_beta = 2.*S_f./S_w1.*a_f.*(1-sigma_beta);

F_y_v = -1./2.*rho.*V_eq.*S_w1.*C_Q_beta;


% Derivata NN_v
C_NN_beta = -(X_AC_w1 + X_AC_w2).*S_f./(S_w1.*l_w1).*a_f.*(1-sigma_beta);

NN_v = 1./2.*rho.*V_eq.*S_w1.*l_w1.*C_NN_beta;


% Derivata LL_v

%- Contributo del diedro
C_LL_beta_Gamma = -2./(S_w1.*l_w1).*(Gamma_w1.*Integrate(@(y)cy_w1(y),0,l_w1./2) + Gamma_w2.*Integrate(@(y)cy_w2(y),0,l_w2./2));
%- Contributo della freccia
C_LL_beta_Lambda = -(a_w1.*alpha_eq)./(S_w1.*l_w1).*(4.*cos(Lambda_w1).*sin(Lambda_w1)).*Integrate(@(y)cy_w1(y).*y ,0,l_w1./2)...
                   -(a_w2.*alpha_eq)./(S_w1.*l_w1).*(4.*cos(Lambda_w2).*sin(Lambda_w2)).*Integrate(@(y)cy_w2(y).*y ,0,l_w2./2);
% Contributo del timone
C_LL_beta_f = (Z_AC_w1 + Z_AC_w2).*S_f./(S_w1.*l_w1).*a_f.*(1-sigma_beta)

% C_LL_beta complessivo
C_LL_beta = C_LL_beta_Gamma + C_LL_beta_Lambda + C_LL_beta_f;


LL_v = 1./2.*rho.*V_eq.*S_w1.*l_w1.*C_LL_beta;


%.*.*DERIVATE RISPETTO A p:

% Derivata F_y_p
C_Q_p = 2.*(a_f.*c_f)./(S_w1.*V_eq).*Integrate(@(z) (z-Z_AC_w1), 0,l_f);

F_y_p = -1./2.*V_eq.^2.*S_w1.*C_Q_p;


% Derivata LL_p

% - Contributo delle ali
C_LL_p_w = -2./(V_eq.*S_w1.*l_w1).*(a_w1.*Integrate(@(y) cy_w1(y).*y.^2 ,0,l_w1./2) + a_w2.*Integrate(@(y) cy_w2(y).*y.^2 ,0,l_w2./2));

%- Contributo degli impennaggi
C_LL_p_f = -2.*(a_f.*c_f)./(S_w1.*l_w1.*V_eq).*(Integrate(@(z)(z-Z_AC_w1).^2, 0, l_f));

% C_LL_p complessivo
C_LL_p = C_LL_p_f + C_LL_p_w;

LL_p = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_p;


% Derivata NN_p
%- Contributo delle ali
C_NN_p_w = -2.* alpha_eq./(S_w1.*l_w1*V_eq).*(a_w1.*Integrate(@(y) cy_w1(y).*y.^2,0,l_w1./2) + a_w2.*Integrate(@(y) cy_w2(y).*y.^2,0,l_w2./2));

%- Conributo degli impennaggi
C_NN_p_f = (a_f.*c_f)./(V_eq.*S_w1.*l_w1).*Integrate(@(z) (X_AC_w1-z.*tan(Lambda_f)).*(Z_AC_w1-z), 0,l_f);

% - C_NN_p complessivo
C_NN_p = C_NN_p_w + C_NN_p_f;

NN_p = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_NN_p;

%.*.*DERIVATE RISPETTO A r
% Derivata F_y_r
C_Q_r = 2.*(a_f.*c_f)./(V_eq.*S_w1).*Integrate(@(z) X_AC_w1 - z.*tan(Lambda_f) , 0,l_f);

F_y_r = -1./2.*rho.*V_eq.^2.*S_w1.*C_Q_r;


% Derivata NN_r
C_NN_r = -2.* (a_f.*c_f)./(V_eq.*S_w1.*l_w1) .* Integrate(@(z) (X_AC_w1-z.*tan(Lambda_f)).^2 ,0,l_f);

NN_r = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_NN_r;


% Derivata LL_r
C_LL_r = 2.*(a_f.*c_f)./(V_eq.*S_w1.*l_w1).*Integrate(@(z)(X_AC_w1-z.*tan(Lambda_f)).*(Z_AC_w1-z), 0,l_f);

LL_r = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_r;

%-------------DERIVATE DI COMANDO DINAMICA LONGITUDIANALE-----------------%

% DERIVATE RISPETTO A delta_e
F_x_delta_e =  -1./2.*rho.*V_eq.^2.*S_w1.*C_D_delta_e_eq;
F_z_delta_e =  -1./2.*rho.*V_eq.^2.*S_w1.*C_L_delta_e_eq;
MM_delta_e = 1./2.*rho.*V_eq.^2.*S_w1.*c_w1.*C_MM_delta_e_eq;


%-------------DERIVATE DI COMANDO DINAMICA LATERO-DIREZIONALE--------------%

% DERIVATE RISPETTO A a delta_r

% Derivata F_y_delta_r: 
C_Q_delta_r = -(2.*S_f.*a_f.*tau_r_3D)./S_w1;
F_y_delta_r = -1./2.*rho.*V_eq.^2.*S_w1.*C_Q_delta_r;

% Derivata NN_delta_r:
C_NN_delta_r = (X_AC_w1 + X_AC_w2)./(S_w1.*l_w1).*S_f.*a_f.*tau_r_3D;
NN_delta_r = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_NN_delta_r;

% Derivata LL_delta_r:
C_LL_delta_r = -(Z_AC_w1 + Z_AC_w2)./(S_w1.*l_w1).*S_f.*a_f.*tau_r_3D;
LL_delta_r = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_delta_r;


% DERIVATE RISPETTO A delta_a

% Derivata NN_delta_a
NN_delta_a = 0;

% Derivata LL_delta_a:
C_LL_delta_a = -(2.*a_w1.*tau_a)./(S_w1.*l_w1).*Integrate(@(y) cy_w1(y).*y,(l_w1-l_a)./2,l_w1./2);
LL_delta_a = 1./2.*rho.*V_eq.^2.*S_w1.*l_w1.*C_LL_delta_a;



%%-------------------------------------------------------------------------
%%-------------------------------------------------------------------------

% OUTPUT: 
DERIV_DINA = struct()

DERIV_DINA.F_x_u = F_x_u;
DERIV_DINA.F_z_u = F_z_u;
DERIV_DINA.T_u = T_u;
DERIV_DINA.MM_u = MM_u;

DERIV_DINA.F_z_w = F_z_w;
DERIV_DINA.F_x_w = F_x_w;
DERIV_DINA.MM_w = MM_w;

DERIV_DINA.MM_q = MM_q;

DERIV_DINA.MM_wdot = MM_wdot;

DERIV_DINA.F_y_v = F_y_v;
DERIV_DINA.LL_v = LL_v;
DERIV_DINA.NN_v = NN_v;

DERIV_DINA.F_y_p = F_y_p;
DERIV_DINA.LL_p = LL_p;
DERIV_DINA.NN_p = NN_p;

DERIV_DINA.F_y_r = F_y_r;
DERIV_DINA.LL_r = LL_r;
DERIV_DINA.NN_r = NN_r;

DERIV_DINA.F_x_delta_e = F_x_delta_e;
DERIV_DINA.F_z_delta_e = F_z_delta_e;
DERIV_DINA.MM_delta_e = MM_delta_e;

DERIV_DINA.F_y_delta_r = F_y_delta_r;
DERIV_DINA.NN_delta_r = NN_delta_r;
DERIV_DINA.LL_delta_r = LL_delta_r;

DERIV_DINA.NN_delta_a = NN_delta_a;
DERIV_DINA.LL_delta_a = LL_delta_a;

end