function [FIN_3D] = fin_3D(DATI)

% INPUT:
a_2D_f = DATI.profili.vert.a_2D; % [1/rad] pendenza CL./alpha del profilo 2D delle ali 
x_G = DATI.velivolo.x_G 	 % [m] Coordinata longitud del baricentro nel sist di riferimento di prua
z_G = DATI.velivolo.z_G 	 % [m] Coordinata vert del baricentro nel sist di riferimento di prua
x_AC_w1 = DATI.velivolo.x_AC_w1 	 % [m] Coordinata longit. del centro aerodinamico della w1 nel sist di rif di prua
x_AC_w2 = DATI.velivolo.x_AC_w2 	 % [m] Coordinata longit. del centro aerodinamico della w2 nel sist di rif di prua
z_AC_w1 = DATI.velivolo.z_AC_w1 	 % [m] Coordinata vert. del centro aerodinamico della w1 nel sist di rif di prua
z_AC_w2 = DATI.velivolo.z_AC_w2 	 % [m] Coordinata vert. del centro aerodinamico della w2 nel sist di rif di prua
c_tip_w1 = DATI.velivolo.c_tip_w1; % [m] corda al tip della w_1
c_tip_w2 = DATI.velivolo.c_tip_w2; % [m] corda al tip della w_2

tau = DATI.superfici.tau ;  % [-] tau bidimensionale (function handle)

lr_lf = DATI.timone.lr_lf; % [-] lunghezza del timone (% della lungezza di l_f)
cr_cf = DATI.timone.cr_cf; % [-] corda del timone (% della lungezza di c_f)
% ------------------------------------------------------------------------------------------%
% ------------------------------------------------------------------------------------------%
X_AC_w1 = x_G - x_AC_w1 ; 
X_AC_w2 = x_G - x_AC_w2 ;  
Z_AC_w1 = z_G - z_AC_w1 ;
Z_AC_w2 = z_G - z_AC_w2 ;

d_AC = abs(X_AC_w1-X_AC_w2);
l_f = abs(Z_AC_w1-Z_AC_w2);

Lambda_f = atan(d_AC/l_f);
c_f = (c_tip_w1+c_tip_w2)/2;
S_f = l_f*c_f;
AR_f = l_f^2/S_f;

e_f = 1./(1.05+ 0.007.*pi.*AR_f);
a_f = a_2D_f/(1+ a_2D_f/(pi*AR_f*e_f)); 

tau_r = ppval(tau,cr_cf);
tau_r_3D = tau_r*lr_lf;

% ------------------------------------------------------------------------------------------%
% ------------------------------------------------------------------------------------------%
% OUTPUT:

FIN_3D = struct();

FIN_3D.l_f = l_f;
FIN_3D.c_f = c_f;
FIN_3D.S_f = S_f;
FIN_3D.Lambda_f = Lambda_f;

FIN_3D.a_f = a_f;

FIN_3D.tau_r_3D = tau_r_3D;

end





