% INPUT:
% per il momento nulla
%
% OUTPUT:
% DOWNWASH(struct) con i campi:
%     .eps_U_0: [rad] angolo di upwash per alpha = 0;
%     .eps_U_alpha: [1/rad] pendenza eps/alpha upwash;
%     .eps_D_0: [rad] angolo di downwash per alpha = 0;
%     .eps_D_alpha: [1/rad] pendenza eps/alpha downwash;

function [DOWNWASH] = downwash(DATI,ALA_3D)
% INPUT DATI
c_tip_w1 = DATI.velivolo.c_tip_w1;
c_root_w1 = DATI.velivolo.c_root_w1;
x_AC_w1 = DATI.velivolo.x_AC_w1;
x_AC_w2 = DATI.velivolo.x_AC_w2;
z_AC_w1 = DATI.velivolo.z_AC_w1;
z_AC_w2 = DATI.velivolo.z_AC_w2;
Lambda_w1 = DATI.velivolo.Lambda_w1;
AR_w1 = DATI.velivolo.AR_w1;
l_w1 = ALA_3D.l_w1;
%--------------------------------------------------------------------------

l_h = abs(x_AC_w1 - x_AC_w2);
h_h = abs(z_AC_w1 - z_AC_w2);
lambda = c_tip_w1/c_root_w1;
A = AR_w1;
b = l_w1;
Lambda_c_4 = Lambda_w1;

K_A = 1/A - 1/(1+A^(1.7));
K_lambda = (10 - 3*lambda)/7;
K_h = (1 - h_h/b)/(2*l_h/b)^(1/3);


eps_D_alpha = 4.44*(K_A*K_lambda*K_h*cos(Lambda_c_4)^(1.5))^(1.19); % [1/rad]
eps_U_alpha = 0.3 ; % [1/rad]


eps_U_0 = 0*pi/180 ; % [rad]
eps_D_0 = 0*pi/180 ; % [rad]


% ------------------------------------------------------------------------------------------%
% ------------------------------------------------------------------------------------------%

% OUTPUT:
DOWNWASH = struct(); 

DOWNWASH.eps_U_0 = eps_U_0; %[rad] angolo di upwash per alpha = 0;
DOWNWASH.eps_U_alpha = eps_U_alpha; %[1/rad] pendenza eps/alpha upwash;
DOWNWASH.eps_D_0 = eps_D_0; %[rad] angolo di downwash per alpha = 0;
DOWNWASH.eps_D_alpha = eps_D_alpha; %[1/rad] pendenza eps/alpha downwash;
end