% INPUT:
% DATI(struct)
%
% OUTPUT:
% ALA 3D(struct) con campi definiti nell'output

function [ALA_3D] = ala_3D (DATI)

% INPUT:
a_2D = DATI.profili.ali.a_2D; % [1/rad] pendenza CL./alpha del profilo 2D delle ali 
AR_w1 = DATI.velivolo.AR_w1; % [-] Aspect ratio della w1
AR_w2 = DATI.velivolo.AR_w2; % [-] Aspect ratio della w2
Lambda_w1 = DATI.velivolo.Lambda_w1; % [rad] Angolo di freccia dei quarti di corda (c/4) di w1
Lambda_w2 = DATI.velivolo.Lambda_w2; % [rad] Angolo di freccia dei quarti di corda (c/4) di w2
S_w1 = DATI.velivolo.S_w1; % [m2] Superficie della w_1
S_w2 = DATI.velivolo.S_w2; % [m2] Superficie della w2
z_AC_w1 = DATI.velivolo.z_AC_w1; % [m] Coordinata vert. del centro aerodinamico della w1 nel sist di rif di prua
z_AC_w2 = DATI.velivolo.z_AC_w2; % [m] Coordinata vert. del centro aerodinamico della w2 nel sist di rif di prua
c_tip_w1 = DATI.velivolo.c_tip_w1; % [m] corda al tip della w_1
c_tip_w2 = DATI.velivolo.c_tip_w2; % [m] corda al tip della w_2
c_root_w1 = DATI.velivolo.c_root_w1; % [m] corda al root della w_1
c_root_w2 = DATI.velivolo.c_root_w2; % [m] corda al root della w_2

tau = DATI.superfici.tau ;  % [-] tau bidimensionale (spline)
ce_cw2 = DATI.equilibratore.ce_cw2 ; % [-] corda dell'equilibratore (% della lungezza di c_w2)
le_lw2 = DATI.equilibratore.le_lw2; % [-] lunghezza dell'equilibratore (% della lungezza di l_w2)
ca_cw1 = DATI.alettone.ca_cw1; % [-] corda dell'alettone (% della lungezza di c_w1)
% ------------------------------------------------------------------------------------------%
% ------------------------------------------------------------------------------------------%

% Apertura alare di w1 e w2;
l_w1 = sqrt(S_w1.*AR_w1);
l_w2 = sqrt(S_w2.*AR_w2);

% Fattore di Oswald delle ali w1 e w2
e_w1 = 1./(1.05+ 0.007.*pi.*AR_w1);
e_w2 = 1./(1.05+ 0.007.*pi.*AR_w2);



% Pendenza CL./alpha delle ali w1 e w2
a_w1 = a_2D ./(1 + a_2D./(pi*AR_w1*e_w1));
a_w2 = a_2D ./(1 + a_2D./(pi*AR_w2*e_w2));

% Gap tra le due ali = distanza verticale tra i 2 centri aerodinamici
G = abs(z_AC_w1 - z_AC_w2);

% Fattore correttivo della resistenza indotta della box-wing
K_w1 = (1+0.45.*G./l_w1)./(1.04+2.81.*G./l_w1); 
K_w2 = (1+0.45.*G./l_w2)./(1.04+2.81.*G./l_w2);

% Distribuzione delle corde:
cy_w1 =@(y) c_root_w1 + 2.*(c_tip_w1 - c_root_w1).*y./l_w1;
cy_w2 =@(y) c_root_w2 + 2.*(c_tip_w2 - c_root_w2).*y./l_w2;

% Corda media aerodinamica per w1 e w2 
c_w1 = 2./S_w1.*(Integrate(@(y) cy_w1(y).^2 ,0,l_w1./2));
c_w2 = 2./S_w2.*(Integrate(@(y) cy_w2(y).^2 ,0,l_w2./2));

% fattori tau per le superfici di equilibratore 
tau_e = ppval(tau,ce_cw2);
tau_a = ppval(tau,ca_cw1);

tau_e_3D = tau_e*le_lw2;
% ------------------------------------------------------------------------------------------%
% ------------------------------------------------------------------------------------------%

% OUTPUT: ALA_3D (struct) 

ALA_3D = struct();

ALA_3D.l_w1 = l_w1; % [m] apertura alare ala w1
ALA_3D.l_w2 = l_w2; % [m] apertura alare ala w2
ALA_3D.c_w1 = c_w1; % [m] corda media aerodinamica di w1
ALA_3D.c_w2 = c_w2; % [m] corda media aerodinamica di w2
ALA_3D.cy_w1 = cy_w1; % [m](function handle) distribuzione delle corde in funzione di y
ALA_3D.cy_w2 = cy_w2; % [m](function handle) distribuzione delle corde in funzione di y
ALA_3D.a_w1 = a_w1; % [1/rad] pendenza CL_alpha dell'ala w1
ALA_3D.a_w2 = a_w2; % [1/rad] pendenza CL_alpha dell'ala w2
ALA_3D.e_w1 = e_w1; % [-] Fattore di Oswald dell'ala w1
ALA_3D.e_w2 = e_w2; % [-] Fattore di Oswald dell'ala w2
ALA_3D.K_w1 = K_w1; % [-] fattore correttivo della reistenza indotta della box-wing per w1
ALA_3D.K_w2 = K_w2; % [-] fattore correttivo della reistenza indotta della box-wing per w2


ALA_3D.tau_e_3D = tau_e_3D; % [-] fattore tau dell'equilibratore
ALA_3D.tau_a = tau_a; % [-] fattore tau dell'alettone
end

