close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')
addpath('funzioni_stabilità_dinamica')

% set(0,'defaultAxesFontSize',26);
% set(0,'defaulttextfontsize',16);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO

%%% DATI settare
beta = 15*pi/180;

%Rudder paremeters
cr_cf_min = 0.2;
cr_cf_max = 0.8;
Cr_cf = linspace(cr_cf_min,cr_cf_max,100);
Lr_lf = [0.5,0.75,0.8,0.9,1];


%--------------------------------------------------------------------------
[DATI] = INPUT_DATI();

% Ridefinisco 




j=0;
RES = {};
for lr_lf = Lr_lf
j = j+1;
    
    Delta_r = [];
    i=0;
    for cr_cf = Cr_cf
    i = i+1;
    
    DATI.timone.cr_cf = cr_cf;
    DATI.timone.lr_lf = lr_lf;
    
    [ALA_3D] = ala_3D (DATI);
    [FIN_3D] = fin_3D(DATI);
    [DOWNWASH] = downwash(DATI,ALA_3D);
    [SIDEWASH]= sidewash();
    [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);
    
    sigma_beta = SIDEWASH.sigma_beta;
    tau_f_3D = FIN_3D.tau_r_3D;
    
    delta_r = (1-sigma_beta)/tau_f_3D*beta;
    
    % converto in deg
    delta_r = delta_r *180/pi;
    
    Delta_r(i) = delta_r;
    end
    
    RES{j} = Delta_r
end

%-------------------------------RISULTATI----------------------------------

leg = [];

figure(1)
ax = gca;
ax.FontSize = axesfontsize;
title('Deflessione $\delta_r$ dell equilibratore richiesta per una variazione dell angolo di sideslip $\Delta\beta= 15\, deg$','FontSize',titlefontsize)
xlabel('$\frac{c_r}{c_f}$','FontSize',xlabelfontsize)
ylabel('$\delta_{r_{required}} [deg]$','FontSize',ylabelfontsize)
hold on
grid on

j=0;
for j = 1:length(Lr_lf)
delta_r = RES{j};
plot(Cr_cf,delta_r)
lr_lf = Lr_lf(j)
leg = [leg; strcat("$\frac{l_r}{l_f} = $",string(lr_lf))];
end
yline(20,'--')
leg = [leg; "limite massimo del timone"]

legend(leg,'Location','best','FontSize',legendfontsize)

clc
fprintf('DONE correctly')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);

for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Timone\figure_",string(k),".eps"),'epsc')
end