close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')

% set(0,'defaulttextfontsize',16);
% set(0,'defaultaxesfontsize',27);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO


[DATI] = INPUT_DATI();
[ALA_3D] = ala_3D (DATI);
[DOWNWASH] = downwash(DATI,ALA_3D);
x_G = DATI.velivolo.x_G 	 % [m] Coordinata longitud del baricentro nel sist di riferimento di prua
c_w1 = ALA_3D.c_w1; 	 % [m] corda media geometrica di w1

alpha_min = -20*pi/180; %[rad]
alpha_max = 20*pi/180; % [rad]
delta_e_min = -20*pi/180; % [rad]
delta_e_max = 20*pi/180;% [rad]

%% Derivate di portanza e CL in funzione di alpha per 3 valori di delta_e
alpha = linspace(alpha_min, alpha_max,100);% [rad]

str1 = [];
for delta_e = [delta_e_min,0,delta_e_max] % [rad]
[COEFF, ~] = equaz_costitutive(DATI, ALA_3D, DOWNWASH, alpha, delta_e)
C_L = COEFF.C_L;

alpha_plot = alpha*180/pi; % [deg] angoli in deg per il plot di alpha
delta_e_plot = delta_e*180/pi; % [deg] angoli in deg per il plot di delta_e

figure(1)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(alpha_plot,C_L);
grid on
title('Coefficiente di portanza $C_L$ al variare di $\alpha$','FontSize',titlefontsize)
xlabel('$\alpha$ [deg]','FontSize',xlabelfontsize)
ylabel('$C_L$ [-]','FontSize',ylabelfontsize)
str1 = [str1;...
       string(['$\delta_e$ = ', num2str(delta_e_plot),'deg'])];
end
legend(str1,'FontSize',legendfontsize)

[~,DERIV] = equaz_costitutive(DATI, ALA_3D, DOWNWASH, alpha, delta_e)
C_L_alpha = DERIV.C_L_alpha;
C_L_delta_e = DERIV.C_L_delta_e;

%% C_M_G e C_M_G_alpha in funzione di alpha per 3 valori di delta_e e punto neutro in funz di alpha
alpha = linspace(alpha_min,alpha_max,100); % [rad]

str2 = [];
str3 = [];
str4 = [];
for delta_e = [delta_e_min,0,delta_e_max] % [rad]

[COEFF, DERIV] = equaz_costitutive(DATI, ALA_3D, DOWNWASH, alpha, delta_e)
C_M_G = COEFF.C_M_G;
C_M_G_alpha = DERIV.C_M_G_alpha;

x_N = x_G - c_w1.*(C_M_G_alpha./C_L_alpha);

alpha_plot = alpha*180/pi; % [deg] angoli in deg per il plot di alpha
delta_e_plot = delta_e*180/pi; % [deg] angoli in deg per il plot di delta_e

figure(2)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(alpha_plot,C_M_G)
grid on
title('Coefficiente di momento $C_{\mathcal{M}}$ al variare di $\alpha$','FontSize',titlefontsize)
xlabel('$\alpha$ [deg]','FontSize',xlabelfontsize)
ylabel('$C_{\mathcal{M}}$ [-]','FontSize',ylabelfontsize)

figure(3)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(alpha_plot,C_M_G_alpha)
grid on
title('$C_{\mathcal{M}_\alpha}$ al variare di $\alpha$','FontSize',titlefontsize)
xlabel('$\alpha$ [deg]','FontSize',xlabelfontsize)
ylabel('$C_{\mathcal{M}_\alpha}$ [1/rad]','FontSize',ylabelfontsize)

figure(4)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(x_N,alpha_plot)
grid on
title('punto neutro N al variare di $\alpha$','FontSize',titlefontsize)
xlabel('$x_N$','FontSize',xlabelfontsize)
ylabel('$\alpha$ [deg]','FontSize',ylabelfontsize)

str2 = [str2;...
       string(['$\delta_e = $ ', num2str(delta_e_plot),'deg'])];

str3 = [str3;...
       string(['$\delta_e = $ ', num2str(delta_e_plot),'deg'])];

str4 = [str4;...
       string(['$\delta_e = $ ', num2str(delta_e_plot),'deg'])];
end

figure(2)
legend(str2,'FontSize',legendfontsize)

figure(3)
legend(str3,'FontSize',legendfontsize)

figure(4)
xline(x_G,'--r')
legend([str4;"$x_G$"],'FontSize',legendfontsize)


%% Derivata di Momento C_M_delta_e in funzione di delta_e per 3 valori di alpha

delta_e = linspace(delta_e_min,delta_e_max,100); % [rad]


str5 = [];
for alpha = [alpha_min,0,alpha_max] % [rad]
    
[~, DERIV] = equaz_costitutive(DATI, ALA_3D, DOWNWASH, alpha, delta_e); 
C_M_G_delta_e = DERIV.C_M_G_delta_e;

alpha_plot = alpha*180/pi; % [deg] angoli in deg per il plot di alpha
delta_e_plot = delta_e*180/pi; % [deg] angoli in deg per il plot di delta_e

str5 = [str5;...
       string(['$\alpha =$ ', num2str(alpha_plot),'deg'])];

figure(5)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(delta_e_plot,C_M_G_delta_e)
grid on
title('$C_{\mathcal{M}_{\delta_e}}$ al variare di $\delta_e$','FontSize',titlefontsize)
xlabel('$\delta_e$ [deg]','FontSize',xlabelfontsize)
ylabel('$C_{\mathcal{M}_{\delta_e}}$ [1/rad]','FontSize',ylabelfontsize)


end
figure(5)
legend(str5,'FontSize',legendfontsize)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);

for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Stab_Statica\figure_",string(k),".eps"),'epsc')
end


clc
fprintf('DERIVATE aerodinamiche di portanza: \n')
fprintf('CL/alpha = %d [1/rad] \n', C_L_alpha);
fprintf('CL/delta_e = %d [1/rad] \n', C_L_delta_e);


