close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')
addpath('funzioni_stabilità_dinamica')

% set(0,'defaulttextfontsize',16);
% set(0,'defaultaxesfontsize',27);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO

[DATI] = INPUT_DATI();


%--------------------------------------------------------------------------
[ALA_3D] = ala_3D (DATI);
[DOWNWASH] = downwash(DATI,ALA_3D);
[FIN_3D] = fin_3D(DATI);
[SIDEWASH]= sidewash();
[EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);
[DERIV_DINA] = deriv_dina(DATI,ALA_3D,DOWNWASH,FIN_3D,SIDEWASH,EQUILIBRIO);


g = 9.81;
V_eq = EQUILIBRIO.V_eq;
u_eq = V_eq;

% carico i dati
m = DATI.masse.m;
I_xx = DATI.masse.I_xx;
I_yy = DATI.masse.I_yy;
I_zz = DATI.masse.I_zz;
I_xz = DATI.masse.I_xz;

F_x_u = DERIV_DINA.F_x_u;
F_z_u = DERIV_DINA.F_z_u;
T_u = DERIV_DINA.T_u;
MM_u = DERIV_DINA.MM_u;

F_z_w = DERIV_DINA.F_z_w;
F_x_w = DERIV_DINA.F_x_w;
MM_w = DERIV_DINA.MM_w;

MM_q = DERIV_DINA.MM_q;

MM_wdot = DERIV_DINA.MM_wdot;

F_y_v = DERIV_DINA.F_y_v;
LL_v = DERIV_DINA.LL_v;
NN_v = DERIV_DINA.NN_v;

F_y_p = DERIV_DINA.F_y_p;
LL_p = DERIV_DINA.LL_p;
NN_p = DERIV_DINA.NN_p;

F_y_r = DERIV_DINA.F_y_r;
LL_r = DERIV_DINA.LL_r;
NN_r = DERIV_DINA.NN_r;

F_x_delta_e = DERIV_DINA.F_x_delta_e;
F_z_delta_e = DERIV_DINA.F_z_delta_e;
MM_delta_e = DERIV_DINA.MM_delta_e;

F_y_delta_r = DERIV_DINA.F_y_delta_r;
NN_delta_r = DERIV_DINA.NN_delta_r;
LL_delta_r = DERIV_DINA.LL_delta_r;

NN_delta_a = DERIV_DINA.NN_delta_a;
LL_delta_a = DERIV_DINA.LL_delta_a;

% Derivate divise per la massa e l'inerzia

F_x_u_cup = F_x_u/m;
F_x_w_cup = F_x_w/m;
F_x_delta_e_cup = F_x_delta_e/m;
F_z_u_cup = F_z_u/m;
F_z_w_cup = F_z_w/m;
F_z_delta_e_cup = F_z_delta_e/m;
F_y_v_cup = F_y_v/m;
F_y_p_cup = F_y_p/m;
F_y_r_cup = F_y_r/m;
F_y_delta_r_cup = F_y_delta_r/m;

T_u_cup = T_u/m;

MM_u_cup = MM_u/I_yy;
MM_w_cup = MM_w/I_yy;
MM_q_cup = MM_q/I_yy;
MM_wdot_cup = MM_wdot/I_yy;
MM_delta_e_cup = MM_delta_e/I_yy;

LL_v_cup = LL_v/I_xx;
LL_p_cup = LL_p/I_xx;
LL_r_cup = LL_r/I_xx;
LL_delta_a_cup = LL_delta_a/I_xx;
LL_delta_r_cup = LL_delta_r/I_xx;


NN_v_cup = NN_v/I_zz;
NN_p_cup = NN_p/I_zz;
NN_r_cup = NN_r/I_zz;
NN_delta_a_cup = NN_delta_a/I_zz;
NN_delta_r_cup = NN_delta_r/I_zz;


LL_v_star = LL_v_cup/(1-I_xz^2/(I_xx*I_zz));
LL_p_star = LL_p_cup/(1-I_xz^2/(I_xx*I_zz));
LL_r_star = LL_r_cup/(1-I_xz^2/(I_xx*I_zz));
LL_delta_a_star = LL_delta_a_cup/(1-I_xz^2/(I_xx*I_zz));
LL_delta_r_star = LL_delta_r_cup/(1-I_xz^2/(I_xx*I_zz));

NN_v_star = NN_v_cup/(1-I_xz^2/(I_xx*I_zz));
NN_p_star = NN_p_cup/(1-I_xz^2/(I_xx*I_zz));
NN_r_star = NN_r_cup/(1-I_xz^2/(I_xx*I_zz));
NN_delta_a_star = NN_delta_a_cup/(1-I_xz^2/(I_xx*I_zz));
NN_delta_r_star = NN_delta_r_cup/(1-I_xz^2/(I_xx*I_zz));

%----------------------DINAMICA LONGITUDINALE------------------------------

% Matrice di stato della dinamica longitudinale

A_LON = [F_x_u_cup + T_u_cup, F_x_w_cup, 0, -g;
         F_z_u_cup, F_z_w_cup, u_eq, 0;  
         MM_u_cup+MM_wdot_cup*F_z_u_cup, MM_w_cup+MM_wdot_cup*F_z_w_cup, MM_q_cup+MM_wdot_cup*u_eq, 0;
         0, 0, 1, 0];
% Matrice di controllo della dinamica longitudinale
B_LON = [F_x_delta_e_cup;
         F_z_delta_e_cup;
         MM_delta_e_cup + MM_wdot_cup*F_z_delta_e_cup;
         0];


%----------------------DINAMICA LATERO-DIREZIONALE-------------------------

% Matrice di stato della dinamica latero direzionale
A_LAT = [F_y_v_cup, F_y_p_cup, -(u_eq-F_y_r_cup) g;
         LL_v_star+(I_xz/I_xx)*NN_v_star, LL_p_star+(I_xz/I_xx)*NN_p_star, LL_r_star+(I_xz/I_xx)*NN_r_star, 0;
         NN_v_star+(I_xz/I_zz)*LL_v_star, NN_p_star+(I_xz/I_zz)*LL_p_star, NN_r_star+(I_xz/I_zz)*LL_r_star, 0;
         0, 1, 0, 0];
% Matrice di controllo della dinamica latero-direzionale
B_LAT = [0, F_y_delta_r_cup ;
         LL_delta_a_star+(I_xz/I_xx)*NN_delta_a_star, LL_delta_r_star+(I_xz/I_xx)*NN_delta_r_star ;
         NN_delta_a_star+(I_xz/I_zz)*LL_delta_a_star, NN_delta_r_star+(I_xz/I_zz)*LL_delta_r_star ;
         0, 0];

%---------------------------RISULTATI STABILITA'---------------------------------

Autov_LON = eig(A_LON)
Autov_LAT = eig(A_LAT)

figure(1)
ax = gca;
ax.FontSize = axesfontsize
plot(Autov_LON,'*','MarkerSize',12)
grid on
title('Autovalori della dinamica longitudinale','FontSize',titlefontsize)
xlabel('$Re(\lambda)$','FontSize',xlabelfontsize)
ylabel('$Im(\lambda)$','FontSize',ylabelfontsize)

figure(2)
ax = gca;
ax.FontSize = axesfontsize
plot(Autov_LAT,'*','MarkerSize',12)
grid on
title('Autovalori della dinamica latero-direzionale','FontSize',titlefontsize)
xlabel('$Re(\lambda)$','FontSize',xlabelfontsize)
ylabel('$Im(\lambda)$','FontSize',ylabelfontsize)


omega_n= {};
zita = {};
str= {};
for i = 1:length(Autov_LON)

lambda = Autov_LON(i);    
omega = abs(imag(lambda));
eta = real(lambda);

if omega == 0;
str{i} = "moto aperiodico"
omega_n{i} = "Not defined";
zita{i} = "Not defined";
else    

omega_n{i} = eta^2/sqrt(eta^2+omega^2) + omega*sqrt(-(-1-eta/sqrt(eta^2+omega^2))*(1-eta/sqrt(eta^2+omega^2)));
zita{i} = - eta/sqrt(eta^2+omega^2);
str{i} = "moto periodico"
end
end
TABLE_LON = table(Autov_LON, omega_n', zita',str');
TABLE_LON.Properties.VariableNames = {'lambda_LON','omega_n','zita','moto periodico/aperiodico'};


omega_n= {};
zita = {};
str= {};
for i = 1:length(Autov_LAT)

lambda = Autov_LAT(i);    
omega = abs(imag(lambda));
eta = real(lambda);

if omega == 0;
str{i} = "moto aperiodico"
omega_n{i} = "Not defined";
zita{i} = "Not defined";
else    

omega_n{i} = eta^2/sqrt(eta^2+omega^2) + omega*sqrt(-(-1-eta/sqrt(eta^2+omega^2))*(1-eta/sqrt(eta^2+omega^2)));
zita{i} = - eta/sqrt(eta^2+omega^2);
str{i} = "moto periodico"
end
end
TABLE_LAT = table(Autov_LAT, omega_n', zita',str');
TABLE_LAT.Properties.VariableNames = {'lambda_LAT','omega_n','zita','moto periodico/aperiodico'};

%--------------RISPOSTA ALLA MANOVRA (opzionale)---------------------------


%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
clc
fprintf('DONE correctly \n')
disp(TABLE_LON)
disp(TABLE_LAT)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);


for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Stab_Dinamica\figure_",string(k),".eps"),'epsc')
end

