close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')
addpath('funzioni_stabilità_dinamica')
addpath('salita')

% set(0,'defaulttextfontsize',16);
% set(0,'defaultaxesfontsize',27);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO

% Calcolo della potenza necessaria

V_max = 100;%[m/s]
V_stall = 40;%[m/s]
V = linspace(V_stall,V_max,100);%[m/s]

% Rendimenti
eta_B = 0.98;
eta_PE = 0.98;
eta_M = 0.95;
eta_F = 0.83;
eta_D = 0.92;
eta_P = 0.94;

% Velocità di crociera
V_cruise = 250/3.6%[m/s]
range = 250*1000;%[m]

%Dati batteria 
En_density = 350*3600%[KJ/m3]
En_specifica = 0.4*3600%[KJ/Kg]
SOC_min = 0.1%(in percentuale indica lo stato minimo di carica residua al di sotto del quale si rischiano danni irreversibili alla batteria stessa)

%Numero di motori
N_motors = 3;
%--------------------------------------------------------------------------
[DATI] = INPUT_DATI();

rho = DATI.ambiente.rho_inf;
S_w1 = DATI.velivolo.S_w1;

P_required = []; %[W]
i = 0;
for V_eq = V

    i = i+1;

    DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

    [ALA_3D] = ala_3D (DATI);
    [FIN_3D] = fin_3D(DATI);
    [DOWNWASH] = downwash(DATI,ALA_3D);
    [SIDEWASH]= sidewash();
    [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);
   

    C_D_eq = EQUILIBRIO.C_D_eq;

    p_required = 1/2*rho*V_eq^3*S_w1*C_D_eq% [W]
    % conversione in KW
    p_required = p_required/1000;
    
    P_required(i) = p_required;
    
end

% Dimensionamento del motore
eta_0 = eta_B*eta_PE*eta_M*eta_F*eta_D*eta_P;
t_cruise = range/V_cruise;

[DATI] = INPUT_DATI();
DATI.volo.V_inf = V_cruise; % [m/s] Velocità di volo (vel. asintotica) in crociera

[ALA_3D] = ala_3D (DATI);
[FIN_3D] = fin_3D(DATI);
[DOWNWASH] = downwash(DATI,ALA_3D);
[SIDEWASH]= sidewash();
[EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

C_D_cruise = EQUILIBRIO.C_D_eq;

p_required_cruise = 1/2*rho*V_cruise^3*S_w1*C_D_cruise% [W]
% conversione in KW
p_required_cruise = p_required_cruise/1000;%[KW]

p_avaiable_cruise = p_required_cruise; %[KW]

p_motors = p_avaiable_cruise/(eta_P*eta_F*eta_D*eta_M);
p_motor = p_motors/N_motors;

p_batteria = p_avaiable_cruise/eta_0;

Energy_batteria = p_batteria *t_cruise/(1-SOC_min)%[KJ]

Peso_batteria  = Energy_batteria/En_specifica %[Kg]
Volume_batteria = Energy_batteria/En_density; %[m3]

figure(1)
ax = gca;
ax.FontSize = axesfontsize
hold on
plot(V,P_required)
plot(V_cruise, p_avaiable_cruise,'o')
grid on
title('Potenza propulsiva necessaria al variare della velocita di crociera','Fontsize',titlefontsize)
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\Pi_T = \Pi_D [kW]$','Fontsize',ylabelfontsize)
legend('$\Pi_T$','${\left. \Pi_T \right|}_{@ 250\,km/h}$','Fontsize',legendfontsize)
clc


%%% Prestazioni in salita
% settare il range di variazione degli angoli di salita e il range di
% velocita e diametro del disco
Gamma = pi/180*[0:5:35]; % [rad]
V_max = 80;%[m/s]
V_stall = 40;%[m/s]


V = linspace(V_stall,V_max,100);%[m/s]

[DATI] = INPUT_DATI();
m = DATI.masse.m;
g = 9.81;

RES = {};
RES2 = {};
RES3 = {};
j = 0
for gamma = Gamma

j = j+1;    
    
P_required_climb = []; %[W]
P_motors_climb = [];
P_motor_climb = [];
i = 0;
for V_eq = V

    i = i+1;

    DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

    [ALA_3D] = ala_3D (DATI);
    [FIN_3D] = fin_3D(DATI);
    [DOWNWASH] = downwash(DATI,ALA_3D);
    [SIDEWASH]= sidewash();
    [EQUILIBRIO_CLIMB] = equilibrio_climb(DATI, ALA_3D, DOWNWASH,gamma)
   

    C_D_eq = EQUILIBRIO_CLIMB.C_D_eq;
    
    p_drag = 1/2*rho*V_eq^3*S_w1*C_D_eq% [W]
    p_required_climb = p_drag + m*g*sin(gamma)*V_eq; % [W]
        
    % conversione in KW
    p_required_climb = p_required_climb/1000; % [kW]
    p_motors_climb = p_required_climb/(eta_P*eta_F*eta_D*eta_M); %[kW]
    p_motor_climb = p_motors_climb/N_motors; %[kW] 
    
    
    P_required_climb(i) = p_required_climb;
    P_motors_climb(i) = p_motors_climb;
    P_motor_climb(i) = p_motor_climb;
end

RES{j} = P_required_climb;
RES2{j} = P_motors_climb;
RES3{j} = P_motor_climb;
end


figure(2)
ax = gca;
ax.FontSize = axesfontsize
hold on

j=0;
leg =[];
RGB = [0 0 0];
for j = 1:length(Gamma)
gamma = Gamma(j)*180/pi; % conversione in deg
P_required_climb = RES{j};
plot(V,P_required_climb,'Color',RGB)
grid on
leg = [leg; strcat("$\gamma = $",string(gamma)," deg")];
RGB = RGB + [1 1 0]/length(Gamma);
end
title('Potenza propulsiva necessaria in salita al variare della velocita','Fontsize',titlefontsize)
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\Pi_T = \Pi_D + mg\sin(\gamma) [kW]$','Fontsize',ylabelfontsize)
legend(leg,'Fontsize',legendfontsize);

figure(3)
ax = gca;
ax.FontSize = axesfontsize
hold on

j=0;
leg =[];
RGB = [0 0 0];
for j = 1:length(Gamma)
gamma = Gamma(j)*180/pi; % conversione in deg
P_motors_climb = RES2{j};
plot(V,P_motors_climb,'Color',RGB)
grid on
leg = [leg; strcat("$\gamma = $",string(gamma)," deg")];
RGB = RGB + [0 1 0]/length(Gamma);
end
title('Potenza necessaria dei motori complessiva in condizioni di salita','Fontsize',titlefontsize)
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\Pi_M [kW]$','Fontsize',ylabelfontsize)
legend(leg,'Fontsize',legendfontsize);



figure(4)
ax = gca;
ax.FontSize = axesfontsize
hold on

j=0;
leg =[];
RGB = [0 0 0];
for j = 1:length(Gamma)
gamma = Gamma(j)*180/pi; % conversione in deg
P_motor_climb = RES3{j};
plot(V,P_motor_climb,'Color',RGB)
grid on
leg = [leg; strcat("$\gamma = $",string(gamma)," deg")];
RGB = RGB + [0 1 1]/length(Gamma);
end
title(strcat("potenza necessaria di ciascun motore in condizioni di salita per un numero di motori pari a"," $N_{M}$ = ",string(N_motors)),'Fontsize',titlefontsize)
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\Pi_{SM} [kW]$','Fontsize',ylabelfontsize)
legend(leg,'Fontsize',legendfontsize);

%%% Dimensionamento del Fan
V_max = 80;%[m/s]
V_stall = 40;%[m/s]
D = [0.5, 0.75, 1]; % [m]
gamma = 10*pi/180; %[rad]


V = linspace(V_stall,V_max,100);%[m/s]

RES4 = {};

j = 0
for d = D

j = j+1;    

A = pi*d^2/4 %[m2]

Sigma = []; %[W]
i = 0;
for V_eq = V

    i = i+1;

    DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

    [ALA_3D] = ala_3D (DATI);
    [FIN_3D] = fin_3D(DATI);
    [DOWNWASH] = downwash(DATI,ALA_3D);
    [SIDEWASH]= sidewash();
    [EQUILIBRIO_CLIMB] = equilibrio_climb(DATI, ALA_3D, DOWNWASH,gamma)


    C_D_eq = EQUILIBRIO_CLIMB.C_D_eq;
    
    drag = 1/2*rho*V_eq^2*S_w1*C_D_eq% [N]
    thrust_required_climb = drag + m*g*sin(gamma); % [N]
    
    % spinta del singolo motore
    thrust_required_climb_SM = thrust_required_climb/N_motors;
    
    sigma = thrust_required_climb_SM/A
    
    Sigma(i)= sigma;
end

RES4{j} = Sigma;
end

figure(5)
ax = gca;
ax.FontSize = axesfontsize
hold on

j=0;
leg =[];
gamma = gamma*180/pi %[deg] conversione in deg
for j = 1:length(D)
d = D(j)    
Sigma = RES4{j};
plot(V,Sigma)
grid on
leg = [leg; strcat("$d = $",string(d)," m")];
end
title(strcat("Carico sul disco in condizioni di salita per numero di motori","$ N_{M}$ = ",string(N_motors)," per $\gamma= $",string(gamma)," deg"),'Fontsize',titlefontsize)
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\mu [N/m^2]$','Fontsize',ylabelfontsize)
legend(leg,'Fontsize',legendfontsize);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);

for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Propulsivo\figure_",string(k),".eps"),'epsc')
end


