close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')
addpath('funzioni_stabilità_dinamica')

% set(0,'defaulttextfontsize',16);
% set(0,'defaultaxesfontsize',27);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO

%Parametri
V_max = 100;
V_stall = 40;
S_w2_S_w1_vect = [.9 .8 .7 .6 .5 .4]; % associo RES
x_w2_vect = [3,3.15,4,5,6]; % associo RES2
z_w2_vect = [1,1.3,1.4,1.8]; % associo RES3 
i_w2_vect = pi/180*[10,0,-10]; % associo RES4
ce_cw2_vect = [0.2,0.3 ,0.4]; % associo RES5
le_lw2_vect = [0.2,0.3,0.4,0.5,0.8,1]; % associo RES6

V = linspace(V_stall,V_max,30);


%--------------------------------------------------------------------------
[DATI] = INPUT_DATI();

S_w1 = DATI.velivolo.S_w1;

% Rapporto di superfici

RES = {};

j = 0;
for S_w2_Sw1 = S_w2_S_w1_vect
    
    j = j+1;
    
    S_w2 = S_w2_Sw1*S_w1
    
    DATI.velivolo.S_w2 = S_w2

    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES{j} = Delta_e_eq;
end

% x_w2 

[DATI] = INPUT_DATI(); 

RES2 = {};

j = 0;
for x_w2 = x_w2_vect
    
    j = j+1;
    
    
    DATI.velivolo.x_AC_w2 = x_w2;

    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES2{j} = Delta_e_eq;
end


% z_w2

[DATI] = INPUT_DATI(); 

RES3 = {};

j = 0;
for z_w2 = z_w2_vect
    
    j = j+1;
    
    
    DATI.velivolo.z_AC_w2 = z_w2;

    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES3{j} = Delta_e_eq;
end



% i_w2

[DATI] = INPUT_DATI(); 

RES4 = {};

j = 0;
for i_w2 = i_w2_vect
    
    j = j+1;
    
    
    DATI.velivolo.i_w2 = i_w2;

    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES4{j} = Delta_e_eq;
end


% ce_cw2

[DATI] = INPUT_DATI(); 

RES5 = {};

j = 0;
for ce_cw2 = ce_cw2_vect
    
    j = j+1;
    
    
    DATI.equilibratore.ce_cw2 = ce_cw2
    
    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES5{j} = Delta_e_eq;
end



% le_lw2

[DATI] = INPUT_DATI(); 

RES6 ={};

j = 0;
for le_lw2 = le_lw2_vect
    
    j = j+1;
    
    DATI.equilibratore.le_lw2 = le_lw2;

    Delta_e_eq = [];
    i = 0;
    for V_eq = V

        i = i+1;

        DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera

        [ALA_3D] = ala_3D (DATI);
        [FIN_3D] = fin_3D(DATI);
        [DOWNWASH] = downwash(DATI,ALA_3D);
        [SIDEWASH]= sidewash();
        [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);

        delta_e_eq = EQUILIBRIO.delta_e_eq;
        % trasformo in des/s
        delta_e_eq = delta_e_eq*180/pi;

        Delta_e_eq(i) = delta_e_eq;
    end
    RES6{j} = Delta_e_eq;
end

%%%%%%%%%%%%% PLOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per vari valori del rapporto di superfici")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(S_w2_S_w1_vect)
        Delta_e_eq = RES{j};
        plot(V,Delta_e_eq)
        S_w2_S_w1 = S_w2_S_w1_vect(j);
        leg = [leg; strcat("$\frac{S_{w_2}}{S_{w_1}} = $",string(S_w2_S_w1))];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)


figure(2)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per vari valori della posizione longitudinale del centro aerodinamico dell'ala w2")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(x_w2_vect)
        Delta_e_eq = RES2{j};
        plot(V,Delta_e_eq)
        x_w2 = x_w2_vect(j);
        leg = [leg; strcat("$x_{AC_{w_2}}= $",string(x_w2)," m")];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)



figure(3)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per vari valori della posizione verticale del centro aerodinamico dell'ala w2")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(z_w2_vect)
        Delta_e_eq = RES3{j};
        plot(V,Delta_e_eq)
        z_w2 = z_w2_vect(j);
        leg = [leg; strcat("$z_{AC_{w_2}}= $",string(z_w2)," m")];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)


figure(4)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per diversi valori del calettamento dell'ala w2")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(i_w2_vect)
        Delta_e_eq = RES4{j};
        plot(V,Delta_e_eq)
        i_w2 = i_w2_vect(j);
        leg = [leg; strcat("$i_{w_2}= $",string(i_w2*180/pi)," deg")];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)


figure(5)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per vari valori della rapporto di cordr $\frac{c_e}{c_{w_2}}$")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(ce_cw2_vect)
        Delta_e_eq = RES5{j};
        plot(V,Delta_e_eq)
        ce_cw2 = ce_cw2_vect(j);
        leg = [leg; strcat("$\frac{c_e}{c_{w_2}} = $",string(ce_cw2))];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)

figure(6)
ax = gca;
ax.FontSize = axesfontsize
hold on
grid on
title([strcat("deflessione dell'equilibratore in condizioni di trim per vari valori del rapporto di lunghezze $\frac{l_e}{l_{w_2}}$")],'Fontsize',titlefontsize)
    j = 0;
    leg = [];
    for j = 1:length(le_lw2_vect)
        Delta_e_eq = RES6{j};
        plot(V,Delta_e_eq)
        le_lw2 = le_lw2_vect(j);
        leg = [leg; strcat("$\frac{l_e}{l_{w_2}} = $",string(le_lw2))];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$\delta_{e_{eq}} [deg]$','Fontsize',ylabelfontsize)

yline(-15,'--')
yline(+15,'--')
legend([leg;"limite minimo";"limite massimo"],'Location','best','Fontsize',legendfontsize)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);

for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Equilibratore_NEW\figure_",string(k),".eps"),'epsc')
end

clc
fprintf('DONE correctly')

