close all
clear all
clc

%%% PREAMBOLO
restoredefaultpath

addpath('funzioni_stabiltà_statica')
addpath('file ausiliari')
addpath('altre_funzioni')
addpath('funzioni_stabilità_dinamica')

% set(0,'defaulttextfontsize',16);
% set(0,'defaultaxesfontsize',27);

%%% FONT SIZES
xlabelfontsize = 20;
ylabelfontsize = 20;
axesfontsize = 20;
legendfontsize = 20;
titlefontsize = 16;

set(0,'defaulttextInterpreter','latex');
set(0,'defaultlegendInterpreter','latex');
set(0,'defaultAxesTickLabelInterpreter','latex');
set(0, 'DefaultLineLineWidth', 2);
set(0,'defaultConstantLineLineWidth',2);
% percorso per selezionare la configurazione d'interesse
path_config
%%% FINE PREAMBOLO

%%% DATI settare
delta_a_max = 20*pi/180;

%Alieron paremeters
Ca_cw1 = [0.3, 0.4, 0.5];
La_lw1 = [0.2,0.3,0.4,0.5,0.8,1];

V_max = 100;
V_stall = 40;
V = linspace(V_stall,V_max,5);

%--------------------------------------------------------------------------
[DATI] = INPUT_DATI();


RES = {};
k = 0;
for ca_cw1 = Ca_cw1
    k = k+1;
    
    DATI.alettone.ca_cw1 = ca_cw1
    
    j = 0;
    for la_lw1 = La_lw1
        j = j+1;
        
        DATI.alettone.la_lw1 = la_lw1; 
        
        P_max = [];
        i = 0;
        for V_eq = V
            
            i = i+1;
            
            DATI.volo.V_inf = V_eq; % [m/s] Velocità di volo (vel. asintotica) in crociera
    
            [ALA_3D] = ala_3D (DATI);
            [FIN_3D] = fin_3D(DATI);
            [DOWNWASH] = downwash(DATI,ALA_3D);
            [SIDEWASH]= sidewash();
            [EQUILIBRIO] = equilibrio(DATI, ALA_3D, DOWNWASH);
            [DERIV_DINA_ALETTONI] = deriv_dina_ridotto_alettoni(DATI,ALA_3D,DOWNWASH,FIN_3D,SIDEWASH,EQUILIBRIO)
            
            LL_delta_a = DERIV_DINA_ALETTONI.LL_delta_a;
            LL_p = DERIV_DINA_ALETTONI.LL_p;
            
            p_max = - LL_delta_a/LL_p*delta_a_max;
            % trasformo in des/s
            p_max = p_max*180/pi;
            
            P_max(i) = p_max;
        end
        RES{j,k} = P_max;
    end
end

leg = [];

k = 0;
for k = 1:length(Ca_cw1)
ca_cw1 = Ca_cw1(k)
leg = [];

figure(k)
ax = gca;
ax.FontSize = axesfontsize

hold on
grid on
title(strcat("Velocita di rollio massima al comando di alettone $\delta_{a_{max}}$ = 20\,deg per un rapporto di corde $\frac{c_a}{c_{w_1}} = $ ",string(ca_cw1)),'Fontsize',titlefontsize)
    j = 0;
    for j = 1:length(La_lw1)
        P_max = RES{j,k};
        plot(V,P_max)
        la_lw1 = La_lw1(j);
        leg = [leg; strcat("$\frac{l_a}{l_{w_1}} = $",string(la_lw1))];
    end
xlabel('$V [m/s]$','Fontsize',xlabelfontsize)
ylabel('$p_{max} [deg/s]$','Fontsize',ylabelfontsize)

yline(-40,'--')
legend([leg;"limite minimo"],'Location','best','Fontsize',legendfontsize)

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SALVATAGGIO FIGURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h =  findobj('type','figure');
n = length(h);

for k = 1:n
g = figure(k);
g.WindowState = 'maximized';
saveas(figure(k),strcat("C:\Users\Asus PC\Desktop\POLITO\TESI\Calcoli e Risultati\MATLAB\IMMAGINI\TESTING_Alettoni\figure_",string(k),".eps"),'epsc')
end