% IN QUESTA FUNCTION INSERISCO I VALORI DI INPUT.
% TALE FUNZIONE VERRA' SUCCESSIVAMENTE RICHIAMATA NEI VARI SCRIPT
%
% OUTPUT:
% DATIs(struct) con i seguenti campi e relativi sottocampi:

function [DATI] = INPUT_DATI()

% Carico il file tau_2D (spline)
load('tau_2D.mat')
%------------------------------------------------------------------------------------------%
%------------------------------------------------------------------------------------------%

% OUTPUT:

% GENERO IL FILE (struct) DEI DATI
DATI = struct();

%CONFIGURAZIONE:
DATI.configurazione = "configurazione 0 (default)";

% DATI DEL VELIVOLO
DATI.velivolo.i_w1 = 0; % [rad] calettamento della w1
DATI.velivolo.i_w2 = 0*pi/180; % [rad] calettamento della w2
DATI.velivolo.S_w1 = 7.5; % [m2] Superficie della w_1
DATI.velivolo.S_w2 = 7.5; % [m2] Superficie della w2
DATI.velivolo.AR_w1 =  4.8; % [-] Aspect ratio della w1
DATI.velivolo.AR_w2 =  4.8;  % [-] Aspect ratio della w2
DATI.velivolo.c_tip_w1 = 1; % [m] corda al tip della w_1
DATI.velivolo.c_tip_w2 = 1; % [m] corda al tip della w_2
DATI.velivolo.c_root_w1 = 1.5; % [m] corda al root della w_1
DATI.velivolo.c_root_w2 = 1.5; % [m] corda al root della w_2
DATI.velivolo.Lambda_w1 = 2*pi/180; % [rad] Angolo di freccia dei quarti di corda (c/4) di w1
DATI.velivolo.Lambda_w2 = 2*pi/180; % [rad] Angolo di freccia dei quarti di corda (c/4) di w2
DATI.velivolo.Gamma_w1 = 5*pi/180; % [rad] Angolo diedro di w1
DATI.velivolo.Gamma_w2 = 5*pi/180; % [rad] Angolo diedro di w2
DATI.velivolo.x_G = 3.15; % [m] Coordinata longitud del baricentro nel sist di riferimento di prua
DATI.velivolo.z_G = 1.4; % [m] Coordinata vert del baricentro nel sist di riferimento di prua
DATI.velivolo.x_AC_w1 = 2.4; % [m] Coordinata longit. del centro aerodinamico della w1 nel sist di rif di prua
DATI.velivolo.x_AC_w2 = 5; % [m] Coordinata longit. del centro aerodinamico della w2 nel sist di rif di prua
DATI.velivolo.z_AC_w1 = 1.6; % [m] Coordinata vert. del centro aerodinamico della w1 nel sist di rif di prua
DATI.velivolo.z_AC_w2 = 0.3; % [m] Coordinata vert. del centro aerodinamico della w2 nel sist di rif di prua

% DATI AERODINAMICI PROFILI
% Profili Ali
DATI.profili.ali.a_2D = 0.113*180/pi; % [1/rad] pendenza CL/alpha del profilo 2D delle ali 
DATI.profili.ali.C_D_0 = 0.005;% [-] Coefficiente di resistenza parassita del profilo dell'ala 
DATI.profili.ali.C_M_AC_0 = -0.1; % [-] Coeff. di momento focale per delta_e = 0
DATI.profili.ali.C_M_AC_delta_e = 0; % [-] Derivata aerodinamica del momento focale rispetto a delta_e


% Profili verticali
DATI.profili.vert.a_2D = 0.1*180/pi; % [1/rad] pendenza CL/alpha del profilo verticale 2D 
DATI.profili.vert.C_D_0 = 0.003; % [-] Coefficiente di resistenza parassita del profilo verticale
DATI.profili.vert.C_M_AC_0 = 0; % [-] Coeff. di momento di trasporto del profilo rispetto al suo AC

% DATI SUPERFICI DI CONTROLLO
% formula generale del tau bidimensionale
DATI.superfici.tau = S; % [-] tau bidimensionale (spline)

DATI.equilibratore.le_lw2 = 3/4; % [-] lunghezza dell'equilibratore (% della lungezza di l_w2)
DATI.equilibratore.ce_cw2 = 0.4; % [-] corda dell'equilibratore (% della lungezza di c_w2)

DATI.alettone.la_lw1 = 1/6; % [-] lunghezza dell'alettone (% della lungezza di l_w1)
DATI.alettone.ca_cw1 = 1/3; % [-] corda dell'alettone (% della lungezza di c_w1)

DATI.timone.lr_lf = 1; % [-] lunghezza del timone (% della lungezza di l_f)
DATI.timone.cr_cf = 0.8; % [-] corda del timone (% della lungezza di c_f)

% DATI FUSOLIERA
DATI.fusoliera.C_D_fus = 0.05; % [-] Coefficiente di resistenza della fusoliera adimensionalizzato rispetto alla sua superficie frontale
DATI.fusoliera.S_fus = 2; % [-] Superficie frontale della fusoliera

% DATI DI VOLO
DATI.volo.V_inf = 70; % [m/s] Velocità di volo (vel. asintotica) in crociera

% DATI AMBIENTALI
DATI.ambiente.T_inf = 288; % [K] Temperatura di riferimento
DATI.ambiente.rho_inf = 1.225; % [kg/m^3] densità dell'aria di riferimento

% DATI MASSA E INERZIE
DATI.masse.m = 2000 %[kg] Massa del velivolo
DATI.masse.I_xx = 1750% [kg*m^2] Momento d'inerzia Ixx
DATI.masse.I_yy = 2500 % [kg*m^2] Momento d'inerzia Ixx
DATI.masse.I_zz = 4000 % [kg*m^2] Momento d'inerzia Ixx
DATI.masse.I_xz = 0 % [kg*m^2] Momento d'inerzia Ixx

end
