//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : PIPE Monitor Checker
// Author  : nrigotti
//-----------------------------------------------------------------------------
// Description: Constant 
//              It is made up of:
//                - Global Core Settings Values Definition
//                - LTSSM States Definition
//                - Link Status Values Definition
//                -
//                - ...
//-----------------------------------------------------------------------------

`ifdef PLDA_PIPEMC_CONSTANT_H
`else
  `define PLDA_PIPEMC_CONSTANT_H

  //---------------------------------------------------------------------------
  // Completion status
  //---------------------------------------------------------------------------
  `define CPL_STATUS_SC               3'b000
  `define CPL_STATUS_UR               3'b001
  `define CPL_STATUS_CRS              3'b010
  `define CPL_STATUS_CA               3'b100

  //---------------------------------------------------------------------------
  // Message code
  //---------------------------------------------------------------------------
  `define MSG_UNLOCK                  8'b00000000
  `define MSG_INVAL_REQ               8'b00000001
  `define MSG_INVAL_CPL               8'b00000010
  `define MSG_PAGE_REQ                8'b00000100
  `define MSG_PRG_RESP                8'b00000101
  `define MSG_LTR                     8'b00010000
  `define MSG_OBFF                    8'b00010010
  `define MSG_PM_ASNAK                8'b00010100
  `define MSG_PM_PME                  8'b00011000
  `define MSG_PM_TURNOFF              8'b00011001
  `define MSG_PM_TOACK                8'b00011011
  `define MSG_ASRT_INTA               8'b00100000
  `define MSG_ASRT_INTB               8'b00100001
  `define MSG_ASRT_INTC               8'b00100010
  `define MSG_ASRT_INTD               8'b00100011
  `define MSG_DSRT_INTA               8'b00100100
  `define MSG_DSRT_INTB               8'b00100101
  `define MSG_DSRT_INTC               8'b00100110
  `define MSG_DSRT_INTD               8'b00100111
  `define MSG_ERR_COR                 8'b00110000
  `define MSG_ERR_NON                 8'b00110001
  `define MSG_ERR_FAT                 8'b00110011
  `define MSG_SET_SPL                 8'b01010000
  `define MSG_PTM_REQ                 8'b01010010
  `define MSG_PTM_RESP                8'b01010011
  `define MSG_VDM_TYPE0               8'b01111110
  `define MSG_VDM_TYPE1               8'b01111111

  `define MSG_ASRT_INTX               6'b001000
  `define MSG_DSRT_INTX               6'b001001
  `define MSG_INTX                    5'b00100

  `define OBFF_IDLE                   4'b0000
  `define OBFF_OBFF                   4'b0001
  `define OBFF_CPUACTIVE              4'b1111




  //---------------------------------------------------------------------------
  // PIPE message bus
  //---------------------------------------------------------------------------
  // Request bus
  `define PMR_DATA                   0
  `define PMR_ADDR                   (`PMR_DATA   + 8)
  `define PMR_COMMIT                 (`PMR_ADDR   +12)
  `define PMR_REQ                    (`PMR_COMMIT + 1)
  `define PMR_SIZE                   (`PMR_REQ    + 1)

  // Sources
  `define PMS_SIZE                   2
  `define PMS_LTSSM                  2'd0
  `define PMS_LMR                    2'd1
  `define PMS_EQU                    2'd2

  // Ack
  `define PMA_SRC                    0
  `define PMA_CMD_SENT               (`PMA_SRC      + `PMS_SIZE)
  `define PMA_WAIT_ACK               (`PMA_CMD_SENT + 1        )
  `define PMA_SIZE                   (`PMA_WAIT_ACK + 1        )

  //---------------------------------------------------------------------------
  // LTSSM States Definition
  //---------------------------------------------------------------------------
  // LTSSM States Definition
  `define LTSSM_DET_QUIET             5'h0
  `define LTSSM_DET_ACT               5'h1
  `define LTSSM_POL_ACT               5'h2
  `define LTSSM_POL_COMPL             5'h3
  `define LTSSM_POL_CFG               5'h4
  `define LTSSM_CFG_LWSTR             5'h5
  `define LTSSM_CFG_LWACC             5'h6
  `define LTSSM_CFG_LWAIT             5'h7
  `define LTSSM_CFG_LNACC             5'h8
  `define LTSSM_CFG_CPLT              5'h9
  `define LTSSM_CFG_IDLE              5'ha
  `define LTSSM_RCV_RLOCK             5'hb
  `define LTSSM_RCV_EQUAL             5'hc
  `define LTSSM_RCV_SPEED             5'hd
  `define LTSSM_RCV_RCFG              5'he
  `define LTSSM_RCV_IDLE              5'hf
  `define LTSSM_L0                    5'h10
  `define LTSSM_L0S                   5'h11
  `define LTSSM_L1__ENTRY             5'h12
  `define LTSSM_L1__IDLE              5'h13
  `define LTSSM_L2__IDLE              5'h14
  `define LTSSM_L2__TWAKE             5'h15
  `define LTSSM_DIS_DISAB             5'h16
  `define LTSSM_LPK_ENTRY             5'h17
  `define LTSSM_LPK_ACT               5'h18
  `define LTSSM_LPK_EXIT              5'h19
  `define LTSSM_HOT_RESET             5'h1a

  // LTSSM Rx-L0s Substates Definition
  `define LTSSM_RXL0S_INACT           2'd0
  `define LTSSM_RXL0S_IDLE            2'd1
  `define LTSSM_RXL0S_FTS             2'd2
  `define LTSSM_RXL0S_OUT_RCV         2'd3

  // LTSSM Tx-L0s Substates Definition
  `define LTSSM_TXL0S_INACT           2'd0
  `define LTSSM_TXL0S_IDLE            2'd1
  `define LTSSM_TXL0S_FTS             2'd2
  `define LTSSM_TXL0S_OUT_L0          2'd3

  //---------------------------------------------------------------------------
  // Link Status Values Definition
  //---------------------------------------------------------------------------

  // Link Width Definition
  `define LINK_WIDTH_UNDEFINED        5'd0
  `define LINK_WIDTH_X1               5'd1
  `define LINK_WIDTH_X2               5'd2
  `define LINK_WIDTH_X4               5'd4
  `define LINK_WIDTH_X8               5'd8
  `define LINK_WIDTH_X16              5'd16

  // Link Speed Definition
  `define LINK_RATE_25GT              3'b000
  `define LINK_RATE_5GT               3'b001
  `define LINK_RATE_8GT               3'b010
  `define LINK_RATE_16GT              3'b011
  `define LINK_RATE_32GT              3'b100

  // Power State Definition
  `define POWER_STATE_P0              4'h0
  `define POWER_STATE_P0S             4'h1
  `define POWER_STATE_P1              4'h2
  `define POWER_STATE_P2              4'h3

  // CCIX ESM rates
  `define ESM_RATE_INACT              7'd0
  `define ESM_RATE_2_5GT              7'd1
  `define ESM_RATE_5GT                7'd2
  `define ESM_RATE_8GT                7'd3
  `define ESM_RATE_16GT               7'd6
  `define ESM_RATE_20GT               7'd10
  `define ESM_RATE_25GT               7'd15
  `define ESM_RATE_32GT               7'd22

  // PCLK rates
  `define PCLK_RATE_62_5              5'd0
  `define PCLK_RATE_125               5'd1
  `define PCLK_RATE_250               5'd2
  `define PCLK_RATE_500               5'd3
  `define PCLK_RATE_1000              5'd4
  `define PCLK_RATE_2000              5'd5
  `define PCLK_RATE_4000              5'd6

  // Interface Width
  `define PIPE_WIDTH_8                3'd0
  `define PIPE_WIDTH_16               3'd1
  `define PIPE_WIDTH_32               3'd2
  `define PIPE_WIDTH_64               3'd3
  `define PIPE_WIDTH_128              3'd4

  //---------------------------------------------------------------------------
  // Special Symbols and Data Definition
  //---------------------------------------------------------------------------

  // Special Symbols
  `define B_COM                       8'hBC
  `define B_STP                       8'hFB
  `define B_SDP                       8'h5C
  `define B_END                       8'hFD
  `define B_EDB                       8'hFE
  `define B_PAD                       8'hF7
  `define B_SKP                       8'h1C
  `define B_FTS                       8'h3C
  `define B_IDL                       8'h7C
  `define B_EIE                       8'hFC
  `define B_ERR                       8'h23
  `define K_COM                       {1'b1, `B_COM} // K28_5
  `define K_STP                       {1'b1, `B_STP} // K27.7
  `define K_SDP                       {1'b1, `B_SDP} // K28.2
  `define K_END                       {1'b1, `B_END} // K29.7
  `define K_EDB                       {1'b1, `B_EDB} // K30.7
  `define K_PAD                       {1'b1, `B_PAD} // K23_7
  `define K_SKP                       {1'b1, `B_SKP} // K28_0
  `define K_FTS                       {1'b1, `B_FTS} // K28_1
  `define K_IDL                       {1'b1, `B_IDL} // K28_3
  `define K_EIE                       {1'b1, `B_EIE} // K28_7

  // Data
  `define DnTS1                       8'hB5 // D21.5
  `define DnTS2                       8'hBA // D26.5
  `define D_TS1                       8'h4A // D10.2
  `define D_TS2                       8'h45 // D5.2
  `define D_D00                       8'h00 // D0.0

  // 128b130b Identifiers
  `define SH_OS                       2'b01                    // Synchro Header : Ordered Set Block
  `define B_TS1                       8'h1E
  `define B_TS2                       8'h2D
  `define I_TS1                       {1'b1, `SH_OS , `B_TS1}
  `define I_TS2                       {1'b1, `SH_OS , `B_TS2}
  `define I_SDS_8G                    {1'b1, `SH_OS , 16'h55E1 }
  `define I_SDS_32G                   {1'b1, `SH_OS , 16'h87E1 }
  `define I_SKP_8G                    {1'b1, `SH_OS , 16'hAAAA }
  `define I_SKP_32G                   {1'b1, `SH_OS , 16'h9999 }
  `define I_FTS                       {1'b1, `SH_OS , 16'h4755 }
  `define I_IDL                       {1'b1, `SH_OS , 16'h6666 }
  `define I_EIE_8G                    {1'b1, `SH_OS , 16'hFF00 }
  `define I_EIE_16G                   {1'b1, `SH_OS , 16'h0000 }
  `define I_EIE_32G                   {1'b1, `SH_OS , 16'h0000 }

  // 128b130b Tokens
  `define T_SDP                       16'hF0AC
  `define T_STP                       4'hF
  `define T_EDS                       32'h1F809000
  `define T_EDS_REV                   32'h0090801F
  `define T_EDB                       32'hC0C0C0C0
  `define T_IDL                       8'h00

  `define T_SDP0                      8'hF0
  `define T_SDP1                      8'hAC
  `define T_EDB0                      8'hC0
  `define T_SKP_END                   8'hE1
  `define T_SKP_END_CTL               8'h78

  // 128b130b Ordered Sets
  `define EIEOS_USE_8G                2'b00
  `define EIEOS_USE_16G               2'b01
  `define EIEOS_USE_32G               2'b10


  //---------------------------------------------------------------------------
  // Low-power States Definition
  //---------------------------------------------------------------------------

  `define LPMSM_L0_RST                4'd0
  `define LPMSM_L0                    4'd1
  `define LPMSM_ASPM_L1_IN0           4'd2
  `define LPMSM_ASPM_L1_IN1           4'd3
  `define LPMSM_ASPM_L1_OUT           4'd4
  `define LPMSM_L1_IN0                4'd5
  `define LPMSM_L1_IN1                4'd6
  `define LPMSM_L1                    4'd7
  `define LPMSM_L0_IN                 4'd8
  `define LPMSM_L0_IN_WAIT            4'd9
  `define LPMSM_L2_IN0                4'd10
  `define LPMSM_L2_IN1                4'd11
  `define LPMSM_L2                    4'd12



  //---------------------------------------------------------------------------
  // Equalization commands & responses
  //---------------------------------------------------------------------------

  `define CMD_IDLE                    3'd0
  `define CMD_SETINITPRESET           3'd1
  `define CMD_REQLOCALPRESET          3'd2
  `define CMD_REQLOCALCOEFF           3'd3
  `define CMD_REMOTECOEFF             3'd4
  `define CMD_PERFORMRXEVAL           3'd5
  `define CMD_REMOTEREQREJECT         3'd6
  `define CMD_REMOTEREQFAIL           3'd7

  `define RESP_IDLE                   3'd0
  `define RESP_LOCALCOEFFMAPPING      3'd1
  `define RESP_LOCALCOEFFACCEPT       3'd2
  `define RESP_LOCALCOEFFREJECT       3'd3
  `define RESP_NEWREMOTEPRESET        3'd4
  `define RESP_NEWREMOTECOEFF         3'd5
  `define RESP_EQUSUCCESS             3'd6
  `define RESP_EQUFAIL                3'd7

  `define EQCMD_COMMAND               0
  `define EQCMD_REMOTECOEFF_CUR       (`EQCMD_COMMAND            +  3)
  `define EQCMD_REMOTEFS              (`EQCMD_REMOTECOEFF_CUR    + 18)
  `define EQCMD_REMOTELF              (`EQCMD_REMOTEFS           +  6)
  `define EQCMD_LOCALCOEFF_NEW        (`EQCMD_REMOTELF           +  6)
  `define EQCMD_LOCALTXPRESET_NEW     (`EQCMD_LOCALCOEFF_NEW     + 18)
  `define EQCMD_LOCALRXPRESETHINT     (`EQCMD_LOCALTXPRESET_NEW  +  4)
  `define EQCMD_SIZE                  (`EQCMD_LOCALRXPRESETHINT  +  3)

  `define EQRESP_RESPONSE             0
  `define EQRESP_LOCALCOEFF_CUR       (`EQRESP_RESPONSE          +  3)
  `define EQRESP_LOCALFS              (`EQRESP_LOCALCOEFF_CUR    + 18)
  `define EQRESP_LOCALLF              (`EQRESP_LOCALFS           +  6)
  `define EQRESP_REMOTECOEFF_NEW      (`EQRESP_LOCALLF           +  6)
  `define EQRESP_REMOTEPRESET_NEW     (`EQRESP_REMOTECOEFF_NEW   + 18)
  `define EQRESP_SIZE                 (`EQRESP_REMOTEPRESET_NEW  +  4)

  //---------------------------------------------------------------------------
  // PIPE side-band signals
  //---------------------------------------------------------------------------

  `define PIPEI_LOCALTXCOEFFVALID     0
  `define PIPEI_LOCALTXCOEFF          (`PIPEI_LOCALTXCOEFFVALID  +  1)
  `define PIPEI_LOCALFS               (`PIPEI_LOCALTXCOEFF       + 18)
  `define PIPEI_LOCALLF               (`PIPEI_LOCALFS            +  6)
  `define PIPEI_LINKEVAL_MERIT        (`PIPEI_LOCALLF            +  6)
  `define PIPEI_LINKEVAL_DIRCHG       (`PIPEI_LINKEVAL_MERIT     +  8)
  `define PIPEI_RSVD                  (`PIPEI_LINKEVAL_DIRCHG    +  6)
  `define PIPEI_SIZE                  (`PIPEI_RSVD               + 19)

  `define PIPEO_TXDEEMPH              0
  `define PIPEO_TXMARGIN              (`PIPEO_TXDEEMPH           + 18)
  `define PIPEO_TXSWING               (`PIPEO_TXMARGIN           +  3)
  `define PIPEO_RXPOLARITY            (`PIPEO_TXSWING            +  1)
  `define PIPEO_BLOCKALIGNCONTROL     (`PIPEO_RXPOLARITY         +  1)
  `define PIPEO_FS                    (`PIPEO_BLOCKALIGNCONTROL  +  1)
  `define PIPEO_LF                    (`PIPEO_FS                 +  6)
  `define PIPEO_RXPRESETHINT          (`PIPEO_LF                 +  6)
  `define PIPEO_RXEQEVAL              (`PIPEO_RXPRESETHINT       +  3)
  `define PIPEO_RXEQINPROGRESS        (`PIPEO_RXEQEVAL           +  1)
  `define PIPEO_INVALIDREQUEST        (`PIPEO_RXEQINPROGRESS     +  1)
  `define PIPEO_GETLOCALCOEFF         (`PIPEO_INVALIDREQUEST     +  1)
  `define PIPEO_LOCALPRESETINDEX      (`PIPEO_GETLOCALCOEFF      +  1)
  `define PIPEO_RXEQEVAL_TYPE         (`PIPEO_LOCALPRESETINDEX   +  6)
  `define PIPEO_RSVD                  (`PIPEO_RXEQEVAL_TYPE      +  1)
  `define PIPEO_SIZE                  (`PIPEO_RSVD               + 14)


  //---------------------------------------------------------------------------
  // Rx Status
  //---------------------------------------------------------------------------
  `define RXST_OK                     3'b000
  `define RXST_SKP_ADD                3'b001
  `define RXST_SKP_RM                 3'b010
  `define RXST_RX_DET                 3'b011
  `define RXST_DEC_ERR                3'b100
  `define RXST_ELBUF_OVFL             3'b101
  `define RXST_ELBUF_UNFL             3'b110
  `define RXST_DISP_ERR               3'b111

  //---------------------------------------------------------------------------
  // Data Rate Identifier
  //---------------------------------------------------------------------------
  `define DRI_2_5GT_SUPP              5'b00001
  `define DRI_5GT_SUPP                5'b00011
  `define DRI_8GT_SUPP                5'b00111
  `define DRI_16GT_SUPP               5'b01111
  `define DRI_32GT_SUPP               5'b11111

  //---------------------------------------------------------------------------
  // AXI Encoding
  //---------------------------------------------------------------------------
  // AxBURST[1:0]
  `define AXI_AxBURST_FIXED           2'b00
  `define AXI_AxBURST_INCR            2'b01
  `define AXI_AxBURST_WRAP            2'b10

  // xRESP[1:0]
  `define AXI_xRESP_OKAY              2'b00
  `define AXI_xRESP_EXOKAY            2'b01
  `define AXI_xRESP_SLVOKAY           2'b10
  `define AXI_xRESP_DECOKAY           2'b11

`endif