//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : PIPE Monitor Checker
// Author  : nrigotti
//-----------------------------------------------------------------------------
// Description: PIPE Monitor Checker Parameters 
//              It is made up of:
//                - RAM Parameters
//                - Timer Parameters
//                - Packet Parameters
//                -
//                - ...
//-----------------------------------------------------------------------------

`ifdef PLDA_PIPEMC_CONFIG_H
`else
  `define PLDA_PIPEMC_CONFIG_H

  //---------------------------------------------------------------------------
  // RAM PARAMETERS
  //---------------------------------------------------------------------------
  //  Number of RAMS (msgbus RAMs are not considered)
  `define NRAM_W0                      'd4  // #             RAMs with ADDR WIDTH = MEM_ADDR_WIDTH_MAX
  `define NRAM_W1                      'd0  // # Pairs    of RAMs with ADDR WIDTH = MEM_ADDR_WIDTH_MAX - 1
  `define NRAM_W2                      'd0  // # Quartets of RAMs with ADDR WIDTH = MEM_ADDR_WIDTH_MAX - 2
  `define NRAM_W3                      'd0  // # Octets   of RAMs with ADDR WIDTH = MEM_ADDR_WIDTH_MAX - 3

  //  Address Width
  `define MEM_ADDR_WIDTH_REG           'd2
  `define MEM_ADDR_WIDTH_LTSSM_PHASE   'd4
  `define MEM_ADDR_WIDTH_RERR          'd4
  `define MEM_ADDR_WIDTH_MSGBUS        'd4
  `define MEM_ADDR_WIDTH_DATA_EVNT     'd4
  `define MEM_ADDR_WIDTH_DATA_ERR      'd4

  `define MEM_ADDR_WIDTH_MAX           `MEM_ADDR_WIDTH_DATA_EVNT

  //  Data Width
  `define MEM_DATAPATH_WIDTH           'd512

  //---------------------------------------------------------------------------
  // BACKDOOR ACCESS PARAMETERS
  //---------------------------------------------------------------------------
  // AXI4 Interface
  `define AXI_ADDR_WIDTH              'd64

  // UART Interface
  //`define C_CLKS_PER_BIT              16'd976    // 128000 baud rate with 125 MHz clock
  `define C_CLKS_PER_BIT              16'd1953    // 128000 baud rate with 250 MHz clock
  
  //---------------------------------------------------------------------------
  // TIMER PARAMETERS
  //---------------------------------------------------------------------------
  `define G_COUNTER_US_WIDTH           'd32

  //---------------------------------------------------------------------------
  // PACKET PARAMETERS
  //---------------------------------------------------------------------------
  //  Packet Width
  `define PKT_WIDTH_LTSSM_PHASE        'd32
  `define PKT_WIDTH_RERR               'd32
  `define PKT_WIDTH_MSGBUS             'd32
  `define PKT_WIDTH_DATA_EVNT          'd32
  `define PKT_WIDTH_DATA_ERR           'd32


  //  Payload Width
  `define PL_WIDTH_LTSSM_PHASE         'd5
  `define PL_WIDTH_RERR                'd3 // Not Constant
  `define PL_WIDTH_MSGBUS              'd9
  `define PL_WIDTH_DATA_EVNT           'd5
  `define PL_WIDTH_DATA_ERR            'd5

  //  Time Width
  `define TIME_WIDTH_LTSSM_PHASE      `PKT_WIDTH_LTSSM_PHASE  - `PL_WIDTH_LTSSM_PHASE
  `define TIME_WIDTH_RERR             `PKT_WIDTH_RERR         - `PL_WIDTH_RERR
  `define TIME_WIDTH_MSGBUS           `PKT_WIDTH_MSGBUS       - `PL_WIDTH_MSGBUS
  `define TIME_WIDTH_DATA_EVNT        `PKT_WIDTH_DATA_EVNT    - `PL_WIDTH_DATA_EVNT
  `define TIME_WIDTH_DATA_ERR         `PKT_WIDTH_DATA_ERR     - `PL_WIDTH_DATA_ERR

  //`define CPL_STATUS_UR               3'b001

`endif