//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : XpressRich5-AXI/AXI_BFM
//           (PIPE Monitor Checker)
//-----------------------------------------------------------------------------
// Description: XR5AXI IP Core Single-Clock RAM with Byte Enable support
// Dependency : 
//-----------------------------------------------------------------------------

`default_nettype none
`timescale 1 ns / 1 ps

module xr5axi_scrambe
 #(
    //-------------------------------------------------------------------------
    parameter   ADDR_WIDTH              =    9, // Addr  Width in bits : 2**ADDR_WIDTH = RAM Depth
    parameter   DATA_WIDTH              =  256  // Data  Width in bits
    //-------------------------------------------------------------------------
  ) (
    //-------------------------------------------------------------------------
    // Buffer Interface
    //  . Clock
    input  wire                                         scram_clk             ,
    //  . Write Port
    input  wire                                         scram_wren            ,
    input  wire [DATA_WIDTH/8                     -1:0] scram_wrbe            ,
    input  wire [ADDR_WIDTH                       -1:0] scram_wraddr          ,
    input  wire [DATA_WIDTH                       -1:0] scram_wrdata          ,
    //  . Read  Port
    input  wire                                         scram_rden            ,
    input  wire [ADDR_WIDTH                       -1:0] scram_rdaddr          ,
    output wire [DATA_WIDTH                       -1:0] scram_rddata          
    //-------------------------------------------------------------------------
  );

// synopsys translate_off
// synthesis translate_off
  reg  [DATA_WIDTH   -1:0] ram_block [0:(2**ADDR_WIDTH)-1];
  wire [DATA_WIDTH/8 -1:0] write_enable;
  reg  [DATA_WIDTH   -1:0] scram_rddata_r ;
  reg                      scram_rden_r ;

  assign write_enable = {(DATA_WIDTH/8){scram_wren}} & scram_wrbe ;

  generate
  genvar i;
    for (i = 0 ; i < (DATA_WIDTH / 8) ; i = i+1)
    begin: wren_byte
      always @(posedge scram_clk)
      begin
        if (write_enable[i])
          ram_block[scram_wraddr][(i+1)*8 -1:i*8] <= scram_wrdata[(i+1)*8 -1:i*8];
      end
    end
  endgenerate

  always @(posedge scram_clk)
    scram_rddata_r <= {ram_block[scram_rdaddr]};

  always @(posedge scram_clk)
    scram_rden_r <= scram_rden ;

  assign scram_rddata = (scram_rden_r) ? scram_rddata_r : {(DATA_WIDTH){1'bZ}};
// synthesis translate_on
// synopsys translate_on


endmodule

`resetall