//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : XpressRich5-AXI IP Core
//-----------------------------------------------------------------------------
// Description: XR5AXI IP Core Dual-Clock RAM
// Dependency : 
//-----------------------------------------------------------------------------

`default_nettype none
`timescale 1 ns / 1 ps

module xr5axi_dcram
 #(
    //-------------------------------------------------------------------------
    parameter   ADDR_WIDTH              =    9, // Addr  Width in bits : 2**ADDR_WIDTH = RAM Depth
    parameter   DATA_WIDTH              =  256  // Data  Width in bits
    //-------------------------------------------------------------------------
  ) (
    //-------------------------------------------------------------------------
    // Buffer Interface
    //  . Write Port
    input  wire                                         dcram_wrclk           ,
    input  wire                                         dcram_wren            ,
    input  wire [ADDR_WIDTH                       -1:0] dcram_wraddr          ,
    input  wire [DATA_WIDTH                       -1:0] dcram_wrdata          ,
    //  . Read  Port
    input  wire                                         dcram_rdclk           ,
    input  wire                                         dcram_rden            ,
    input  wire [ADDR_WIDTH                       -1:0] dcram_rdaddr          ,
    output reg  [DATA_WIDTH                       -1:0] dcram_rddata          
    //-------------------------------------------------------------------------
  );

  reg  [DATA_WIDTH -1:0] ram_block [0:(2**ADDR_WIDTH)-1];

  // synthesis attribute ram_style of ram_block is pipe_distributed;
  always @(posedge dcram_wrclk)
    if (dcram_wren)
      ram_block[dcram_wraddr] <= dcram_wrdata;

  always @(posedge dcram_rdclk)
    dcram_rddata <= {ram_block[dcram_rdaddr]};


endmodule

`resetall

