//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : PIPE Monitor Checker
//-----------------------------------------------------------------------------
// Description: PIPE Monitor Checker Registers
// Dependency : 
//-----------------------------------------------------------------------------

`default_nettype none
`timescale 1 ns / 1 ps

`include "pipemc_config_h.v"

module pipemc_reg
 #(
    //---------------------------------------------------------------------------------
    parameter   ADDR_WIDTH        =    2, // Addr  Width in bits : 2**ADDR_WIDTH = RAM Depth
    parameter   DATA_WIDTH        =  256, // Data  Width in bits
    //---------------------------------------------------------------------------------
    parameter G_PIPE_INTF         = 'd1       ,
    parameter G_PCIE_NUM_LANES    = 'd16      ,
    parameter G_PIPE_WIDTH        = 'h88422       // Gen 4
    //---------------------------------------------------------------------------------
  ) (
    //---------------------------------------------------------------------------------
    // Registers Interface
    //  . Read Port
    input  wire                                                   reg_rdclk           ,
    input  wire                                                   reg_rden            ,
    input  wire [ADDR_WIDTH                                 -1:0] reg_rdaddr          ,
    output reg  [DATA_WIDTH                                 -1:0] reg_rddata          ,
    //---------------------------------------------------------------------------------
    //  RAM Interface
    input  wire                                                   reg_wrclk           ,
    //  . LTSSM RAM
    input  wire                                                   dcram_ltssm_wren    ,
    input  wire [`MEM_ADDR_WIDTH_LTSSM_PHASE                -1:0] dcram_ltssm_wraddr  ,
    //  . Reported Errors RAM
    input  wire                                                   dcram_rerr_wren     ,
    input  wire [`MEM_ADDR_WIDTH_RERR                       -1:0] dcram_rerr_wraddr   ,
    //  . Message Bus RAM
    input  wire [ G_PCIE_NUM_LANES                          -1:0] dcram_msgbus_wren   ,
    input  wire [(G_PCIE_NUM_LANES * `MEM_ADDR_WIDTH_MSGBUS)-1:0] dcram_msgbus_wraddr ,
    //  . Data Logic RAM | Event
    input  wire                                                   dcram_evntx_wren    ,
    input  wire [`MEM_ADDR_WIDTH_DATA_EVNT                  -1:0] dcram_evntx_wraddr             
    //---------------------------------------------------------------------------------
  );

  //localparam MEM_ADDR_WIDTH_TOT = `MEM_ADDR_WIDTH_LTSSM_PHASE + `MEM_DATAPATH_WIDTH + (G_PCIE_NUM_LANES * `MEM_ADDR_WIDTH_MSGBUS) + `MEM_ADDR_WIDTH_DATA_EVNT;
  localparam MEM_ADDR_WIDTH_TOT = 32;

  reg  [DATA_WIDTH -1:0] reg_block [0:(2**ADDR_WIDTH)-1];

  // synthesis attribute ram_style of ram_block is pipe_distributed;

  always @(posedge reg_wrclk) begin
    reg_block [0] <= {G_PIPE_INTF, G_PCIE_NUM_LANES, G_PIPE_WIDTH};
    reg_block [1] <= { {(DATA_WIDTH - MEM_ADDR_WIDTH_TOT){1'b0}},  dcram_ltssm_wraddr,  dcram_rerr_wraddr, dcram_evntx_wraddr,  dcram_msgbus_wraddr};
    reg_block [2] <= { (DATA_WIDTH){1'b1} };
    reg_block [3] <= { (DATA_WIDTH / 16){16'hCDAB}};
  end


  always @(posedge reg_rdclk)
    if (reg_rden)
      reg_rddata <= {reg_block[reg_rdaddr]};


endmodule

`resetall