//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : PIPE Monitor Checker
// Author  : nrigotti
//-----------------------------------------------------------------------------
// Description: Training Sequence Ordered Set Detector. Good luck :)
//
//              This module is composed of:
//                (1) Local declarations
//                (2) Output assignations
//                (3) TS Detector
//                (4) TS Field sampling
//
// Dependency : 
//-----------------------------------------------------------------------------

`default_nettype none
`timescale 1 ns / 1 ps

`include "pipemc_constant_h.v"

module eios_detector #(
    //-------------------------------------------------------------------------------
    //  Shift Registers Parameters
    parameter SHIFT_DATA_WIDTH  = 'd8 ,
    parameter SHIFT_DATAK_WIDTH = 'd1 ,
    parameter SHIFT_DATA_DEPTH  = 'd16
    //-------------------------------------------------------------------------------
  )(
    //-------------------------------------------------------------------------------
    //  Enable, Resets and Clock
    input  wire                                                en                   ,
    input  wire                                                arstn                , //  Asynchronous Reset
    input  wire                                                srstn                , //  Synchronous Reset
    input  wire                                                pclk                 ,
    //-------------------------------------------------------------------------------
    //  Data Encoding
    input  wire                                                data_encoding        ,
    //-------------------------------------------------------------------------------
    //  Parallel Data and DataK
    input  wire [SHIFT_DATA_DEPTH * SHIFT_DATA_WIDTH     -1:0] paral_data           ,
    input  wire [SHIFT_DATA_DEPTH * SHIFT_DATAK_WIDTH    -1:0] paral_datak          ,

    //-------------------------------------------------------------------------------
    //  Detection Signal
    output wire                                                detect_eios            
    //-------------------------------------------------------------------------------
  );

    //-------------------------------------------------------------------------
    // Local declarations 
    //-------------------------------------------------------------------------
    // Detection Flags
    reg                                                 reg_detect_eios       ;


    //-------------------------------------------------------------------------
    // Output assignations
    //-------------------------------------------------------------------------
    assign detect_eios = reg_detect_eios;

    //------------------------------------------------------------------------------------------------------------------
    // EIEOS Detectors
    //  see PCI Express® Base Specification Revision 5.0 Version 1.0 | 4.2.4.3 Electrical Idle Sequences (EIOS) (p 301)
    //------------------------------------------------------------------------------------------------------------------
    always @(posedge pclk or negedge arstn) begin
      if (!arstn) begin
        reg_detect_eios <= 1'b0;
      end
      else begin
        if(!srstn) begin
          reg_detect_eios <= 1'b0;
        end
        else if (en) begin
          if (!data_encoding &&
              {paral_datak[0], paral_data[7:0]} == `K_COM && // Symbol 0
              {paral_datak[1], paral_data[15:8], paral_datak[2], paral_data[23:16], paral_datak[3], paral_data[31:24]} == {(3){`K_IDL}} // Symbols 1-3
          )begin
            // $display ("[pmc] time=%0t \t EIOS Detect (2.5 or 5 GT/s)", $time);
            reg_detect_eios <= 1'b1;
          end
          else if (data_encoding &&
              paral_data == {(16){8'h66}} // Symbols 0-15
          )begin
            // $display ("[pmc] time=%0t \t EIOS Detect (8 GT/s or greater)", $time);
            reg_detect_eios <= 1'b1;
          end
          else
            reg_detect_eios <= 1'b0;
        end
      end
    end
   


endmodule