//-----------------------------------------------------------------------------
// This confidential and proprietary software may be used only as authorized by
// a licensing agreement from PLDA. In the event of publication, a copyright
// notice must be reproduced on all authorized copies.
//
//-----------------------------------------------------------------------------
// Project : PIPE Monitor/Checker
//-----------------------------------------------------------------------------
// Description: Frequency Monitor TestBench
//              
//              This module is composed of:
//                (1) Local Declarations
//                (2) Clocks and Reset
//                (3) Frequency Monitor Instantiation
//
// Dependency : freq_monitor
//-----------------------------------------------------------------------------


`default_nettype none
`timescale 1 ns / 1 ps

module tb ;

  // Parameters
  parameter  G_CNTR_WIDTH                       = 'd8  ;

  //---------------------------------------------------------------------------
  // Local Declarations
  //---------------------------------------------------------------------------

  // Clocks and Reset
  reg                                          en                    ;
  reg                                          rstn                  ;
  reg                                          pclk                  ;
  reg                                          refclk125             ;
  reg  [3                                -1:0] rate                  ;

  // Counter Output
  reg  [G_CNTR_WIDTH                     -1:0] cout                  ;


  //---------------------------------------------------------------------------
  // Clocks and Reset
  //---------------------------------------------------------------------------

  initial
  begin
    en        <= 1'b1 ;
    rstn      <= 1'b0 ;
    pclk      <= 1'b0 ;
    refclk125 <= 1'b0 ;
    rate      <= 2'd1 ;
    #80;
    rstn      <= 1'b1 ;
    #400
    rate      <= 2'd3 ;
    #400
    rate      <= 2'd2 ;
    #400
    rate      <= 2'd1 ;
    #400
    rate      <= 2'd0 ;
    #800;
    $finish;
  end

  // PCIeBFM pclk clock frequency is 62.5MHz @ 2.5Gbps; 125MHz @ 5.0Gbps; 250MHz @ 8.0Gbps; 500MHz @ 16.0Gbps
  always
  begin
    if      (rate == 2'd3) #1; // 500 MHz @ 16.0 Gbps
    else if (rate == 2'd2) #2; // 250 MHz @  8.0 Gbps
    else if (rate == 2'd1) #4; // 125 MHz @  5.0 Gbps
    else                   #8; // 62.5MHz @  2.5 Gbps
    pclk <= ~pclk ;
  end

  // Fixed 125 MHz reference clock
  always
  begin
    #4; // 125 MHz
    refclk125 <= ~refclk125 ;
  end


  //---------------------------------------------------------------------------
  // Frequence Monitor Instance
  //---------------------------------------------------------------------------

  freq_monitor #(
    .G_CNTR_WIDTH       ('d8      ),    // Max Freq (@RefClk=125 MHz) = 500  MHz
    .G_FDIV_CNTR_WIDTH  ('d3      )     // Min Freq (@RefClk=125 MHz) = 62.5 MHz
  )dut (  
    //-------------------------------------------------------------------------
    // Inputs
    //  . Clocks, EN and Resets
    .fm_en                   (en                      ),
    .fm_arstn                (rstn                    ),
    .fm_refclk               (refclk125               ),
    .fm_measclk              (pclk                    ),

    //-------------------------------------------------------------------------
    // Output
    //  . Counter Output
    .fm_cout                 (cout                    )
    //-------------------------------------------------------------------------
  );  


endmodule

`resetall