library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package DebugCode is

    -- converts std_logic into a character
    function to_char(sl: std_logic) return character;
    
    -- converts std_logic into a string (1 to 1)
    function debug_to_string(sl: std_logic) return string;
    -- converts std_logic_vector into a string (binary base)
    function debug_to_string(slv: std_logic_vector) return string;
    function debug_to_string(slv: signed) return string;
    function debug_to_string(slv: unsigned) return string;
    
    function debug_get_real_part(in_data: in std_logic_vector) return std_logic_vector; 
    function debug_get_imag_part(in_data: in std_logic_vector) return std_logic_vector;
    
    procedure debug_break(null_arg: integer := 0);
end package;

package body DebugCode is
    procedure debug_break(null_arg: integer := 0) is
    begin
        assert false report "Test: OK" severity failure;
    end procedure;

    -- converts std_logic into a character
    function to_char(sl: std_logic) return character is
       variable c: character;
    begin
       case sl is
            when 'U' => c:= 'U';
            when 'X' => c:= 'X';
            when '0' => c:= '0';
            when '1' => c:= '1';
            when 'Z' => c:= 'Z';
            when 'W' => c:= 'W';
            when 'L' => c:= 'L';
            when 'H' => c:= 'H';
            when '-' => c:= '-';
       end case;
       return c;
    end function to_char;
    
    -- converts std_logic into a string (1 to 1)
    function debug_to_string(sl: std_logic) return string is
       variable s: string(1 to 1);
    begin
       s(1):=to_char(sl);
       return s;
    end function debug_to_string;
    
    -- converts std_logic_vector into a string (binary base)
    -- (this also takes care of the fact that the range of
    --  a string is natural while a std_logic_vector may
    --  have an integer range)
    function debug_to_string(slv: std_logic_vector) return string is
       variable result : string (1 to slv'length);
       variable r      : integer;
    begin
       r:=1;
       for i in slv'range loop
           result(r) := to_char(slv(i));
           r:=r+1;
       end loop;
       return result;
    end function debug_to_string;

    function debug_to_string(slv: signed) return string is
           variable result : string (1 to slv'length);
           variable r      : integer;
    begin
       return debug_to_string(std_logic_vector(slv));
    end function debug_to_string;

    function debug_to_string(slv: unsigned) return string is
               variable result : string (1 to slv'length);
               variable r      : integer;
    begin
       return debug_to_string(std_logic_vector(slv));
    end function debug_to_string;

    function debug_get_real_part(in_data: in std_logic_vector) return std_logic_vector is
    begin
        -- We are having a frame with not extended size
        if in_data'length = 16 then
            return in_data(7 downto 0);
        elsif in_data'length = 28 then
            return in_data(13 downto 0);
        elsif in_data'length = 48 then -- Used when we are doign full width FFT with no resize and round.
            return in_data(19 downto 0); 
        else
            return in_data(13 downto 0); 
        end if;
    end;
    
    function debug_get_imag_part(in_data: in std_logic_vector) return std_logic_vector is
    begin
        -- We are having a frame with not extended size
        --- HACK HACK REMOVE IT ALL TOGETHER!!!!
        if in_data'length = 16 then
            return in_data(15 downto 8);
        elsif in_data'length = 28 then
              return in_data(27 downto 14);
        elsif in_data'length = 48 then -- Used when we are doign full width FFT with no resize and round.
            return in_data(43 downto 24); 
        else
            return in_data(29 downto 16);  
        end if;
    end;


end DebugCode;