library ieee;
use ieee.std_logic_1164.all;

entity SIPO is
generic (N: integer); 
port 
(
    Clk, Rst_n: in std_logic;
    En: in std_logic;
    Clr: in std_logic := '0';
    D: in std_logic;
    Q: out std_logic_vector(N-1 downto 0)
);
end SIPO;

architecture Behavioral of SIPO is
    component Reg1 is
    port
    (
        CLK:	in	 std_logic;
        Rst_n:	in	 std_logic;
        En:		in	 std_logic;
        Clr:    in   std_logic := '0';
        D:		in	 std_logic;
        Q:		out std_logic
    );
    end component;


    signal temp: std_logic_vector(N-1 downto 0);
begin
    
MainProc: process (Clk, Rst_n, En, Clr)
begin
    if Rst_n = '0' then
        temp <= (others => '0');
    elsif rising_edge(Clk) then
        temp <= temp;
        if Clr='1' then
            temp <= (others => '0');
        elsif En='1' then
            temp <= temp(N-2 downto 0) & D;
        end if;
    end if;
end process;

Q <= temp;


end;