library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Counter2 is
    generic (constant N: integer := 8;
			 constant MAX_VAL: integer
	);
	Port ( Rst_n : in std_logic;
           Clk : in std_logic;
           En : in std_logic;
           CntRst: in std_logic; -- When 1 reset the counte to 0 sync reset.
           CntValue : out unsigned(N-1 downto 0);
           TC : out std_logic);
end Counter2;

architecture Behavioral of Counter2 is
    signal Value: unsigned(N-1 downto 0) := (others => '0');
begin

UpdateProc: process(Clk, Rst_n, En)
begin
    if Rst_n='0' then
        Value <= (others => '0');
    elsif rising_edge(Clk) then
        if CntRst='1' then
            Value <= (others => '0');
        end if;
        if En='1' then
            if Value < (MAX_VAL-1) then
                Value <= Value + 1;
            else
                Value <= (others => '0');
            end if;
        end if;
    end if;
end process;    

TC <= '1' when Value=MAX_VAL-1 else '0';
CntValue <= Value;
 

end Behavioral;
