close all;
clear all;

% p =  27;
% p =  23;
p = 32768;

errorPerc = 60;
numOfIter = 5;
numOfInnerIter=10;

% errorPerc = 0.8;
addpath('..\matlab');
addpath('..\hw\fpga\models');
addpath('..\ref_impl\matlab\DecoderFunctions');


outInFile = fopen(sprintf('..\\hw\\fpga\\fft_vec_by_circ\\tb\\sim\\data_mat_%d.txt', p), 'w');
outRefFile = fopen(sprintf('..\\hw\\fpga\\fft_vec_by_circ\\tb\\sim\\result_mat_%d.txt', p), 'w');

extra_bits = 2;
for idx=1:numOfIter
     NSamples = p; 
     numErrors = ceil((errorPerc/100)*NSamples);
     
      a_data = zeros(1, NSamples); % round(rand(1, NSamples));
      a_data(1:3) = [1 0 1];
      
      
     for jdx=1:numOfInnerIter
         b_data = zeros(1, NSamples);
         % b_data(randi(numel(b_data), numErrors, 1))=1;
         b_data(1:32) = [1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0];
         
         [a_data_pad, b_data_pad, NSamples] = BitPadder(a_data, b_data, p);
    
         fprintf(outInFile, '%d', a_data_pad);   
         fprintf(outInFile, '&');  
         fprintf(outInFile, '%d', b_data_pad);   
         fprintf(outInFile, '\n');
        
         l = mod(NSamples - (find(b_data_pad~=0)-1), NSamples);
         [Res] = FFT_VecByCirc_IP(a_data, l, p, extra_bits);
         
         % Now create a file with the theoretical results in, rember to 
         % transform the bit position as the system as now dso not do 
         % the transponse 'yet'.
         error_pos = find(b_data ~= 0);
         error_pos = mod(NSamples - (error_pos-1), NSamples); 
         %Calculate the ref result:
         resVec = VectorByCirculant(a_data, error_pos, 0);
         
         fprintf(outRefFile, '%d', resVec);
         fprintf(outRefFile, '\n');
     end
end

fprintf('Done Generating Inputs\n');

fclose(outInFile);
fclose(outRefFile);