% This function is implemented using the xilink FFT IP.
function [Out, OutRe, OutIm, ovfl, quant] = MyXFFTScaled(fft_config, round_mode, bit_in_re, bit_in_im, isFFT)
    NSamples = length(bit_in_re);

    assert(length(bit_in_re) == length(bit_in_im));
    
    fft_quant = quantizer([fft_config.C_INPUT_WIDTH fft_config.C_INPUT_WIDTH-1], 'fixed', round_mode);
    if isFFT
        quant_input_data_re = bit_in_re;
        quant_input_data_re(quant_input_data_re == 1) = realmax(fft_quant);
        quant_input_data_im = bit_in_im;
    else
        quant_input_data_re = bit_in_re;
        quant_input_data_im = bit_in_im;
    end

    input_data = zeros(1, NSamples);
    for i=1:length(input_data)
        input_data(i)    = quant_input_data_re(i) + 1i.*quant_input_data_im(i);
    end
       
    assert(fft_config.C_HAS_SCALING==1);

    % when we perform an IFFT, we do not want to scale at any stage,
    % because we arleady have a 1/s intrinsic in the operation.
    scale_factor = 2;
    if isFFT==0
       scale_factor = 0;
    end
        
    nfft = fft_config.C_NFFT_MAX;
    if fft_config.C_ARCH == 1 || fft_config.C_ARCH == 3
       scaling_sch = ones(1,floor(nfft/2))*scale_factor;
       if mod(nfft,2) == 1 
           scaling_sch = [scaling_sch scale_factor/2];
       end
    else
        scaling_sch = zeros(1, nfft);
    end
    
    % Calculaate the FFT
    [fft_out, blkexp_fft, overflow_fft] = xfft_v9_1_bitacc_mex(fft_config, 0, input_data,  scaling_sch, isFFT);
    ovfl = overflow_fft;
    quant = fft_quant;
    
    Out = fft_out;
    OutRe = real(Out);
    OutIm = imag(Out);
end    





