function [Out, OutRe, OutIm, ovfl] = MyXFFT(fft_config, round_mode, bit_in_re, bit_in_im, isFFT,  varargin)
    NSamples = length(bit_in_re);

    assert(length(bit_in_re) == length(bit_in_im));
    
    fft_quant = quantizer([fft_config.C_INPUT_WIDTH fft_config.C_INPUT_WIDTH-1], 'fixed', round_mode);
    if isFFT
        quant_input_data_re = bit_in_re;
        quant_input_data_re(quant_input_data_re == 1) = realmax(fft_quant);
        
        quant_input_data_im = bit_in_im;
    else
        quant_input_data_re = bit_in_re;
        quant_input_data_im = bit_in_im;
    end
    
    if nargin < 6
       outQuant = fft_quant;
    else
       left_size = varargin{1}; 
       right_size = left_size-1;
       if nargin > 6
          right_size = varargin{2};
       end
       
       outQuant = quantizer([left_size right_size], 'fixed', round_mode, 'saturate');
    end

    input_data = zeros(1, NSamples);
    for i=1:length(input_data)
        input_data(i)    = quant_input_data_re(i) + 1i.*quant_input_data_im(i);
    end
       
    % Calculaate the FFT
    [fft_out, blkexp_fft, overflow_fft] = xfft_v9_1_bitacc_mex(fft_config, 0, input_data,  [], isFFT);
    ovfl = overflow_fft;
    

    if isFFT
      % We need to requantize the result back to Q1.7
      norm_out = fft_out / NSamples;
      Out = quantize(outQuant, norm_out);
    else
      Out = fft_out;
    end 
    
    OutRe = real(Out);
    OutIm = imag(Out);
end 