function [Out, OutRe, OutIm] = MyCMul(A_Data, B_Data, outNumOfBits, round_mode)
    NSamples = length(A_Data);
    assert(length(A_Data) == length(B_Data));
     
    A_re = real(A_Data);
    A_im = imag(A_Data);

    B_re = real(B_Data);
    B_im = imag(B_Data);

    Out = zeros(1, NSamples);
    OutRe_unsc = zeros(1, NSamples);
    OutIm_unsc = zeros(1, NSamples);
    for idx=1:NSamples 
        %OutRe_unsc(idx)  = A_re(idx)*B_re(idx) - A_im(idx)*B_im(idx);
        %OutIm_unsc(idx)  = A_re(idx)*B_im(idx) + A_im(idx)*B_re(idx);
        OutRe_unsc(idx) =  A_re(idx)*(B_re(idx) + B_im(idx)) - B_im(idx)*(A_re(idx) + A_im(idx));
        OutIm_unsc(idx) =  A_re(idx)*(B_re(idx) + B_im(idx)) + B_re(idx)*(A_im(idx) - A_re(idx));
    end

    % This should be the same but I just wanna be sure so I use the above
    % for loop.
%        OutRe_unsc  = A_re.*B_re - A_im.*B_im;
%        OutIm_unsc  = A_re.*B_im + A_im.*B_re;
    
    

    c_mul_quant = quantizer('format', [outNumOfBits outNumOfBits-1], 'mode', 'fixed', 'roundmode', round_mode);
    OutRe = quantize(c_mul_quant, OutRe_unsc);
    OutIm = quantize(c_mul_quant, OutIm_unsc);
    
    
    for idx=1:NSamples 
        Out(idx) = OutRe(idx) + 1i*OutIm(idx);
    end
end

