% This function return the number of bit to obtain the extended power of
% two FFT given a number of sample that is not a power of two
function [Result] = GetPaddedSampleCount(Sample)
    % If we have arleady a sequence of power of two return it.
    if 2^(MyLog2(Sample)) == Sample 
        Result = Sample;
    else
        % Obtain the extended sequence length that is the next power two
        % near to 2p.
        Result = 2^(nextpow2(2*Sample-3));
    end
end
