
function [OutVec, NSamples_ext] =  BPadder(MEM, P_VALUE)
    P_VALUE_EXT = 2^(nextpow2(2*P_VALUE - 3));

	LEFT_BITS = mod(P_VALUE_EXT, P_VALUE);
	PAD_BITS  = P_VALUE_EXT - LEFT_BITS;
	FRAME_COUNT = PAD_BITS / P_VALUE;
		
	assert(LEFT_BITS + PAD_BITS == P_VALUE_EXT);
		
	m_idx = 0; % Current Frame Counter Index
	f_idx = 0; % Frame Index

    totBits = 0;
    
   %  OutVec = zeros(1, P_VALUE_EXT);
    NSamples_ext = P_VALUE_EXT;
    currFrameIdx = 0;
    procLeftBits = 0;
    
	while 1
		currFrameCheckId = MEM(m_idx+1);
		if (currFrameCheckId == currFrameIdx)
			m_idx = m_idx + 1;
			OutVec((currFrameIdx + f_idx*P_VALUE)+1) = 1;
        else
			OutVec((currFrameIdx + f_idx*P_VALUE)+1) = 0;
        end
        
        % Not read too much elements!
        if m_idx >= length(MEM)
            m_idx = 0;
            fprintf('\n');
        end

        %lTest = totBits - f_idx*P_VALUE;
%         if f_idx > 0
%             lTest = lTest - 1;
%         end
        
        %fprintf('%d -> %d = %d\n', f_idx, currFrameIdx, lTest);
        %assert(currFrameIdx == lTest);
        
        currFrameIdx = currFrameIdx + 1;
        
		% We processed enough bits to have complete a frame length, now two case can happens.
		% if totBits are bigger than FRAME_COUNT*p than we should see if need to add additional bits.
		% Int this case, we sclcee if LEFT_BITS != 0. Else we are lucky and we just end the loop.
		% Anyway here w ehave to reset the  mIdx and the currFrameIdx to make the circuit emit a new 
		% frame data.
		if (totBits == (P_VALUE)*(f_idx+1))
			m_idx = 0;
            f_idx = f_idx  + 1;
            currFrameIdx = 0;
        end

		% Over all we end when we have output all the bits
		if (totBits == P_VALUE_EXT)
			break;
        else
            % Increment the total number of processe dbits
            totBits = totBits + 1;
        end
    end
end
