% MEM is Nb bit per row. So we have total rows, ceil(p/Nb)
% !---------! last bit is te first in
function [OutVec, NSamples_ext] =  BPadder(MEM, Nb, p)

DEFAULT_DEBUG_VALUE = 5;

    P_VALUE = p - 1;
    P_VALUE_EXT = 2^(nextpow2(2*P_VALUE - 3))-1;
    PAD_BITS = P_VALUE_EXT - P_VALUE;
    
    LAST_PAD_BITS_POS = PAD_BITS;
    LAST_FIRST_ROW_BIT = LAST_PAD_BITS_POS + (Nb-1);
    
    r_idx = 0;
    mem_idx = 0;
    bit_idx = 0;
    
    OutVec = DEFAULT_DEBUG_VALUE*ones(1, P_VALUE_EXT+1);
    OutVec(22) = 7;
    
    NSamples_ext = P_VALUE_EXT+1;

	for bit_idx=0:P_VALUE_EXT    
        currRow = MEM(mem_idx+1,:);
        if bit_idx == 0  
            OutVec(1) = currRow(1+r_idx);
            r_idx = r_idx + 1;           
        elseif bit_idx <= LAST_PAD_BITS_POS 
            OutVec(1+bit_idx) = 0;% DEBUG::0; 
%         elseif  bit_idx <= LAST_FIRST_ROW_BIT 
%             %NOTE: It could be good to use modulo operator here but apparently non pow2 mod is difficult
%             % to implement in hardware so we allocate another, "small Nb counter" to do so but that can be even be the 
%             % lower Nb bits of bit_cnt?? 
%             % i_idx = mod(1+bit_idx-LAST_PAD_BITS_POS, Nb);
%             OutVec(1+bit_idx) = currRow(1+r_idx);
% 
%             % Here we count from 0 to Nb so we look for Nb-1 as
%             % the last value.
%             if r_idx == Nb-1
%                 r_idx = 0;
%                 mem_idx = mem_idx + 1;
%             else
%                 r_idx = r_idx + 1;
%             end
        elseif bit_idx > LAST_PAD_BITS_POS
            %NOTE: It could be good to use modulo operator here but apparently non pow2 mod is difficult
            % to implement in hardware so we allocate another, "small Nb counter" to do so but that can be even be the 
            % lower Nb bits of bit_cnt?? 
            % i_idx = mod(bit_idx-LAST_FIRST_ROW_BIT, Nb);
                      
            OutVec(1+bit_idx) = currRow(1+r_idx);
            
             
            % When we emit Nb bit, read next row.
            if r_idx == Nb-1    
                r_idx = 0;
                mem_idx = mem_idx + 1;
            else
                r_idx = r_idx + 1;
            end
        else
            % Just for debug ourposed to assure we never hit this case.
            assert(0);
        end
        
       % bit_idx = bit_idx + 1;
    end
    
    assert(isempty(OutVec(OutVec==DEFAULT_DEBUG_VALUE)));
end
